/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.exifinterface.media.ExifInterface;
import androidx.fragment.app.FragmentActivity;
import com.canhub.cropper.BitmapCroppingWorkerJob;
import com.canhub.cropper.BitmapLoadingWorkerJob;
import com.canhub.cropper.BitmapUtils;
import com.canhub.cropper.CropImageAnimation;
import com.canhub.cropper.CropImageOptions;
import com.canhub.cropper.CropOverlayView;
import com.canhub.cropper.R;
import java.lang.ref.WeakReference;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\"\u0018\u0000 \u00e4\u00012\u00020\u00012\u00020\u0002:\u0016\u00e4\u0001\u00e5\u0001\u00e6\u0001\u00e7\u0001\u00e8\u0001\u00e9\u0001\u00ea\u0001\u00eb\u0001\u00ec\u0001\u00ed\u0001\u00ee\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020|2\u0007\u0010\u0090\u0001\u001a\u00020|2\u0007\u0010\u0091\u0001\u001a\u0002082\u0007\u0010\u0092\u0001\u001a\u000208H\u0002J\b\u0010\u0093\u0001\u001a\u00030\u008e\u0001J\b\u0010\u0094\u0001\u001a\u00030\u008e\u0001J\n\u0010\u0095\u0001\u001a\u00030\u008e\u0001H\u0002J\b\u0010\u0096\u0001\u001a\u00030\u008e\u0001J\b\u0010\u0097\u0001\u001a\u00030\u008e\u0001J\u001a\u0010$\u001a\u0004\u0018\u00010#2\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\nJ$\u0010$\u001a\u0004\u0018\u00010#2\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\n2\b\u0010\u009a\u0001\u001a\u00030\u009b\u0001J\b\u0010\u009c\u0001\u001a\u00030\u008e\u0001J\u001a\u0010\u009c\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\nJ$\u0010\u009c\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\n2\b\u0010\u009a\u0001\u001a\u00030\u009b\u0001J\u001c\u0010\u009d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u009e\u0001\u001a\u0002082\u0007\u0010\u0092\u0001\u001a\u000208H\u0002J\n\u0010\u009f\u0001\u001a\u00030\u008e\u0001H\u0002J\u0013\u0010\u00a0\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u009e\u0001\u001a\u000208H\u0016J\u0012\u0010\u00a1\u0001\u001a\u00030\u008e\u00012\b\u0010\u00a2\u0001\u001a\u00030\u00a3\u0001J7\u0010\u00a4\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u00a5\u0001\u001a\u0002082\u0007\u0010\u00a6\u0001\u001a\u00020\n2\u0007\u0010\u00a7\u0001\u001a\u00020\n2\u0007\u0010\u00a8\u0001\u001a\u00020\n2\u0007\u0010\u00a9\u0001\u001a\u00020\nH\u0014J\u001c\u0010\u00aa\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u00ab\u0001\u001a\u00020\n2\u0007\u0010\u00ac\u0001\u001a\u00020\nH\u0014J\u0014\u0010\u00ad\u0001\u001a\u00030\u008e\u00012\b\u0010\u00ae\u0001\u001a\u00030\u00af\u0001H\u0016J\f\u0010\u00b0\u0001\u001a\u0005\u0018\u00010\u00af\u0001H\u0016J\u0012\u0010\u00b1\u0001\u001a\u00030\u008e\u00012\b\u0010\u00a2\u0001\u001a\u00030\u00b2\u0001J.\u0010\u00b3\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u00b4\u0001\u001a\u00020\n2\u0007\u0010\u00b5\u0001\u001a\u00020\n2\u0007\u0010\u00b6\u0001\u001a\u00020\n2\u0007\u0010\u00b7\u0001\u001a\u00020\nH\u0014J\b\u0010\u00b8\u0001\u001a\u00030\u008e\u0001J\u0011\u0010\u00b9\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u0082\u0001\u001a\u00020\nJF\u0010\u00ba\u0001\u001a\u00030\u008e\u00012\t\u0010\u00bb\u0001\u001a\u0004\u0018\u0001032\b\u0010\u00bc\u0001\u001a\u00030\u00bd\u00012\u0007\u0010\u00be\u0001\u001a\u00020\n2\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\n2\n\b\u0002\u0010\u009a\u0001\u001a\u00030\u009b\u0001H\u0007J\u001a\u0010\u00bf\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u00c0\u0001\u001a\u00020\n2\u0007\u0010\u00c1\u0001\u001a\u00020\nJ9\u0010\u00c2\u0001\u001a\u00030\u008e\u00012\t\u0010\u00c3\u0001\u001a\u0004\u0018\u00010#2\u0006\u0010-\u001a\u00020\n2\b\u00104\u001a\u0004\u0018\u0001032\u0007\u0010\u00c4\u0001\u001a\u00020\n2\u0007\u0010\u00c5\u0001\u001a\u00020\nH\u0002J\u0011\u0010\u00c6\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u00c7\u0001\u001a\u000208J\n\u0010\u00c8\u0001\u001a\u00030\u008e\u0001H\u0002J\u0011\u0010\u00c9\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u00ca\u0001\u001a\u000208J\u0013\u0010\u00cb\u0001\u001a\u00030\u008e\u00012\t\u0010\u00c3\u0001\u001a\u0004\u0018\u00010#J\u001f\u0010\u00cb\u0001\u001a\u00030\u008e\u00012\t\u0010\u00c3\u0001\u001a\u0004\u0018\u00010#2\n\u0010\u00cc\u0001\u001a\u0005\u0018\u00010\u00cd\u0001J\u0013\u0010\u00ce\u0001\u001a\u00030\u008e\u00012\t\u0010\u00cf\u0001\u001a\u0004\u0018\u000103J\u001a\u0010\u00d0\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u00d1\u0001\u001a\u00020\n2\u0007\u0010\u00d2\u0001\u001a\u00020\nJ\u001a\u0010\u00d3\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u00d4\u0001\u001a\u00020\n2\u0007\u0010\u00d5\u0001\u001a\u00020\nJ\u0011\u0010\u00d6\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u00d7\u0001\u001a\u000208J\u0013\u0010\u00d8\u0001\u001a\u00030\u008e\u00012\t\u0010\u00d9\u0001\u001a\u0004\u0018\u00010gJ\u0013\u0010\u00da\u0001\u001a\u00030\u008e\u00012\t\u0010\u00d9\u0001\u001a\u0004\u0018\u00010mJ\u0013\u0010\u00db\u0001\u001a\u00030\u008e\u00012\t\u0010\u00d9\u0001\u001a\u0004\u0018\u00010kJ\u0013\u0010\u00dc\u0001\u001a\u00030\u008e\u00012\t\u0010\u00d9\u0001\u001a\u0004\u0018\u00010iJ\u0013\u0010\u00dd\u0001\u001a\u00030\u008e\u00012\t\u0010\u00d9\u0001\u001a\u0004\u0018\u00010oJ\n\u0010\u00de\u0001\u001a\u00030\u008e\u0001H\u0002J\u0011\u0010\u00df\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u00e0\u0001\u001a\u00020|JB\u0010\u00e1\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\n2\b\u0010\u009a\u0001\u001a\u00030\u009b\u00012\t\u0010\u00bb\u0001\u001a\u0004\u0018\u0001032\b\u0010\u00bc\u0001\u001a\u00030\u00bd\u00012\u0007\u0010\u00be\u0001\u001a\u00020\nJ\u0013\u0010\u00e2\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u00e3\u0001\u001a\u000208H\u0002R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R(\u0010&\u001a\u0004\u0018\u00010'2\b\u0010&\u001a\u0004\u0018\u00010'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R$\u0010-\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\"\u00104\u001a\u0004\u0018\u0001032\b\u00102\u001a\u0004\u0018\u000103@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R$\u00109\u001a\u0002082\u0006\u00107\u001a\u0002088F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0011\u0010=\u001a\u0002088F\u00a2\u0006\u0006\u001a\u0004\b=\u0010:R$\u0010?\u001a\u0002082\u0006\u0010>\u001a\u0002088F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010:\"\u0004\b@\u0010<R$\u0010B\u001a\u0002082\u0006\u0010A\u001a\u0002088F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010:\"\u0004\bC\u0010<R\u001a\u0010D\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010:\"\u0004\bE\u0010<R$\u0010G\u001a\u0002082\u0006\u0010F\u001a\u0002088F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010:\"\u0004\bH\u0010<R$\u0010J\u001a\u0002082\u0006\u0010I\u001a\u0002088F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bJ\u0010:\"\u0004\bK\u0010<R\u0010\u0010L\u001a\u0004\u0018\u00010MX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010P\u001a\n\u0012\u0004\u0012\u00020R\u0018\u00010QX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010S\u001a\n\u0012\u0004\u0012\u00020T\u0018\u00010QX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010U\u001a\u0004\u0018\u00010VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020[X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\\\u001a\u00020[X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010^\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020`X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010d\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010f\u001a\u0004\u0018\u00010gX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010h\u001a\u0004\u0018\u00010iX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010j\u001a\u0004\u0018\u00010kX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010l\u001a\u0004\u0018\u00010mX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010n\u001a\u0004\u0018\u00010oX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010p\u001a\u00020qX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010r\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010s\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010t\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010u\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010v\u001a\u00020wX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010x\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010y\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010z\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010{\u001a\u00020|X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010}\u001a\u00020|X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010~\u001a\u00020|X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u007f\u001a\u00020\n2\u0006\u0010\u007f\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\u000e\u001a\u0005\b\u0080\u0001\u0010/\"\u0005\b\u0081\u0001\u00101R(\u0010\u0083\u0001\u001a\u00020\n2\u0007\u0010\u0082\u0001\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\u000e\u001a\u0005\b\u0084\u0001\u0010/\"\u0005\b\u0085\u0001\u00101R*\u0010\u0086\u0001\u001a\u00020w2\u0007\u0010\u0086\u0001\u001a\u00020w8F@FX\u0086\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001\"\u0006\b\u0089\u0001\u0010\u008a\u0001R\u0015\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0007\u001a\u0005\b\u008c\u0001\u0010\u0015\u00a8\u0006\u00ef\u0001"}, d2={"Lcom/canhub/cropper/CropImageView;", "Landroid/widget/FrameLayout;", "Lcom/canhub/cropper/CropOverlayView$CropWindowChangeListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "aspectRatio", "Landroid/util/Pair;", "", "getAspectRatio", "()Landroid/util/Pair;", "cropPoints", "", "getCropPoints", "()[F", "rect", "Landroid/graphics/Rect;", "cropRect", "getCropRect", "()Landroid/graphics/Rect;", "setCropRect", "(Landroid/graphics/Rect;)V", "cropShape", "Lcom/canhub/cropper/CropImageView$CropShape;", "getCropShape", "()Lcom/canhub/cropper/CropImageView$CropShape;", "setCropShape", "(Lcom/canhub/cropper/CropImageView$CropShape;)V", "cropWindowRect", "Landroid/graphics/RectF;", "getCropWindowRect", "()Landroid/graphics/RectF;", "croppedImage", "Landroid/graphics/Bitmap;", "getCroppedImage", "()Landroid/graphics/Bitmap;", "guidelines", "Lcom/canhub/cropper/CropImageView$Guidelines;", "getGuidelines", "()Lcom/canhub/cropper/CropImageView$Guidelines;", "setGuidelines", "(Lcom/canhub/cropper/CropImageView$Guidelines;)V", "resId", "imageResource", "getImageResource", "()I", "setImageResource", "(I)V", "<set-?>", "Landroid/net/Uri;", "imageUri", "getImageUri", "()Landroid/net/Uri;", "autoZoomEnabled", "", "isAutoZoomEnabled", "()Z", "setAutoZoomEnabled", "(Z)V", "isFixAspectRatio", "flipHorizontally", "isFlippedHorizontally", "setFlippedHorizontally", "flipVertically", "isFlippedVertically", "setFlippedVertically", "isSaveBitmapToInstanceState", "setSaveBitmapToInstanceState", "showCropOverlay", "isShowCropOverlay", "setShowCropOverlay", "showProgressBar", "isShowProgressBar", "setShowProgressBar", "mAnimation", "Lcom/canhub/cropper/CropImageAnimation;", "mAutoZoomEnabled", "mBitmap", "mBitmapCroppingWorkerJob", "Ljava/lang/ref/WeakReference;", "Lcom/canhub/cropper/BitmapCroppingWorkerJob;", "mBitmapLoadingWorkerJob", "Lcom/canhub/cropper/BitmapLoadingWorkerJob;", "mCropOverlayView", "Lcom/canhub/cropper/CropOverlayView;", "mDegreesRotated", "mFlipHorizontally", "mFlipVertically", "mImageInverseMatrix", "Landroid/graphics/Matrix;", "mImageMatrix", "mImagePoints", "mImageResource", "mImageView", "Landroid/widget/ImageView;", "mInitialDegreesRotated", "mLayoutHeight", "mLayoutWidth", "mLoadedSampleSize", "mMaxZoom", "mOnCropImageCompleteListener", "Lcom/canhub/cropper/CropImageView$OnCropImageCompleteListener;", "mOnCropOverlayReleasedListener", "Lcom/canhub/cropper/CropImageView$OnSetCropOverlayReleasedListener;", "mOnSetCropOverlayMovedListener", "Lcom/canhub/cropper/CropImageView$OnSetCropOverlayMovedListener;", "mOnSetCropWindowChangeListener", "Lcom/canhub/cropper/CropImageView$OnSetCropWindowChangeListener;", "mOnSetImageUriCompleteListener", "Lcom/canhub/cropper/CropImageView$OnSetImageUriCompleteListener;", "mProgressBar", "Landroid/widget/ProgressBar;", "mRestoreCropWindowRect", "mRestoreDegreesRotated", "mSaveInstanceStateBitmapUri", "mScaleImagePoints", "mScaleType", "Lcom/canhub/cropper/CropImageView$ScaleType;", "mShowCropOverlay", "mShowProgressBar", "mSizeChanged", "mZoom", "", "mZoomOffsetX", "mZoomOffsetY", "maxZoom", "getMaxZoom", "setMaxZoom", "degrees", "rotatedDegrees", "getRotatedDegrees", "setRotatedDegrees", "scaleType", "getScaleType", "()Lcom/canhub/cropper/CropImageView$ScaleType;", "setScaleType", "(Lcom/canhub/cropper/CropImageView$ScaleType;)V", "wholeImageRect", "getWholeImageRect", "applyImageMatrix", "", "width", "height", "center", "animate", "clearAspectRatio", "clearImage", "clearImageInt", "flipImageHorizontally", "flipImageVertically", "reqWidth", "reqHeight", "options", "Lcom/canhub/cropper/CropImageView$RequestSizeOptions;", "getCroppedImageAsync", "handleCropWindowChanged", "inProgress", "mapImagePointsByImageMatrix", "onCropWindowChanged", "onImageCroppingAsyncComplete", "result", "Lcom/canhub/cropper/BitmapCroppingWorkerJob$Result;", "onLayout", "changed", "l", "t", "r", "b", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onSetImageUriAsyncComplete", "Lcom/canhub/cropper/BitmapLoadingWorkerJob$Result;", "onSizeChanged", "w", "h", "oldw", "oldh", "resetCropRect", "rotateImage", "saveCroppedImageAsync", "saveUri", "saveCompressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "saveCompressQuality", "setAspectRatio", "aspectRatioX", "aspectRatioY", "setBitmap", "bitmap", "loadSampleSize", "degreesRotated", "setCenterMoveEnabled", "centerMoveEnabled", "setCropOverlayVisibility", "setFixedAspectRatio", "fixAspectRatio", "setImageBitmap", "exif", "Landroidx/exifinterface/media/ExifInterface;", "setImageUriAsync", "uri", "setMaxCropResultSize", "maxCropResultWidth", "maxCropResultHeight", "setMinCropResultSize", "minCropResultWidth", "minCropResultHeight", "setMultiTouchEnabled", "multiTouchEnabled", "setOnCropImageCompleteListener", "listener", "setOnCropWindowChangedListener", "setOnSetCropOverlayMovedListener", "setOnSetCropOverlayReleasedListener", "setOnSetImageUriCompleteListener", "setProgressBarVisibility", "setSnapRadius", "snapRadius", "startCropWorkerTask", "updateImageBounds", "clear", "Companion", "CropResult", "CropShape", "Guidelines", "OnCropImageCompleteListener", "OnSetCropOverlayMovedListener", "OnSetCropOverlayReleasedListener", "OnSetCropWindowChangeListener", "OnSetImageUriCompleteListener", "RequestSizeOptions", "ScaleType", "cropper_release"})
public final class CropImageView
extends FrameLayout
implements CropOverlayView.CropWindowChangeListener {
    private final ImageView mImageView;
    private final CropOverlayView mCropOverlayView;
    private final Matrix mImageMatrix;
    private final Matrix mImageInverseMatrix;
    private final ProgressBar mProgressBar;
    private final float[] mImagePoints;
    private final float[] mScaleImagePoints;
    private CropImageAnimation mAnimation;
    private Bitmap mBitmap;
    private int mInitialDegreesRotated;
    private int mDegreesRotated;
    private boolean mFlipHorizontally;
    private boolean mFlipVertically;
    private int mLayoutWidth;
    private int mLayoutHeight;
    private int mImageResource;
    private ScaleType mScaleType;
    private boolean isSaveBitmapToInstanceState;
    private boolean mShowCropOverlay;
    private boolean mShowProgressBar;
    private boolean mAutoZoomEnabled;
    private int mMaxZoom;
    private OnSetCropOverlayReleasedListener mOnCropOverlayReleasedListener;
    private OnSetCropOverlayMovedListener mOnSetCropOverlayMovedListener;
    private OnSetCropWindowChangeListener mOnSetCropWindowChangeListener;
    private OnSetImageUriCompleteListener mOnSetImageUriCompleteListener;
    private OnCropImageCompleteListener mOnCropImageCompleteListener;
    @Nullable
    private Uri imageUri;
    private int mLoadedSampleSize;
    private float mZoom;
    private float mZoomOffsetX;
    private float mZoomOffsetY;
    private RectF mRestoreCropWindowRect;
    private int mRestoreDegreesRotated;
    private boolean mSizeChanged;
    private Uri mSaveInstanceStateBitmapUri;
    private WeakReference<BitmapLoadingWorkerJob> mBitmapLoadingWorkerJob;
    private WeakReference<BitmapCroppingWorkerJob> mBitmapCroppingWorkerJob;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isSaveBitmapToInstanceState() {
        return this.isSaveBitmapToInstanceState;
    }

    public final void setSaveBitmapToInstanceState(boolean bl) {
        this.isSaveBitmapToInstanceState = bl;
    }

    @Nullable
    public final Uri getImageUri() {
        return this.imageUri;
    }

    @NotNull
    public final ScaleType getScaleType() {
        return this.mScaleType;
    }

    public final void setScaleType(@NotNull ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)((Object)scaleType), (String)"scaleType");
        if (scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.mZoom = 1.0f;
            this.mZoomOffsetX = this.mZoomOffsetY = 0.0f;
            CropOverlayView cropOverlayView = this.mCropOverlayView;
            if (cropOverlayView != null) {
                cropOverlayView.resetCropOverlayView();
            }
            this.requestLayout();
        }
    }

    @Nullable
    public final CropShape getCropShape() {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        return cropOverlayView.getCropShape();
    }

    public final void setCropShape(@Nullable CropShape cropShape) {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        CropShape cropShape2 = cropShape;
        Intrinsics.checkNotNull((Object)((Object)cropShape2));
        cropOverlayView.setCropShape(cropShape2);
    }

    public final boolean isAutoZoomEnabled() {
        return this.mAutoZoomEnabled;
    }

    public final void setAutoZoomEnabled(boolean autoZoomEnabled) {
        if (this.mAutoZoomEnabled != autoZoomEnabled) {
            this.mAutoZoomEnabled = autoZoomEnabled;
            this.handleCropWindowChanged(false, false);
            CropOverlayView cropOverlayView = this.mCropOverlayView;
            Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
            cropOverlayView.invalidate();
        }
    }

    public final void setMultiTouchEnabled(boolean multiTouchEnabled) {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        if (cropOverlayView.setMultiTouchEnabled(multiTouchEnabled)) {
            this.handleCropWindowChanged(false, false);
            this.mCropOverlayView.invalidate();
        }
    }

    public final void setCenterMoveEnabled(boolean centerMoveEnabled) {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        if (cropOverlayView.setCenterMoveEnabled(centerMoveEnabled)) {
            this.handleCropWindowChanged(false, false);
            this.mCropOverlayView.invalidate();
        }
    }

    public final int getMaxZoom() {
        return this.mMaxZoom;
    }

    public final void setMaxZoom(int maxZoom) {
        if (this.mMaxZoom != maxZoom && maxZoom > 0) {
            this.mMaxZoom = maxZoom;
            this.handleCropWindowChanged(false, false);
            CropOverlayView cropOverlayView = this.mCropOverlayView;
            Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
            cropOverlayView.invalidate();
        }
    }

    public final void setMinCropResultSize(int minCropResultWidth, int minCropResultHeight) {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        cropOverlayView.setMinCropResultSize(minCropResultWidth, minCropResultHeight);
    }

    public final void setMaxCropResultSize(int maxCropResultWidth, int maxCropResultHeight) {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        cropOverlayView.setMaxCropResultSize(maxCropResultWidth, maxCropResultHeight);
    }

    public final int getRotatedDegrees() {
        return this.mDegreesRotated;
    }

    public final void setRotatedDegrees(int degrees) {
        if (this.mDegreesRotated != degrees) {
            this.rotateImage(degrees - this.mDegreesRotated);
        }
    }

    public final boolean isFixAspectRatio() {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        return cropOverlayView.isFixAspectRatio();
    }

    public final void setFixedAspectRatio(boolean fixAspectRatio) {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        cropOverlayView.setFixedAspectRatio(fixAspectRatio);
    }

    public final boolean isFlippedHorizontally() {
        return this.mFlipHorizontally;
    }

    public final void setFlippedHorizontally(boolean flipHorizontally) {
        if (this.mFlipHorizontally != flipHorizontally) {
            this.mFlipHorizontally = flipHorizontally;
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
        }
    }

    public final boolean isFlippedVertically() {
        return this.mFlipVertically;
    }

    public final void setFlippedVertically(boolean flipVertically) {
        if (this.mFlipVertically != flipVertically) {
            this.mFlipVertically = flipVertically;
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
        }
    }

    @Nullable
    public final Guidelines getGuidelines() {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        return cropOverlayView.getGuidelines();
    }

    public final void setGuidelines(@Nullable Guidelines guidelines) {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        Guidelines guidelines2 = guidelines;
        Intrinsics.checkNotNull((Object)((Object)guidelines2));
        cropOverlayView.setGuidelines(guidelines2);
    }

    @NotNull
    public final Pair<Integer, Integer> getAspectRatio() {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        return new Pair((Object)cropOverlayView.getAspectRatioX(), (Object)this.mCropOverlayView.getAspectRatioY());
    }

    public final void setAspectRatio(int aspectRatioX, int aspectRatioY) {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        cropOverlayView.setAspectRatioX(aspectRatioX);
        this.mCropOverlayView.setAspectRatioY(aspectRatioY);
        this.setFixedAspectRatio(true);
    }

    public final void clearAspectRatio() {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        cropOverlayView.setAspectRatioX(1);
        this.mCropOverlayView.setAspectRatioY(1);
        this.setFixedAspectRatio(false);
    }

    public final void setSnapRadius(float snapRadius) {
        if (snapRadius >= 0.0f) {
            CropOverlayView cropOverlayView = this.mCropOverlayView;
            Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
            cropOverlayView.setSnapRadius(snapRadius);
        }
    }

    public final boolean isShowProgressBar() {
        return this.mShowProgressBar;
    }

    public final void setShowProgressBar(boolean showProgressBar) {
        if (this.mShowProgressBar != showProgressBar) {
            this.mShowProgressBar = showProgressBar;
            this.setProgressBarVisibility();
        }
    }

    public final boolean isShowCropOverlay() {
        return this.mShowCropOverlay;
    }

    public final void setShowCropOverlay(boolean showCropOverlay) {
        if (this.mShowCropOverlay != showCropOverlay) {
            this.mShowCropOverlay = showCropOverlay;
            this.setCropOverlayVisibility();
        }
    }

    public final int getImageResource() {
        return this.mImageResource;
    }

    public final void setImageResource(int resId) {
        if (resId != 0) {
            CropOverlayView cropOverlayView = this.mCropOverlayView;
            Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
            cropOverlayView.setInitialCropWindowRect(null);
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
            this.setBitmap(bitmap, resId, null, 1, 0);
        }
    }

    @Nullable
    public final Rect getWholeImageRect() {
        int loadedSampleSize = this.mLoadedSampleSize;
        Bitmap bitmap = this.mBitmap;
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap;
        int orgWidth = bitmap2.getWidth() * loadedSampleSize;
        int orgHeight = bitmap2.getHeight() * loadedSampleSize;
        return new Rect(0, 0, orgWidth, orgHeight);
    }

    @Nullable
    public final Rect getCropRect() {
        int loadedSampleSize = this.mLoadedSampleSize;
        Bitmap bitmap = this.mBitmap;
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap;
        float[] points = this.getCropPoints();
        int orgWidth = bitmap2.getWidth() * loadedSampleSize;
        int orgHeight = bitmap2.getHeight() * loadedSampleSize;
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        return BitmapUtils.INSTANCE.getRectFromPoints(points, orgWidth, orgHeight, cropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY());
    }

    public final void setCropRect(@Nullable Rect rect) {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        cropOverlayView.setInitialCropWindowRect(rect);
    }

    @Nullable
    public final RectF getCropWindowRect() {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        return cropOverlayView != null ? cropOverlayView.getCropWindowRect() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final float[] getCropPoints() {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        RectF cropWindowRect = cropOverlayView.getCropWindowRect();
        float[] points = new float[]{cropWindowRect.left, cropWindowRect.top, cropWindowRect.right, cropWindowRect.top, cropWindowRect.right, cropWindowRect.bottom, cropWindowRect.left, cropWindowRect.bottom};
        this.mImageMatrix.invert(this.mImageInverseMatrix);
        this.mImageInverseMatrix.mapPoints(points);
        float[] resultPoints = new float[points.length];
        int n = 0;
        int n2 = points.length;
        while (n < n2) {
            void i;
            resultPoints[i] = points[i] * (float)this.mLoadedSampleSize;
            ++i;
        }
        return resultPoints;
    }

    public final void resetCropRect() {
        this.mZoom = 1.0f;
        this.mZoomOffsetX = 0.0f;
        this.mZoomOffsetY = 0.0f;
        this.mDegreesRotated = this.mInitialDegreesRotated;
        this.mFlipHorizontally = false;
        this.mFlipVertically = false;
        this.applyImageMatrix(this.getWidth(), this.getHeight(), false, false);
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        cropOverlayView.resetCropWindowRect();
    }

    @Nullable
    public final Bitmap getCroppedImage() {
        return this.getCroppedImage(0, 0, RequestSizeOptions.NONE);
    }

    @Nullable
    public final Bitmap getCroppedImage(int reqWidth, int reqHeight) {
        return this.getCroppedImage(reqWidth, reqHeight, RequestSizeOptions.RESIZE_INSIDE);
    }

    @Nullable
    public final Bitmap getCroppedImage(int reqWidth, int reqHeight, @NotNull RequestSizeOptions options) {
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        Bitmap croppedBitmap = null;
        if (this.mBitmap != null) {
            Bitmap bitmap;
            int newReqHeight;
            this.mImageView.clearAnimation();
            int newReqWidth = options != RequestSizeOptions.NONE ? reqWidth : 0;
            int n = newReqHeight = options != RequestSizeOptions.NONE ? reqHeight : 0;
            if (this.imageUri != null && (this.mLoadedSampleSize > 1 || options == RequestSizeOptions.SAMPLING)) {
                Bitmap bitmap2 = this.mBitmap;
                Intrinsics.checkNotNull((Object)bitmap2);
                int orgWidth = bitmap2.getWidth() * this.mLoadedSampleSize;
                Bitmap bitmap3 = this.mBitmap;
                Intrinsics.checkNotNull((Object)bitmap3);
                int orgHeight = bitmap3.getHeight() * this.mLoadedSampleSize;
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                float[] fArray = this.getCropPoints();
                CropOverlayView cropOverlayView = this.mCropOverlayView;
                Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
                BitmapUtils.BitmapSampled bitmapSampled = BitmapUtils.INSTANCE.cropBitmap(context, this.imageUri, fArray, this.mDegreesRotated, orgWidth, orgHeight, cropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY(), newReqWidth, newReqHeight, this.mFlipHorizontally, this.mFlipVertically);
                bitmap = bitmapSampled.getBitmap();
            } else {
                float[] fArray = this.getCropPoints();
                CropOverlayView cropOverlayView = this.mCropOverlayView;
                Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
                bitmap = BitmapUtils.INSTANCE.cropBitmapObjectHandleOOM(this.mBitmap, fArray, this.mDegreesRotated, cropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY(), this.mFlipHorizontally, this.mFlipVertically).getBitmap();
            }
            croppedBitmap = bitmap;
            croppedBitmap = BitmapUtils.INSTANCE.resizeBitmap(croppedBitmap, newReqWidth, newReqHeight, options);
        }
        return croppedBitmap;
    }

    public final void getCroppedImageAsync() {
        this.getCroppedImageAsync(0, 0, RequestSizeOptions.NONE);
    }

    public final void getCroppedImageAsync(int reqWidth, int reqHeight) {
        this.getCroppedImageAsync(reqWidth, reqHeight, RequestSizeOptions.RESIZE_INSIDE);
    }

    public final void getCroppedImageAsync(int reqWidth, int reqHeight, @NotNull RequestSizeOptions options) {
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        OnCropImageCompleteListener onCropImageCompleteListener = this.mOnCropImageCompleteListener;
        boolean bl = false;
        boolean bl2 = false;
        if (onCropImageCompleteListener == null) {
            boolean bl3 = false;
            String string2 = "mOnCropImageCompleteListener is not set";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.startCropWorkerTask(reqWidth, reqHeight, options, null, Bitmap.CompressFormat.JPEG, 0);
    }

    @JvmOverloads
    public final void saveCroppedImageAsync(@Nullable Uri saveUri, @NotNull Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality, int reqWidth, int reqHeight, @NotNull RequestSizeOptions options) {
        Intrinsics.checkNotNullParameter((Object)saveCompressFormat, (String)"saveCompressFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        OnCropImageCompleteListener onCropImageCompleteListener = this.mOnCropImageCompleteListener;
        boolean bl = false;
        boolean bl2 = false;
        if (onCropImageCompleteListener == null) {
            boolean bl3 = false;
            String string2 = "mOnCropImageCompleteListener is not set";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.startCropWorkerTask(reqWidth, reqHeight, options, saveUri, saveCompressFormat, saveCompressQuality);
    }

    public static /* synthetic */ void saveCroppedImageAsync$default(CropImageView cropImageView, Uri uri, Bitmap.CompressFormat compressFormat, int n, int n2, int n3, RequestSizeOptions requestSizeOptions, int n4, Object object) {
        if ((n4 & 0x20) != 0) {
            requestSizeOptions = RequestSizeOptions.RESIZE_INSIDE;
        }
        cropImageView.saveCroppedImageAsync(uri, compressFormat, n, n2, n3, requestSizeOptions);
    }

    @JvmOverloads
    public final void saveCroppedImageAsync(@Nullable Uri saveUri, @NotNull Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality, int reqWidth, int reqHeight) {
        CropImageView.saveCroppedImageAsync$default(this, saveUri, saveCompressFormat, saveCompressQuality, reqWidth, reqHeight, null, 32, null);
    }

    public final void setOnSetCropOverlayReleasedListener(@Nullable OnSetCropOverlayReleasedListener listener) {
        this.mOnCropOverlayReleasedListener = listener;
    }

    public final void setOnSetCropOverlayMovedListener(@Nullable OnSetCropOverlayMovedListener listener) {
        this.mOnSetCropOverlayMovedListener = listener;
    }

    public final void setOnCropWindowChangedListener(@Nullable OnSetCropWindowChangeListener listener) {
        this.mOnSetCropWindowChangeListener = listener;
    }

    public final void setOnSetImageUriCompleteListener(@Nullable OnSetImageUriCompleteListener listener) {
        this.mOnSetImageUriCompleteListener = listener;
    }

    public final void setOnCropImageCompleteListener(@Nullable OnCropImageCompleteListener listener) {
        this.mOnCropImageCompleteListener = listener;
    }

    public final void setImageBitmap(@Nullable Bitmap bitmap) {
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        cropOverlayView.setInitialCropWindowRect(null);
        this.setBitmap(bitmap, 0, null, 1, 0);
    }

    public final void setImageBitmap(@Nullable Bitmap bitmap, @Nullable ExifInterface exif) {
        Bitmap setBitmap = null;
        int degreesRotated = 0;
        if (bitmap != null && exif != null) {
            BitmapUtils.RotateBitmapResult result = BitmapUtils.INSTANCE.rotateBitmapByExif(bitmap, exif);
            setBitmap = result.getBitmap();
            degreesRotated = result.getDegrees();
            this.mInitialDegreesRotated = result.getDegrees();
        } else {
            setBitmap = bitmap;
        }
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        cropOverlayView.setInitialCropWindowRect(null);
        this.setBitmap(setBitmap, 0, null, 1, degreesRotated);
    }

    public final void setImageUriAsync(@Nullable Uri uri) {
        if (uri != null) {
            BitmapLoadingWorkerJob currentTask;
            BitmapLoadingWorkerJob bitmapLoadingWorkerJob;
            if (this.mBitmapLoadingWorkerJob != null) {
                WeakReference<BitmapLoadingWorkerJob> weakReference = this.mBitmapLoadingWorkerJob;
                Intrinsics.checkNotNull(weakReference);
                bitmapLoadingWorkerJob = (BitmapLoadingWorkerJob)weakReference.get();
            } else {
                bitmapLoadingWorkerJob = null;
            }
            BitmapLoadingWorkerJob bitmapLoadingWorkerJob2 = currentTask = bitmapLoadingWorkerJob;
            if (bitmapLoadingWorkerJob2 != null) {
                bitmapLoadingWorkerJob2.cancel();
            }
            this.clearImageInt();
            CropOverlayView cropOverlayView = this.mCropOverlayView;
            Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
            cropOverlayView.setInitialCropWindowRect(null);
            Context context = this.getContext();
            if (context == null) {
                throw new NullPointerException("null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
            }
            WeakReference<BitmapLoadingWorkerJob> weakReference = this.mBitmapLoadingWorkerJob = new WeakReference<BitmapLoadingWorkerJob>(new BitmapLoadingWorkerJob((FragmentActivity)context, this, uri));
            Intrinsics.checkNotNull(weakReference);
            Object t = weakReference.get();
            Intrinsics.checkNotNull(t);
            ((BitmapLoadingWorkerJob)t).start();
            this.setProgressBarVisibility();
        }
    }

    public final void clearImage() {
        block0: {
            this.clearImageInt();
            CropOverlayView cropOverlayView = this.mCropOverlayView;
            if (cropOverlayView == null) break block0;
            cropOverlayView.setInitialCropWindowRect(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void rotateImage(int degrees) {
        if (this.mBitmap != null) {
            int n;
            int newDegrees = degrees < 0 ? degrees % 360 + 360 : degrees % 360;
            CropOverlayView cropOverlayView = this.mCropOverlayView;
            Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
            boolean flipAxes = !cropOverlayView.isFixAspectRatio() && (46 <= (n = newDegrees) && 134 >= n || 216 <= (n = newDegrees) && 304 >= n);
            BitmapUtils.INSTANCE.getRECT().set(this.mCropOverlayView.getCropWindowRect());
            float halfWidth = (flipAxes ? BitmapUtils.INSTANCE.getRECT().height() : BitmapUtils.INSTANCE.getRECT().width()) / 2.0f;
            float halfHeight = (flipAxes ? BitmapUtils.INSTANCE.getRECT().width() : BitmapUtils.INSTANCE.getRECT().height()) / 2.0f;
            if (flipAxes) {
                boolean isFlippedHorizontally22 = this.mFlipHorizontally;
                this.mFlipHorizontally = this.mFlipVertically;
                this.mFlipVertically = isFlippedHorizontally22;
            }
            this.mImageMatrix.invert(this.mImageInverseMatrix);
            BitmapUtils.INSTANCE.getPOINTS()[0] = BitmapUtils.INSTANCE.getRECT().centerX();
            BitmapUtils.INSTANCE.getPOINTS()[1] = BitmapUtils.INSTANCE.getRECT().centerY();
            BitmapUtils.INSTANCE.getPOINTS()[2] = 0.0f;
            BitmapUtils.INSTANCE.getPOINTS()[3] = 0.0f;
            BitmapUtils.INSTANCE.getPOINTS()[4] = 1.0f;
            BitmapUtils.INSTANCE.getPOINTS()[5] = 0.0f;
            this.mImageInverseMatrix.mapPoints(BitmapUtils.INSTANCE.getPOINTS());
            this.mDegreesRotated = (this.mDegreesRotated + newDegrees) % 360;
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
            this.mImageMatrix.mapPoints(BitmapUtils.INSTANCE.getPOINTS2(), BitmapUtils.INSTANCE.getPOINTS());
            double isFlippedHorizontally22 = BitmapUtils.INSTANCE.getPOINTS2()[4] - BitmapUtils.INSTANCE.getPOINTS2()[2];
            double d = 2.0;
            boolean bl = false;
            double d2 = Math.pow(isFlippedHorizontally22, d);
            isFlippedHorizontally22 = BitmapUtils.INSTANCE.getPOINTS2()[5] - BitmapUtils.INSTANCE.getPOINTS2()[3];
            d = 2.0;
            bl = false;
            isFlippedHorizontally22 = d2 + Math.pow(isFlippedHorizontally22, d);
            boolean bl2 = false;
            this.mZoom /= (float)Math.sqrt(isFlippedHorizontally22);
            float isFlippedHorizontally22 = this.mZoom;
            float f = 1.0f;
            bl2 = false;
            this.mZoom = Math.max(isFlippedHorizontally22, f);
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
            this.mImageMatrix.mapPoints(BitmapUtils.INSTANCE.getPOINTS2(), BitmapUtils.INSTANCE.getPOINTS());
            double d3 = BitmapUtils.INSTANCE.getPOINTS2()[4] - BitmapUtils.INSTANCE.getPOINTS2()[2];
            double d4 = 2.0;
            boolean bl3 = false;
            double d5 = Math.pow(d3, d4);
            d3 = BitmapUtils.INSTANCE.getPOINTS2()[5] - BitmapUtils.INSTANCE.getPOINTS2()[3];
            d4 = 2.0;
            bl3 = false;
            d3 = d5 + Math.pow(d3, d4);
            boolean bl4 = false;
            double change = Math.sqrt(d3);
            BitmapUtils.INSTANCE.getRECT().set(BitmapUtils.INSTANCE.getPOINTS2()[0] - (halfWidth *= (float)change), BitmapUtils.INSTANCE.getPOINTS2()[1] - (halfHeight *= (float)change), BitmapUtils.INSTANCE.getPOINTS2()[0] + halfWidth, BitmapUtils.INSTANCE.getPOINTS2()[1] + halfHeight);
            this.mCropOverlayView.resetCropOverlayView();
            this.mCropOverlayView.setCropWindowRect(BitmapUtils.INSTANCE.getRECT());
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
            this.handleCropWindowChanged(false, false);
            this.mCropOverlayView.fixCurrentCropWindowRect();
        }
    }

    public final void flipImageHorizontally() {
        this.mFlipHorizontally = !this.mFlipHorizontally;
        this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
    }

    public final void flipImageVertically() {
        this.mFlipVertically = !this.mFlipVertically;
        this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
    }

    public final void onSetImageUriAsyncComplete(@NotNull BitmapLoadingWorkerJob.Result result) {
        block1: {
            OnSetImageUriCompleteListener listener;
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this.mBitmapLoadingWorkerJob = null;
            this.setProgressBarVisibility();
            if (result.getError() == null) {
                this.mInitialDegreesRotated = result.getDegreesRotated();
                this.setBitmap(result.getBitmap(), 0, result.getUri(), result.getLoadSampleSize(), result.getDegreesRotated());
            }
            OnSetImageUriCompleteListener onSetImageUriCompleteListener = listener = this.mOnSetImageUriCompleteListener;
            if (onSetImageUriCompleteListener == null) break block1;
            onSetImageUriCompleteListener.onSetImageUriComplete(this, result.getUri(), result.getError());
        }
    }

    public final void onImageCroppingAsyncComplete(@NotNull BitmapCroppingWorkerJob.Result result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.mBitmapCroppingWorkerJob = null;
        this.setProgressBarVisibility();
        OnCropImageCompleteListener listener = this.mOnCropImageCompleteListener;
        if (listener != null) {
            CropResult cropResult = new CropResult(this.mBitmap, this.imageUri, result.getBitmap(), result.getUri(), result.getError(), this.getCropPoints(), this.getCropRect(), this.getWholeImageRect(), this.getRotatedDegrees(), result.getSampleSize());
            listener.onCropImageComplete(this, cropResult);
        }
    }

    private final void setBitmap(Bitmap bitmap, int imageResource, Uri imageUri, int loadSampleSize, int degreesRotated) {
        if (this.mBitmap == null || Intrinsics.areEqual((Object)this.mBitmap, (Object)bitmap) ^ true) {
            this.mImageView.clearAnimation();
            this.clearImageInt();
            this.mBitmap = bitmap;
            this.mImageView.setImageBitmap(this.mBitmap);
            this.imageUri = imageUri;
            this.mImageResource = imageResource;
            this.mLoadedSampleSize = loadSampleSize;
            this.mDegreesRotated = degreesRotated;
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
            if (this.mCropOverlayView != null) {
                this.mCropOverlayView.resetCropOverlayView();
                this.setCropOverlayVisibility();
            }
        }
    }

    private final void clearImageInt() {
        if (this.mBitmap != null && (this.mImageResource > 0 || this.imageUri != null)) {
            Bitmap bitmap = this.mBitmap;
            Intrinsics.checkNotNull((Object)bitmap);
            bitmap.recycle();
        }
        this.mBitmap = null;
        this.mImageResource = 0;
        this.imageUri = null;
        this.mLoadedSampleSize = 1;
        this.mDegreesRotated = 0;
        this.mZoom = 1.0f;
        this.mZoomOffsetX = 0.0f;
        this.mZoomOffsetY = 0.0f;
        this.mImageMatrix.reset();
        this.mSaveInstanceStateBitmapUri = null;
        this.mRestoreCropWindowRect = null;
        this.mRestoreDegreesRotated = 0;
        this.mImageView.setImageBitmap(null);
        this.setCropOverlayVisibility();
    }

    public final void startCropWorkerTask(int reqWidth, int reqHeight, @NotNull RequestSizeOptions options, @Nullable Uri saveUri, @NotNull Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality) {
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        Intrinsics.checkNotNullParameter((Object)saveCompressFormat, (String)"saveCompressFormat");
        Bitmap bitmap = this.mBitmap;
        if (bitmap != null) {
            WeakReference<BitmapCroppingWorkerJob> weakReference;
            BitmapCroppingWorkerJob currentTask;
            BitmapCroppingWorkerJob bitmapCroppingWorkerJob;
            this.mImageView.clearAnimation();
            if (this.mBitmapCroppingWorkerJob != null) {
                WeakReference<BitmapCroppingWorkerJob> weakReference2 = this.mBitmapCroppingWorkerJob;
                Intrinsics.checkNotNull(weakReference2);
                bitmapCroppingWorkerJob = (BitmapCroppingWorkerJob)weakReference2.get();
            } else {
                bitmapCroppingWorkerJob = null;
            }
            BitmapCroppingWorkerJob bitmapCroppingWorkerJob2 = currentTask = bitmapCroppingWorkerJob;
            if (bitmapCroppingWorkerJob2 != null) {
                bitmapCroppingWorkerJob2.cancel();
            }
            int newReqWidth = options != RequestSizeOptions.NONE ? reqWidth : 0;
            int newReqHeight = options != RequestSizeOptions.NONE ? reqHeight : 0;
            int orgWidth = bitmap.getWidth() * this.mLoadedSampleSize;
            int orgHeight = bitmap.getHeight() * this.mLoadedSampleSize;
            if (this.imageUri != null && (this.mLoadedSampleSize > 1 || options == RequestSizeOptions.SAMPLING)) {
                Context context = this.getContext();
                if (context == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
                }
                FragmentActivity fragmentActivity = (FragmentActivity)context;
                float[] fArray = this.getCropPoints();
                CropOverlayView cropOverlayView = this.mCropOverlayView;
                Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
                weakReference = new WeakReference<BitmapCroppingWorkerJob>(new BitmapCroppingWorkerJob(fragmentActivity, this, this.imageUri, fArray, this.mDegreesRotated, orgWidth, orgHeight, cropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY(), newReqWidth, newReqHeight, this.mFlipHorizontally, this.mFlipVertically, options, saveUri, saveCompressFormat, saveCompressQuality));
            } else {
                Context context = this.getContext();
                if (context == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
                }
                FragmentActivity fragmentActivity = (FragmentActivity)context;
                float[] fArray = this.getCropPoints();
                CropOverlayView cropOverlayView = this.mCropOverlayView;
                Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
                weakReference = new WeakReference<BitmapCroppingWorkerJob>(new BitmapCroppingWorkerJob(fragmentActivity, this, bitmap, fArray, this.mDegreesRotated, cropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY(), newReqWidth, newReqHeight, this.mFlipHorizontally, this.mFlipVertically, options, saveUri, saveCompressFormat, saveCompressQuality));
            }
            WeakReference<BitmapCroppingWorkerJob> weakReference3 = this.mBitmapCroppingWorkerJob = weakReference;
            Intrinsics.checkNotNull(weakReference3);
            Object t = weakReference3.get();
            Intrinsics.checkNotNull(t);
            ((BitmapCroppingWorkerJob)t).start();
            this.setProgressBarVisibility();
        }
    }

    @Nullable
    public Parcelable onSaveInstanceState() {
        if (this.imageUri == null && this.mBitmap == null && this.mImageResource < 1) {
            return super.onSaveInstanceState();
        }
        Bundle bundle = new Bundle();
        Uri imageUri = this.imageUri;
        if (this.isSaveBitmapToInstanceState && imageUri == null && this.mImageResource < 1) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.mSaveInstanceStateBitmapUri = imageUri = BitmapUtils.INSTANCE.writeTempStateStoreBitmap(context, this.mBitmap, this.mSaveInstanceStateBitmapUri);
        }
        if (imageUri != null && this.mBitmap != null) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UUID.randomUUID().toString()");
            String key = string2;
            BitmapUtils.INSTANCE.setMStateBitmap((Pair<String, WeakReference<Bitmap>>)new Pair((Object)key, new WeakReference<Bitmap>(this.mBitmap)));
            bundle.putString("LOADED_IMAGE_STATE_BITMAP_KEY", key);
        }
        if (this.mBitmapLoadingWorkerJob != null) {
            WeakReference<BitmapLoadingWorkerJob> weakReference = this.mBitmapLoadingWorkerJob;
            Intrinsics.checkNotNull(weakReference);
            BitmapLoadingWorkerJob task = (BitmapLoadingWorkerJob)weakReference.get();
            if (task != null) {
                bundle.putParcelable("LOADING_IMAGE_URI", (Parcelable)task.getUri());
            }
        }
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putParcelable("LOADED_IMAGE_URI", (Parcelable)imageUri);
        bundle.putInt("LOADED_IMAGE_RESOURCE", this.mImageResource);
        bundle.putInt("LOADED_SAMPLE_SIZE", this.mLoadedSampleSize);
        bundle.putInt("DEGREES_ROTATED", this.mDegreesRotated);
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        bundle.putParcelable("INITIAL_CROP_RECT", (Parcelable)cropOverlayView.getInitialCropWindowRect());
        BitmapUtils.INSTANCE.getRECT().set(this.mCropOverlayView.getCropWindowRect());
        this.mImageMatrix.invert(this.mImageInverseMatrix);
        this.mImageInverseMatrix.mapRect(BitmapUtils.INSTANCE.getRECT());
        bundle.putParcelable("CROP_WINDOW_RECT", (Parcelable)BitmapUtils.INSTANCE.getRECT());
        CropShape cropShape = this.mCropOverlayView.getCropShape();
        Intrinsics.checkNotNull((Object)((Object)cropShape));
        bundle.putString("CROP_SHAPE", cropShape.name());
        bundle.putBoolean("CROP_AUTO_ZOOM_ENABLED", this.mAutoZoomEnabled);
        bundle.putInt("CROP_MAX_ZOOM", this.mMaxZoom);
        bundle.putBoolean("CROP_FLIP_HORIZONTALLY", this.mFlipHorizontally);
        bundle.putBoolean("CROP_FLIP_VERTICALLY", this.mFlipVertically);
        return (Parcelable)bundle;
    }

    public void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state instanceof Bundle) {
            if (this.mBitmapLoadingWorkerJob == null && this.imageUri == null && this.mBitmap == null && this.mImageResource == 0) {
                RectF cropWindowRect;
                String string2;
                Uri uri = (Uri)((Bundle)state).getParcelable("LOADED_IMAGE_URI");
                if (uri != null) {
                    Uri uri2;
                    String key;
                    String string3 = key = ((Bundle)state).getString("LOADED_IMAGE_STATE_BITMAP_KEY");
                    if (string3 != null) {
                        Bitmap bitmap;
                        string2 = string3;
                        boolean bl = false;
                        boolean bl2 = false;
                        String $this$run = string2;
                        boolean bl3 = false;
                        Pair<String, WeakReference<Bitmap>> pair = BitmapUtils.INSTANCE.getMStateBitmap();
                        if (pair != null) {
                            Pair<String, WeakReference<Bitmap>> pair2 = pair;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Pair<String, WeakReference<Bitmap>> it = pair2;
                            boolean bl6 = false;
                            bitmap = Intrinsics.areEqual((Object)((String)it.first), (Object)key) ? (Bitmap)((WeakReference)it.second).get() : null;
                        } else {
                            bitmap = null;
                        }
                        Bitmap stateBitmap = bitmap;
                        BitmapUtils.INSTANCE.setMStateBitmap((Pair<String, WeakReference<Bitmap>>)((Pair)null));
                        if (stateBitmap != null && !stateBitmap.isRecycled()) {
                            this.setBitmap(stateBitmap, 0, uri, ((Bundle)state).getInt("LOADED_SAMPLE_SIZE"), 0);
                        }
                    }
                    if ((uri2 = this.imageUri) == null) {
                        this.setImageUriAsync(uri);
                        uri2 = Unit.INSTANCE;
                    }
                } else {
                    int resId = ((Bundle)state).getInt("LOADED_IMAGE_RESOURCE");
                    if (resId > 0) {
                        this.setImageResource(resId);
                    } else {
                        Uri uri3 = uri = (Uri)((Bundle)state).getParcelable("LOADING_IMAGE_URI");
                        if (uri3 != null) {
                            string2 = uri3;
                            boolean bl = false;
                            boolean bl7 = false;
                            String it = string2;
                            boolean bl8 = false;
                            this.setImageUriAsync((Uri)it);
                        }
                    }
                }
                this.mDegreesRotated = this.mRestoreDegreesRotated = ((Bundle)state).getInt("DEGREES_ROTATED");
                Rect initialCropRect = (Rect)((Bundle)state).getParcelable("INITIAL_CROP_RECT");
                if (initialCropRect != null && (initialCropRect.width() > 0 || initialCropRect.height() > 0)) {
                    CropOverlayView cropOverlayView = this.mCropOverlayView;
                    Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
                    cropOverlayView.setInitialCropWindowRect(initialCropRect);
                }
                if ((cropWindowRect = (RectF)((Bundle)state).getParcelable("CROP_WINDOW_RECT")) != null && (cropWindowRect.width() > 0.0f || cropWindowRect.height() > 0.0f)) {
                    this.mRestoreCropWindowRect = cropWindowRect;
                }
                CropOverlayView cropOverlayView = this.mCropOverlayView;
                Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
                String string4 = ((Bundle)state).getString("CROP_SHAPE");
                Intrinsics.checkNotNull((Object)string4);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"state.getString(\"CROP_SHAPE\")!!");
                cropOverlayView.setCropShape(CropShape.valueOf(string4));
                this.mAutoZoomEnabled = ((Bundle)state).getBoolean("CROP_AUTO_ZOOM_ENABLED");
                this.mMaxZoom = ((Bundle)state).getInt("CROP_MAX_ZOOM");
                this.mFlipHorizontally = ((Bundle)state).getBoolean("CROP_FLIP_HORIZONTALLY");
                this.mFlipVertically = ((Bundle)state).getBoolean("CROP_FLIP_VERTICALLY");
            }
            super.onRestoreInstanceState(((Bundle)state).getParcelable("instanceState"));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        Bitmap bitmap = this.mBitmap;
        if (bitmap != null) {
            if (heightSize == 0) {
                heightSize = bitmap.getHeight();
            }
            int desiredWidth = 0;
            int desiredHeight = 0;
            double viewToBitmapWidthRatio = Double.POSITIVE_INFINITY;
            double viewToBitmapHeightRatio = Double.POSITIVE_INFINITY;
            if (widthSize < bitmap.getWidth()) {
                viewToBitmapWidthRatio = (double)widthSize / (double)bitmap.getWidth();
            }
            if (heightSize < bitmap.getHeight()) {
                viewToBitmapHeightRatio = (double)heightSize / (double)bitmap.getHeight();
            }
            if (viewToBitmapWidthRatio != Double.POSITIVE_INFINITY || viewToBitmapHeightRatio != Double.POSITIVE_INFINITY) {
                if (viewToBitmapWidthRatio <= viewToBitmapHeightRatio) {
                    desiredWidth = widthSize;
                    desiredHeight = (int)((double)bitmap.getHeight() * viewToBitmapWidthRatio);
                } else {
                    desiredHeight = heightSize;
                    desiredWidth = (int)((double)bitmap.getWidth() * viewToBitmapHeightRatio);
                }
            } else {
                desiredWidth = bitmap.getWidth();
                desiredHeight = bitmap.getHeight();
            }
            int width = CropImageView.Companion.getOnMeasureSpec(widthMode, widthSize, desiredWidth);
            int height = CropImageView.Companion.getOnMeasureSpec(heightMode, heightSize, desiredHeight);
            this.mLayoutWidth = width;
            this.mLayoutHeight = height;
            this.setMeasuredDimension(this.mLayoutWidth, this.mLayoutHeight);
        } else {
            this.setMeasuredDimension(widthSize, heightSize);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mLayoutWidth > 0 && this.mLayoutHeight > 0) {
            ViewGroup.LayoutParams origParams = this.getLayoutParams();
            origParams.width = this.mLayoutWidth;
            origParams.height = this.mLayoutHeight;
            this.setLayoutParams(origParams);
            if (this.mBitmap != null) {
                this.applyImageMatrix(r - l, b - t, true, false);
                RectF restoreCropWindowRect = this.mRestoreCropWindowRect;
                if (restoreCropWindowRect != null) {
                    if (this.mRestoreDegreesRotated != this.mInitialDegreesRotated) {
                        this.mDegreesRotated = this.mRestoreDegreesRotated;
                        this.applyImageMatrix(r - l, b - t, true, false);
                        this.mRestoreDegreesRotated = 0;
                    }
                    this.mImageMatrix.mapRect(this.mRestoreCropWindowRect);
                    CropOverlayView cropOverlayView = this.mCropOverlayView;
                    if (cropOverlayView != null) {
                        cropOverlayView.setCropWindowRect(restoreCropWindowRect);
                    }
                    this.handleCropWindowChanged(false, false);
                    CropOverlayView cropOverlayView2 = this.mCropOverlayView;
                    if (cropOverlayView2 != null) {
                        cropOverlayView2.fixCurrentCropWindowRect();
                    }
                    this.mRestoreCropWindowRect = null;
                } else if (this.mSizeChanged) {
                    this.mSizeChanged = false;
                    this.handleCropWindowChanged(false, false);
                }
            } else {
                this.updateImageBounds(true);
            }
        } else {
            this.updateImageBounds(true);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mSizeChanged = oldw > 0 && oldh > 0;
    }

    private final void handleCropWindowChanged(boolean inProgress, boolean animate) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mBitmap != null && width > 0 && height > 0) {
            CropOverlayView cropOverlayView = this.mCropOverlayView;
            Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
            RectF cropRect = cropOverlayView.getCropWindowRect();
            if (inProgress) {
                if (cropRect.left < 0.0f || cropRect.top < 0.0f || cropRect.right > (float)width || cropRect.bottom > (float)height) {
                    this.applyImageMatrix(width, height, false, false);
                }
            } else if (this.mAutoZoomEnabled || this.mZoom > 1.0f) {
                boolean bl;
                float f;
                float f2;
                float newZoom = 0.0f;
                if (this.mZoom < (float)this.mMaxZoom && cropRect.width() < (float)width * 0.5f && cropRect.height() < (float)height * 0.5f) {
                    f2 = this.mMaxZoom;
                    f = (float)width / (cropRect.width() / this.mZoom / 0.64f);
                    float f3 = (float)height / (cropRect.height() / this.mZoom / 0.64f);
                    bl = false;
                    f = Math.min(f, f3);
                    boolean bl2 = false;
                    newZoom = Math.min(f2, f);
                }
                if (this.mZoom > 1.0f && (cropRect.width() > (float)width * 0.65f || cropRect.height() > (float)height * 0.65f)) {
                    f2 = 1.0f;
                    f = (float)width / (cropRect.width() / this.mZoom / 0.51f);
                    float f4 = (float)height / (cropRect.height() / this.mZoom / 0.51f);
                    bl = false;
                    f = Math.min(f, f4);
                    boolean bl3 = false;
                    newZoom = Math.max(f2, f);
                }
                if (!this.mAutoZoomEnabled) {
                    newZoom = 1.0f;
                }
                if (newZoom > 0.0f && newZoom != this.mZoom) {
                    if (animate) {
                        if (this.mAnimation == null) {
                            this.mAnimation = new CropImageAnimation(this.mImageView, this.mCropOverlayView);
                        }
                        CropImageAnimation cropImageAnimation = this.mAnimation;
                        Intrinsics.checkNotNull((Object)((Object)cropImageAnimation));
                        cropImageAnimation.setStartState(this.mImagePoints, this.mImageMatrix);
                    }
                    this.mZoom = newZoom;
                    this.applyImageMatrix(width, height, true, animate);
                }
            }
            if (this.mOnSetCropWindowChangeListener != null && !inProgress) {
                OnSetCropWindowChangeListener onSetCropWindowChangeListener = this.mOnSetCropWindowChangeListener;
                Intrinsics.checkNotNull((Object)onSetCropWindowChangeListener);
                onSetCropWindowChangeListener.onCropWindowChanged();
            }
        }
    }

    private final void applyImageMatrix(float width, float height, boolean center, boolean animate) {
        Bitmap bitmap = this.mBitmap;
        if (bitmap != null && width > 0.0f && height > 0.0f) {
            this.mImageMatrix.invert(this.mImageInverseMatrix);
            CropOverlayView cropOverlayView = this.mCropOverlayView;
            Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
            RectF cropRect = cropOverlayView.getCropWindowRect();
            this.mImageInverseMatrix.mapRect(cropRect);
            this.mImageMatrix.reset();
            this.mImageMatrix.postTranslate((width - (float)bitmap.getWidth()) / (float)2, (height - (float)bitmap.getHeight()) / (float)2);
            this.mapImagePointsByImageMatrix();
            if (this.mDegreesRotated > 0) {
                this.mImageMatrix.postRotate((float)this.mDegreesRotated, BitmapUtils.INSTANCE.getRectCenterX(this.mImagePoints), BitmapUtils.INSTANCE.getRectCenterY(this.mImagePoints));
                this.mapImagePointsByImageMatrix();
            }
            float f = width / BitmapUtils.INSTANCE.getRectWidth(this.mImagePoints);
            float f2 = height / BitmapUtils.INSTANCE.getRectHeight(this.mImagePoints);
            boolean bl = false;
            float scale = Math.min(f, f2);
            if (this.mScaleType == ScaleType.FIT_CENTER || this.mScaleType == ScaleType.CENTER_INSIDE && scale < 1.0f || scale > 1.0f && this.mAutoZoomEnabled) {
                this.mImageMatrix.postScale(scale, scale, BitmapUtils.INSTANCE.getRectCenterX(this.mImagePoints), BitmapUtils.INSTANCE.getRectCenterY(this.mImagePoints));
                this.mapImagePointsByImageMatrix();
            }
            float scaleX = this.mFlipHorizontally ? -this.mZoom : this.mZoom;
            float scaleY = this.mFlipVertically ? -this.mZoom : this.mZoom;
            this.mImageMatrix.postScale(scaleX, scaleY, BitmapUtils.INSTANCE.getRectCenterX(this.mImagePoints), BitmapUtils.INSTANCE.getRectCenterY(this.mImagePoints));
            this.mapImagePointsByImageMatrix();
            this.mImageMatrix.mapRect(cropRect);
            if (center) {
                float f3;
                boolean bl2;
                float f4;
                float f5;
                if (width > BitmapUtils.INSTANCE.getRectWidth(this.mImagePoints)) {
                    f5 = 0.0f;
                } else {
                    float f6 = width / (float)2 - cropRect.centerX();
                    f4 = -BitmapUtils.INSTANCE.getRectLeft(this.mImagePoints);
                    bl2 = false;
                    f6 = Math.min(f6, f4);
                    f4 = (float)this.getWidth() - BitmapUtils.INSTANCE.getRectRight(this.mImagePoints);
                    bl2 = false;
                    f5 = this.mZoomOffsetX = Math.max(f6, f4) / scaleX;
                }
                if (height > BitmapUtils.INSTANCE.getRectHeight(this.mImagePoints)) {
                    f3 = 0.0f;
                } else {
                    float f7 = height / (float)2 - cropRect.centerY();
                    f4 = -BitmapUtils.INSTANCE.getRectTop(this.mImagePoints);
                    bl2 = false;
                    f7 = Math.min(f7, f4);
                    f4 = (float)this.getHeight() - BitmapUtils.INSTANCE.getRectBottom(this.mImagePoints);
                    bl2 = false;
                    f3 = Math.max(f7, f4) / scaleY;
                }
                this.mZoomOffsetY = f3;
            } else {
                float f8 = this.mZoomOffsetX * scaleX;
                float f9 = -cropRect.left;
                boolean bl3 = false;
                f8 = Math.max(f8, f9);
                f9 = -cropRect.right + width;
                bl3 = false;
                this.mZoomOffsetX = Math.min(f8, f9) / scaleX;
                f8 = this.mZoomOffsetY * scaleY;
                f9 = -cropRect.top;
                bl3 = false;
                f8 = Math.max(f8, f9);
                f9 = -cropRect.bottom + height;
                bl3 = false;
                this.mZoomOffsetY = Math.min(f8, f9) / scaleY;
            }
            this.mImageMatrix.postTranslate(this.mZoomOffsetX * scaleX, this.mZoomOffsetY * scaleY);
            cropRect.offset(this.mZoomOffsetX * scaleX, this.mZoomOffsetY * scaleY);
            this.mCropOverlayView.setCropWindowRect(cropRect);
            this.mapImagePointsByImageMatrix();
            this.mCropOverlayView.invalidate();
            if (animate) {
                CropImageAnimation cropImageAnimation = this.mAnimation;
                Intrinsics.checkNotNull((Object)((Object)cropImageAnimation));
                cropImageAnimation.setEndState(this.mImagePoints, this.mImageMatrix);
                this.mImageView.startAnimation((Animation)this.mAnimation);
            } else {
                this.mImageView.setImageMatrix(this.mImageMatrix);
            }
            this.updateImageBounds(false);
        }
    }

    private final void mapImagePointsByImageMatrix() {
        this.mImagePoints[0] = 0.0f;
        this.mImagePoints[1] = 0.0f;
        Bitmap bitmap = this.mBitmap;
        Intrinsics.checkNotNull((Object)bitmap);
        this.mImagePoints[2] = bitmap.getWidth();
        this.mImagePoints[3] = 0.0f;
        Bitmap bitmap2 = this.mBitmap;
        Intrinsics.checkNotNull((Object)bitmap2);
        this.mImagePoints[4] = bitmap2.getWidth();
        Bitmap bitmap3 = this.mBitmap;
        Intrinsics.checkNotNull((Object)bitmap3);
        this.mImagePoints[5] = bitmap3.getHeight();
        this.mImagePoints[6] = 0.0f;
        Bitmap bitmap4 = this.mBitmap;
        Intrinsics.checkNotNull((Object)bitmap4);
        this.mImagePoints[7] = bitmap4.getHeight();
        this.mImageMatrix.mapPoints(this.mImagePoints);
        this.mScaleImagePoints[0] = 0.0f;
        this.mScaleImagePoints[1] = 0.0f;
        this.mScaleImagePoints[2] = 100.0f;
        this.mScaleImagePoints[3] = 0.0f;
        this.mScaleImagePoints[4] = 100.0f;
        this.mScaleImagePoints[5] = 100.0f;
        this.mScaleImagePoints[6] = 0.0f;
        this.mScaleImagePoints[7] = 100.0f;
        this.mImageMatrix.mapPoints(this.mScaleImagePoints);
    }

    private final void setCropOverlayVisibility() {
        if (this.mCropOverlayView != null) {
            this.mCropOverlayView.setVisibility(this.mShowCropOverlay && this.mBitmap != null ? 0 : 4);
        }
    }

    private final void setProgressBarVisibility() {
        boolean visible = this.mShowProgressBar && (this.mBitmap == null && this.mBitmapLoadingWorkerJob != null || this.mBitmapCroppingWorkerJob != null);
        this.mProgressBar.setVisibility(visible ? 0 : 4);
    }

    private final void updateImageBounds(boolean clear) {
        if (this.mBitmap != null && !clear) {
            float scaleFactorWidth = 100.0f * (float)this.mLoadedSampleSize / BitmapUtils.INSTANCE.getRectWidth(this.mScaleImagePoints);
            float scaleFactorHeight = 100.0f * (float)this.mLoadedSampleSize / BitmapUtils.INSTANCE.getRectHeight(this.mScaleImagePoints);
            CropOverlayView cropOverlayView = this.mCropOverlayView;
            Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
            cropOverlayView.setCropWindowLimits(this.getWidth(), this.getHeight(), scaleFactorWidth, scaleFactorHeight);
        }
        CropOverlayView cropOverlayView = this.mCropOverlayView;
        Intrinsics.checkNotNull((Object)((Object)cropOverlayView));
        cropOverlayView.setBounds(clear ? null : this.mImagePoints, this.getWidth(), this.getHeight());
    }

    @Override
    public void onCropWindowChanged(boolean inProgress) {
        OnSetCropOverlayMovedListener movedListener;
        this.handleCropWindowChanged(inProgress, true);
        OnSetCropOverlayReleasedListener listener = this.mOnCropOverlayReleasedListener;
        if (listener != null && !inProgress) {
            listener.onCropOverlayReleased(this.getCropRect());
        }
        if ((movedListener = this.mOnSetCropOverlayMovedListener) != null && inProgress) {
            movedListener.onCropOverlayMoved(this.getCropRect());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public CropImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Bundle bundle;
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.mImageMatrix = new Matrix();
        this.mImageInverseMatrix = new Matrix();
        this.mImagePoints = new float[8];
        this.mScaleImagePoints = new float[8];
        this.mShowCropOverlay = true;
        this.mShowProgressBar = true;
        this.mAutoZoomEnabled = true;
        this.mLoadedSampleSize = 1;
        this.mZoom = 1.0f;
        CropImageOptions options = null;
        Intent intent2 = intent = context instanceof Activity ? ((Activity)context).getIntent() : null;
        if (intent != null && (bundle = intent.getBundleExtra("CROP_IMAGE_EXTRA_BUNDLE")) != null) {
            options = (CropImageOptions)bundle.getParcelable("CROP_IMAGE_EXTRA_OPTIONS");
        }
        if (options == null) {
            options = new CropImageOptions();
            if (attrs != null) {
                TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CropImageView, 0, 0);
                Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026able.CropImageView, 0, 0)");
                TypedArray ta = typedArray;
                try {
                    options.fixAspectRatio = ta.getBoolean(R.styleable.CropImageView_cropFixAspectRatio, options.fixAspectRatio);
                    options.aspectRatioX = ta.getInteger(R.styleable.CropImageView_cropAspectRatioX, options.aspectRatioX);
                    options.aspectRatioY = ta.getInteger(R.styleable.CropImageView_cropAspectRatioY, options.aspectRatioY);
                    options.scaleType = ScaleType.values()[ta.getInt(R.styleable.CropImageView_cropScaleType, options.scaleType.ordinal())];
                    options.autoZoomEnabled = ta.getBoolean(R.styleable.CropImageView_cropAutoZoomEnabled, options.autoZoomEnabled);
                    options.multiTouchEnabled = ta.getBoolean(R.styleable.CropImageView_cropMultiTouchEnabled, options.multiTouchEnabled);
                    options.centerMoveEnabled = ta.getBoolean(R.styleable.CropImageView_cropCenterMoveEnabled, options.centerMoveEnabled);
                    options.maxZoom = ta.getInteger(R.styleable.CropImageView_cropMaxZoom, options.maxZoom);
                    options.cropShape = CropShape.values()[ta.getInt(R.styleable.CropImageView_cropShape, options.cropShape.ordinal())];
                    options.guidelines = Guidelines.values()[ta.getInt(R.styleable.CropImageView_cropGuidelines, options.guidelines.ordinal())];
                    options.snapRadius = ta.getDimension(R.styleable.CropImageView_cropSnapRadius, options.snapRadius);
                    options.touchRadius = ta.getDimension(R.styleable.CropImageView_cropTouchRadius, options.touchRadius);
                    options.initialCropWindowPaddingRatio = ta.getFloat(R.styleable.CropImageView_cropInitialCropWindowPaddingRatio, options.initialCropWindowPaddingRatio);
                    options.borderLineThickness = ta.getDimension(R.styleable.CropImageView_cropBorderLineThickness, options.borderLineThickness);
                    options.borderLineColor = ta.getInteger(R.styleable.CropImageView_cropBorderLineColor, options.borderLineColor);
                    options.borderCornerThickness = ta.getDimension(R.styleable.CropImageView_cropBorderCornerThickness, options.borderCornerThickness);
                    options.borderCornerOffset = ta.getDimension(R.styleable.CropImageView_cropBorderCornerOffset, options.borderCornerOffset);
                    options.borderCornerLength = ta.getDimension(R.styleable.CropImageView_cropBorderCornerLength, options.borderCornerLength);
                    options.borderCornerColor = ta.getInteger(R.styleable.CropImageView_cropBorderCornerColor, options.borderCornerColor);
                    options.guidelinesThickness = ta.getDimension(R.styleable.CropImageView_cropGuidelinesThickness, options.guidelinesThickness);
                    options.guidelinesColor = ta.getInteger(R.styleable.CropImageView_cropGuidelinesColor, options.guidelinesColor);
                    options.backgroundColor = ta.getInteger(R.styleable.CropImageView_cropBackgroundColor, options.backgroundColor);
                    options.showCropOverlay = ta.getBoolean(R.styleable.CropImageView_cropShowCropOverlay, this.mShowCropOverlay);
                    options.showProgressBar = ta.getBoolean(R.styleable.CropImageView_cropShowProgressBar, this.mShowProgressBar);
                    options.borderCornerThickness = ta.getDimension(R.styleable.CropImageView_cropBorderCornerThickness, options.borderCornerThickness);
                    options.minCropWindowWidth = (int)ta.getDimension(R.styleable.CropImageView_cropMinCropWindowWidth, (float)options.minCropWindowWidth);
                    options.minCropWindowHeight = (int)ta.getDimension(R.styleable.CropImageView_cropMinCropWindowHeight, (float)options.minCropWindowHeight);
                    options.minCropResultWidth = (int)ta.getFloat(R.styleable.CropImageView_cropMinCropResultWidthPX, (float)options.minCropResultWidth);
                    options.minCropResultHeight = (int)ta.getFloat(R.styleable.CropImageView_cropMinCropResultHeightPX, (float)options.minCropResultHeight);
                    options.maxCropResultWidth = (int)ta.getFloat(R.styleable.CropImageView_cropMaxCropResultWidthPX, (float)options.maxCropResultWidth);
                    options.maxCropResultHeight = (int)ta.getFloat(R.styleable.CropImageView_cropMaxCropResultHeightPX, (float)options.maxCropResultHeight);
                    options.flipHorizontally = ta.getBoolean(R.styleable.CropImageView_cropFlipHorizontally, options.flipHorizontally);
                    options.flipVertically = ta.getBoolean(R.styleable.CropImageView_cropFlipHorizontally, options.flipVertically);
                    this.isSaveBitmapToInstanceState = ta.getBoolean(R.styleable.CropImageView_cropSaveBitmapToInstanceState, this.isSaveBitmapToInstanceState);
                    if (ta.hasValue(R.styleable.CropImageView_cropAspectRatioX) && ta.hasValue(R.styleable.CropImageView_cropAspectRatioX) && !ta.hasValue(R.styleable.CropImageView_cropFixAspectRatio)) {
                        options.fixAspectRatio = true;
                    }
                }
                finally {
                    ta.recycle();
                }
            }
        }
        options.validate();
        this.mScaleType = options.scaleType;
        this.mAutoZoomEnabled = options.autoZoomEnabled;
        this.mMaxZoom = options.maxZoom;
        this.mShowCropOverlay = options.showCropOverlay;
        this.mShowProgressBar = options.showProgressBar;
        this.mFlipHorizontally = options.flipHorizontally;
        this.mFlipVertically = options.flipVertically;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View v = inflater.inflate(R.layout.crop_image_view, (ViewGroup)this, true);
        View view = v.findViewById(R.id.ImageView_image);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"v.findViewById(R.id.ImageView_image)");
        this.mImageView = (ImageView)view;
        this.mImageView.setScaleType(ImageView.ScaleType.MATRIX);
        this.mCropOverlayView = (CropOverlayView)v.findViewById(R.id.CropOverlayView);
        this.mCropOverlayView.setCropWindowChangeListener(this);
        this.mCropOverlayView.setInitialAttributeValues(options);
        View view2 = v.findViewById(R.id.CropProgressBar);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"v.findViewById(R.id.CropProgressBar)");
        this.mProgressBar = (ProgressBar)view2;
        this.setProgressBarVisibility();
    }

    public /* synthetic */ CropImageView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @JvmOverloads
    public CropImageView(@NotNull Context context) {
        this(context, null, 2, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/canhub/cropper/CropImageView$CropShape;", "", "(Ljava/lang/String;I)V", "RECTANGLE", "OVAL", "RECTANGLE_VERTICAL_ONLY", "RECTANGLE_HORIZONTAL_ONLY", "cropper_release"})
    public static final class CropShape
    extends Enum<CropShape> {
        public static final /* enum */ CropShape RECTANGLE;
        public static final /* enum */ CropShape OVAL;
        public static final /* enum */ CropShape RECTANGLE_VERTICAL_ONLY;
        public static final /* enum */ CropShape RECTANGLE_HORIZONTAL_ONLY;
        private static final /* synthetic */ CropShape[] $VALUES;

        static {
            CropShape[] cropShapeArray = new CropShape[4];
            CropShape[] cropShapeArray2 = cropShapeArray;
            cropShapeArray[0] = RECTANGLE = new CropShape();
            cropShapeArray[1] = OVAL = new CropShape();
            cropShapeArray[2] = RECTANGLE_VERTICAL_ONLY = new CropShape();
            cropShapeArray[3] = RECTANGLE_HORIZONTAL_ONLY = new CropShape();
            $VALUES = cropShapeArray;
        }

        public static CropShape[] values() {
            return (CropShape[])$VALUES.clone();
        }

        public static CropShape valueOf(String string2) {
            return Enum.valueOf(CropShape.class, string2);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/canhub/cropper/CropImageView$ScaleType;", "", "(Ljava/lang/String;I)V", "FIT_CENTER", "CENTER", "CENTER_CROP", "CENTER_INSIDE", "cropper_release"})
    public static final class ScaleType
    extends Enum<ScaleType> {
        public static final /* enum */ ScaleType FIT_CENTER;
        public static final /* enum */ ScaleType CENTER;
        public static final /* enum */ ScaleType CENTER_CROP;
        public static final /* enum */ ScaleType CENTER_INSIDE;
        private static final /* synthetic */ ScaleType[] $VALUES;

        static {
            ScaleType[] scaleTypeArray = new ScaleType[4];
            ScaleType[] scaleTypeArray2 = scaleTypeArray;
            scaleTypeArray[0] = FIT_CENTER = new ScaleType();
            scaleTypeArray[1] = CENTER = new ScaleType();
            scaleTypeArray[2] = CENTER_CROP = new ScaleType();
            scaleTypeArray[3] = CENTER_INSIDE = new ScaleType();
            $VALUES = scaleTypeArray;
        }

        public static ScaleType[] values() {
            return (ScaleType[])$VALUES.clone();
        }

        public static ScaleType valueOf(String string2) {
            return Enum.valueOf(ScaleType.class, string2);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/canhub/cropper/CropImageView$Guidelines;", "", "(Ljava/lang/String;I)V", "OFF", "ON_TOUCH", "ON", "cropper_release"})
    public static final class Guidelines
    extends Enum<Guidelines> {
        public static final /* enum */ Guidelines OFF;
        public static final /* enum */ Guidelines ON_TOUCH;
        public static final /* enum */ Guidelines ON;
        private static final /* synthetic */ Guidelines[] $VALUES;

        static {
            Guidelines[] guidelinesArray = new Guidelines[3];
            Guidelines[] guidelinesArray2 = guidelinesArray;
            guidelinesArray[0] = OFF = new Guidelines();
            guidelinesArray[1] = ON_TOUCH = new Guidelines();
            guidelinesArray[2] = ON = new Guidelines();
            $VALUES = guidelinesArray;
        }

        public static Guidelines[] values() {
            return (Guidelines[])$VALUES.clone();
        }

        public static Guidelines valueOf(String string2) {
            return Enum.valueOf(Guidelines.class, string2);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/canhub/cropper/CropImageView$RequestSizeOptions;", "", "(Ljava/lang/String;I)V", "NONE", "SAMPLING", "RESIZE_INSIDE", "RESIZE_FIT", "RESIZE_EXACT", "cropper_release"})
    public static final class RequestSizeOptions
    extends Enum<RequestSizeOptions> {
        public static final /* enum */ RequestSizeOptions NONE;
        public static final /* enum */ RequestSizeOptions SAMPLING;
        public static final /* enum */ RequestSizeOptions RESIZE_INSIDE;
        public static final /* enum */ RequestSizeOptions RESIZE_FIT;
        public static final /* enum */ RequestSizeOptions RESIZE_EXACT;
        private static final /* synthetic */ RequestSizeOptions[] $VALUES;

        static {
            RequestSizeOptions[] requestSizeOptionsArray = new RequestSizeOptions[5];
            RequestSizeOptions[] requestSizeOptionsArray2 = requestSizeOptionsArray;
            requestSizeOptionsArray[0] = NONE = new RequestSizeOptions();
            requestSizeOptionsArray[1] = SAMPLING = new RequestSizeOptions();
            requestSizeOptionsArray[2] = RESIZE_INSIDE = new RequestSizeOptions();
            requestSizeOptionsArray[3] = RESIZE_FIT = new RequestSizeOptions();
            requestSizeOptionsArray[4] = RESIZE_EXACT = new RequestSizeOptions();
            $VALUES = requestSizeOptionsArray;
        }

        public static RequestSizeOptions[] values() {
            return (RequestSizeOptions[])$VALUES.clone();
        }

        public static RequestSizeOptions valueOf(String string2) {
            return Enum.valueOf(RequestSizeOptions.class, string2);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/canhub/cropper/CropImageView$OnSetCropOverlayReleasedListener;", "", "onCropOverlayReleased", "", "rect", "Landroid/graphics/Rect;", "cropper_release"})
    public static interface OnSetCropOverlayReleasedListener {
        public void onCropOverlayReleased(@Nullable Rect var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/canhub/cropper/CropImageView$OnSetCropOverlayMovedListener;", "", "onCropOverlayMoved", "", "rect", "Landroid/graphics/Rect;", "cropper_release"})
    public static interface OnSetCropOverlayMovedListener {
        public void onCropOverlayMoved(@Nullable Rect var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/canhub/cropper/CropImageView$OnSetCropWindowChangeListener;", "", "onCropWindowChanged", "", "cropper_release"})
    public static interface OnSetCropWindowChangeListener {
        public void onCropWindowChanged();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nH&\u00a8\u0006\u000b"}, d2={"Lcom/canhub/cropper/CropImageView$OnSetImageUriCompleteListener;", "", "onSetImageUriComplete", "", "view", "Lcom/canhub/cropper/CropImageView;", "uri", "Landroid/net/Uri;", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cropper_release"})
    public static interface OnSetImageUriCompleteListener {
        public void onSetImageUriComplete(@NotNull CropImageView var1, @NotNull Uri var2, @Nullable Exception var3);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/canhub/cropper/CropImageView$OnCropImageCompleteListener;", "", "onCropImageComplete", "", "view", "Lcom/canhub/cropper/CropImageView;", "result", "Lcom/canhub/cropper/CropImageView$CropResult;", "cropper_release"})
    public static interface OnCropImageCompleteListener {
        public void onCropImageComplete(@NotNull CropImageView var1, @NotNull CropResult var2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001Bk\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020(R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010!R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0019\u00a8\u0006)"}, d2={"Lcom/canhub/cropper/CropImageView$CropResult;", "", "originalBitmap", "Landroid/graphics/Bitmap;", "originalUri", "Landroid/net/Uri;", "bitmap", "uri", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cropPoints", "", "cropRect", "Landroid/graphics/Rect;", "wholeImageRect", "rotation", "", "sampleSize", "(Landroid/graphics/Bitmap;Landroid/net/Uri;Landroid/graphics/Bitmap;Landroid/net/Uri;Ljava/lang/Exception;[FLandroid/graphics/Rect;Landroid/graphics/Rect;II)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getCropPoints", "()[F", "getCropRect", "()Landroid/graphics/Rect;", "getError", "()Ljava/lang/Exception;", "isSuccessful", "", "()Z", "getOriginalBitmap", "getOriginalUri", "()Landroid/net/Uri;", "getRotation", "()I", "getSampleSize", "getUri", "getWholeImageRect", "context", "Landroid/content/Context;", "cropper_release"})
    public static class CropResult {
        @Nullable
        private final Bitmap originalBitmap;
        @Nullable
        private final Uri originalUri;
        @Nullable
        private final Bitmap bitmap;
        @Nullable
        private final Uri uri;
        @Nullable
        private final Exception error;
        @NotNull
        private final float[] cropPoints;
        @Nullable
        private final Rect cropRect;
        @Nullable
        private final Rect wholeImageRect;
        private final int rotation;
        private final int sampleSize;

        public final boolean isSuccessful() {
            return this.error == null;
        }

        @Nullable
        public final Bitmap getBitmap(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Bitmap bitmap = this.bitmap;
            if (bitmap == null) {
                Bitmap bitmap2;
                try {
                    bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)this.uri);
                }
                catch (Exception e) {
                    bitmap2 = null;
                }
                bitmap = bitmap2;
            }
            return bitmap;
        }

        @Nullable
        public final Bitmap getOriginalBitmap() {
            return this.originalBitmap;
        }

        @Nullable
        public final Uri getOriginalUri() {
            return this.originalUri;
        }

        @Nullable
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        @Nullable
        public final Uri getUri() {
            return this.uri;
        }

        @Nullable
        public final Exception getError() {
            return this.error;
        }

        @NotNull
        public final float[] getCropPoints() {
            return this.cropPoints;
        }

        @Nullable
        public final Rect getCropRect() {
            return this.cropRect;
        }

        @Nullable
        public final Rect getWholeImageRect() {
            return this.wholeImageRect;
        }

        public final int getRotation() {
            return this.rotation;
        }

        public final int getSampleSize() {
            return this.sampleSize;
        }

        public CropResult(@Nullable Bitmap originalBitmap, @Nullable Uri originalUri, @Nullable Bitmap bitmap, @Nullable Uri uri, @Nullable Exception error, @NotNull float[] cropPoints, @Nullable Rect cropRect, @Nullable Rect wholeImageRect, int rotation, int sampleSize) {
            Intrinsics.checkNotNullParameter((Object)cropPoints, (String)"cropPoints");
            this.originalBitmap = originalBitmap;
            this.originalUri = originalUri;
            this.bitmap = bitmap;
            this.uri = uri;
            this.error = error;
            this.cropPoints = cropPoints;
            this.cropRect = cropRect;
            this.wholeImageRect = wholeImageRect;
            this.rotation = rotation;
            this.sampleSize = sampleSize;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"Lcom/canhub/cropper/CropImageView$Companion;", "", "()V", "getOnMeasureSpec", "", "measureSpecMode", "measureSpecSize", "desiredSize", "cropper_release"})
    public static final class Companion {
        private final int getOnMeasureSpec(int measureSpecMode, int measureSpecSize, int desiredSize) {
            int n;
            switch (measureSpecMode) {
                case 0x40000000: {
                    n = measureSpecSize;
                    break;
                }
                case -2147483648: {
                    boolean bl = false;
                    n = Math.min(desiredSize, measureSpecSize);
                    break;
                }
                default: {
                    n = desiredSize;
                }
            }
            return n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

