/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.graphics.RectF;
import com.canhub.cropper.CropImageOptions;
import com.canhub.cropper.CropImageView;
import com.canhub.cropper.CropWindowMoveHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0007J\u0006\u0010\u0016\u001a\u00020\u0007J(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0006\u0010 \u001a\u00020\u0004J\"\u0010!\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0006\u0010\"\u001a\u00020\u0007J\u0006\u0010#\u001a\u00020\u0007J8\u0010$\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0002J0\u0010)\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J8\u0010,\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J8\u0010/\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J&\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007J\u000e\u00108\u001a\u0002032\u0006\u00109\u001a\u00020:J\u0016\u0010;\u001a\u0002032\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=J\u0016\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020=2\u0006\u0010A\u001a\u00020=J\u000e\u0010B\u001a\u0002032\u0006\u0010C\u001a\u00020\u0004J\u0006\u0010D\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/canhub/cropper/CropWindowHandler;", "", "()V", "mEdges", "Landroid/graphics/RectF;", "mGetEdges", "mMaxCropResultHeight", "", "mMaxCropResultWidth", "mMaxCropWindowHeight", "mMaxCropWindowWidth", "mMinCropResultHeight", "mMinCropResultWidth", "mMinCropWindowHeight", "mMinCropWindowWidth", "mScaleFactorHeight", "mScaleFactorWidth", "focusCenter", "", "getMaxCropHeight", "getMaxCropWidth", "getMinCropHeight", "getMinCropWidth", "getMoveHandler", "Lcom/canhub/cropper/CropWindowMoveHandler;", "x", "y", "targetRadius", "cropShape", "Lcom/canhub/cropper/CropImageView$CropShape;", "getOvalPressedMoveType", "Lcom/canhub/cropper/CropWindowMoveHandler$Type;", "getRect", "getRectanglePressedMoveType", "getScaleFactorHeight", "getScaleFactorWidth", "isInCenterTargetZone", "left", "top", "right", "bottom", "isInCornerTargetZone", "handleX", "handleY", "isInHorizontalTargetZone", "handleXStart", "handleXEnd", "isInVerticalTargetZone", "handleYStart", "handleYEnd", "setCropWindowLimits", "", "maxWidth", "maxHeight", "scaleFactorWidth", "scaleFactorHeight", "setInitialAttributeValues", "options", "Lcom/canhub/cropper/CropImageOptions;", "setMaxCropResultSize", "maxCropResultWidth", "", "maxCropResultHeight", "setMinCropResultSize", "minCropResultWidth", "minCropResultHeight", "setRect", "rect", "showGuidelines", "cropper_release"})
public final class CropWindowHandler {
    private final RectF mEdges = new RectF();
    private final RectF mGetEdges = new RectF();
    private float mMinCropWindowWidth;
    private float mMinCropWindowHeight;
    private float mMaxCropWindowWidth;
    private float mMaxCropWindowHeight;
    private float mMinCropResultWidth;
    private float mMinCropResultHeight;
    private float mMaxCropResultWidth;
    private float mMaxCropResultHeight;
    private float mScaleFactorWidth = 1.0f;
    private float mScaleFactorHeight = 1.0f;

    @NotNull
    public final RectF getRect() {
        this.mGetEdges.set(this.mEdges);
        return this.mGetEdges;
    }

    public final float getMinCropWidth() {
        return RangesKt.coerceAtLeast((float)this.mMinCropWindowWidth, (float)(this.mMinCropResultWidth / this.mScaleFactorWidth));
    }

    public final float getMinCropHeight() {
        return RangesKt.coerceAtLeast((float)this.mMinCropWindowHeight, (float)(this.mMinCropResultHeight / this.mScaleFactorHeight));
    }

    public final float getMaxCropWidth() {
        return RangesKt.coerceAtMost((float)this.mMaxCropWindowWidth, (float)(this.mMaxCropResultWidth / this.mScaleFactorWidth));
    }

    public final float getMaxCropHeight() {
        return RangesKt.coerceAtMost((float)this.mMaxCropWindowHeight, (float)(this.mMaxCropResultHeight / this.mScaleFactorHeight));
    }

    public final float getScaleFactorWidth() {
        return this.mScaleFactorWidth;
    }

    public final float getScaleFactorHeight() {
        return this.mScaleFactorHeight;
    }

    public final void setMinCropResultSize(int minCropResultWidth, int minCropResultHeight) {
        this.mMinCropResultWidth = minCropResultWidth;
        this.mMinCropResultHeight = minCropResultHeight;
    }

    public final void setMaxCropResultSize(int maxCropResultWidth, int maxCropResultHeight) {
        this.mMaxCropResultWidth = maxCropResultWidth;
        this.mMaxCropResultHeight = maxCropResultHeight;
    }

    public final void setCropWindowLimits(float maxWidth, float maxHeight, float scaleFactorWidth, float scaleFactorHeight) {
        this.mMaxCropWindowWidth = maxWidth;
        this.mMaxCropWindowHeight = maxHeight;
        this.mScaleFactorWidth = scaleFactorWidth;
        this.mScaleFactorHeight = scaleFactorHeight;
    }

    public final void setInitialAttributeValues(@NotNull CropImageOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.mMinCropWindowWidth = options.minCropWindowWidth;
        this.mMinCropWindowHeight = options.minCropWindowHeight;
        this.mMinCropResultWidth = options.minCropResultWidth;
        this.mMinCropResultHeight = options.minCropResultHeight;
        this.mMaxCropResultWidth = options.maxCropResultWidth;
        this.mMaxCropResultHeight = options.maxCropResultHeight;
    }

    public final void setRect(@NotNull RectF rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.mEdges.set(rect);
    }

    public final boolean showGuidelines() {
        return !(this.mEdges.width() < (float)100) && !(this.mEdges.height() < (float)100);
    }

    @Nullable
    public final CropWindowMoveHandler getMoveHandler(float x, float y, float targetRadius, @NotNull CropImageView.CropShape cropShape) {
        Intrinsics.checkNotNullParameter((Object)((Object)cropShape), (String)"cropShape");
        CropWindowMoveHandler.Type type = cropShape == CropImageView.CropShape.OVAL ? this.getOvalPressedMoveType(x, y) : this.getRectanglePressedMoveType(x, y, targetRadius);
        return type != null ? new CropWindowMoveHandler(type, this, x, y) : null;
    }

    private final CropWindowMoveHandler.Type getRectanglePressedMoveType(float x, float y, float targetRadius) {
        return this.isInCornerTargetZone(x, y, this.mEdges.left, this.mEdges.top, targetRadius) ? CropWindowMoveHandler.Type.TOP_LEFT : (this.isInCornerTargetZone(x, y, this.mEdges.right, this.mEdges.top, targetRadius) ? CropWindowMoveHandler.Type.TOP_RIGHT : (this.isInCornerTargetZone(x, y, this.mEdges.left, this.mEdges.bottom, targetRadius) ? CropWindowMoveHandler.Type.BOTTOM_LEFT : (this.isInCornerTargetZone(x, y, this.mEdges.right, this.mEdges.bottom, targetRadius) ? CropWindowMoveHandler.Type.BOTTOM_RIGHT : (this.isInCenterTargetZone(x, y, this.mEdges.left, this.mEdges.top, this.mEdges.right, this.mEdges.bottom) && this.focusCenter() ? CropWindowMoveHandler.Type.CENTER : (this.isInHorizontalTargetZone(x, y, this.mEdges.left, this.mEdges.right, this.mEdges.top, targetRadius) ? CropWindowMoveHandler.Type.TOP : (this.isInHorizontalTargetZone(x, y, this.mEdges.left, this.mEdges.right, this.mEdges.bottom, targetRadius) ? CropWindowMoveHandler.Type.BOTTOM : (this.isInVerticalTargetZone(x, y, this.mEdges.left, this.mEdges.top, this.mEdges.bottom, targetRadius) ? CropWindowMoveHandler.Type.LEFT : (this.isInVerticalTargetZone(x, y, this.mEdges.right, this.mEdges.top, this.mEdges.bottom, targetRadius) ? CropWindowMoveHandler.Type.RIGHT : (this.isInCenterTargetZone(x, y, this.mEdges.left, this.mEdges.top, this.mEdges.right, this.mEdges.bottom) && !this.focusCenter() ? CropWindowMoveHandler.Type.CENTER : null)))))))));
    }

    private final CropWindowMoveHandler.Type getOvalPressedMoveType(float x, float y) {
        float cellLength = this.mEdges.width() / (float)6;
        float leftCenter = this.mEdges.left + cellLength;
        float rightCenter = this.mEdges.left + (float)5 * cellLength;
        float cellHeight = this.mEdges.height() / (float)6;
        float topCenter = this.mEdges.top + cellHeight;
        float bottomCenter = this.mEdges.top + (float)5 * cellHeight;
        return x < leftCenter ? (y < topCenter ? CropWindowMoveHandler.Type.TOP_LEFT : (y < bottomCenter ? CropWindowMoveHandler.Type.LEFT : CropWindowMoveHandler.Type.BOTTOM_LEFT)) : (x < rightCenter ? (y < topCenter ? CropWindowMoveHandler.Type.TOP : (y < bottomCenter ? CropWindowMoveHandler.Type.CENTER : CropWindowMoveHandler.Type.BOTTOM)) : (y < topCenter ? CropWindowMoveHandler.Type.TOP_RIGHT : (y < bottomCenter ? CropWindowMoveHandler.Type.RIGHT : CropWindowMoveHandler.Type.BOTTOM_RIGHT)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInCornerTargetZone(float x, float y, float handleX, float handleY, float targetRadius) {
        float f = x - handleX;
        boolean bl = false;
        if (!(Math.abs(f) <= targetRadius)) return false;
        f = y - handleY;
        bl = false;
        if (!(Math.abs(f) <= targetRadius)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInHorizontalTargetZone(float x, float y, float handleXStart, float handleXEnd, float handleY, float targetRadius) {
        if (!(x > handleXStart)) return false;
        if (!(x < handleXEnd)) return false;
        float f = y - handleY;
        boolean bl = false;
        if (!(Math.abs(f) <= targetRadius)) return false;
        return true;
    }

    private final boolean isInVerticalTargetZone(float x, float y, float handleX, float handleYStart, float handleYEnd, float targetRadius) {
        float f = x - handleX;
        boolean bl = false;
        return Math.abs(f) <= targetRadius && y > handleYStart && y < handleYEnd;
    }

    private final boolean isInCenterTargetZone(float x, float y, float left, float top, float right, float bottom) {
        return x > left && x < right && y > top && y < bottom;
    }

    private final boolean focusCenter() {
        return !this.showGuidelines();
    }
}

