/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.exifinterface.media.ExifInterface;
import androidx.fragment.app.FragmentActivity;
import com.canhub.cropper.BitmapCroppingWorkerJob;
import com.canhub.cropper.BitmapLoadingWorkerJob;
import com.canhub.cropper.BitmapUtils;
import com.canhub.cropper.CropImageAnimation;
import com.canhub.cropper.CropImageOptions;
import com.canhub.cropper.CropOverlayView;
import com.canhub.cropper.R;
import java.lang.ref.WeakReference;
import java.util.UUID;

public class CropImageView
extends FrameLayout {
    private final ImageView mImageView;
    private final CropOverlayView mCropOverlayView;
    private final Matrix mImageMatrix = new Matrix();
    private final Matrix mImageInverseMatrix = new Matrix();
    private final ProgressBar mProgressBar;
    private final float[] mImagePoints = new float[8];
    private final float[] mScaleImagePoints = new float[8];
    private CropImageAnimation mAnimation;
    private Bitmap mBitmap;
    private int mInitialDegreesRotated;
    private int mDegreesRotated;
    private boolean mFlipHorizontally;
    private boolean mFlipVertically;
    private int mLayoutWidth;
    private int mLayoutHeight;
    private int mImageResource;
    private ScaleType mScaleType;
    private boolean mSaveBitmapToInstanceState = false;
    private boolean mShowCropOverlay = true;
    private boolean mShowProgressBar = true;
    private boolean mAutoZoomEnabled = true;
    private int mMaxZoom;
    private OnSetCropOverlayReleasedListener mOnCropOverlayReleasedListener;
    private OnSetCropOverlayMovedListener mOnSetCropOverlayMovedListener;
    private OnSetCropWindowChangeListener mOnSetCropWindowChangeListener;
    private OnSetImageUriCompleteListener mOnSetImageUriCompleteListener;
    private OnCropImageCompleteListener mOnCropImageCompleteListener;
    private Uri mLoadedImageUri;
    private int mLoadedSampleSize = 1;
    private float mZoom = 1.0f;
    private float mZoomOffsetX;
    private float mZoomOffsetY;
    private RectF mRestoreCropWindowRect;
    private int mRestoreDegreesRotated;
    private boolean mSizeChanged;
    private Uri mSaveInstanceStateBitmapUri;
    private WeakReference<BitmapLoadingWorkerJob> mBitmapLoadingWorkerJob;
    private WeakReference<BitmapCroppingWorkerJob> mBitmapCroppingWorkerJob;

    public CropImageView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Bundle bundle;
        Intent intent;
        CropImageOptions options = null;
        Intent intent2 = intent = context instanceof Activity ? ((Activity)context).getIntent() : null;
        if (intent != null && (bundle = intent.getBundleExtra("CROP_IMAGE_EXTRA_BUNDLE")) != null) {
            options = (CropImageOptions)bundle.getParcelable("CROP_IMAGE_EXTRA_OPTIONS");
        }
        if (options == null) {
            options = new CropImageOptions();
            if (attrs != null) {
                TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CropImageView, 0, 0);
                try {
                    options.fixAspectRatio = ta.getBoolean(R.styleable.CropImageView_cropFixAspectRatio, options.fixAspectRatio);
                    options.aspectRatioX = ta.getInteger(R.styleable.CropImageView_cropAspectRatioX, options.aspectRatioX);
                    options.aspectRatioY = ta.getInteger(R.styleable.CropImageView_cropAspectRatioY, options.aspectRatioY);
                    options.scaleType = ScaleType.values()[ta.getInt(R.styleable.CropImageView_cropScaleType, options.scaleType.ordinal())];
                    options.autoZoomEnabled = ta.getBoolean(R.styleable.CropImageView_cropAutoZoomEnabled, options.autoZoomEnabled);
                    options.multiTouchEnabled = ta.getBoolean(R.styleable.CropImageView_cropMultiTouchEnabled, options.multiTouchEnabled);
                    options.maxZoom = ta.getInteger(R.styleable.CropImageView_cropMaxZoom, options.maxZoom);
                    options.cropShape = CropShape.values()[ta.getInt(R.styleable.CropImageView_cropShape, options.cropShape.ordinal())];
                    options.guidelines = Guidelines.values()[ta.getInt(R.styleable.CropImageView_cropGuidelines, options.guidelines.ordinal())];
                    options.snapRadius = ta.getDimension(R.styleable.CropImageView_cropSnapRadius, options.snapRadius);
                    options.touchRadius = ta.getDimension(R.styleable.CropImageView_cropTouchRadius, options.touchRadius);
                    options.initialCropWindowPaddingRatio = ta.getFloat(R.styleable.CropImageView_cropInitialCropWindowPaddingRatio, options.initialCropWindowPaddingRatio);
                    options.borderLineThickness = ta.getDimension(R.styleable.CropImageView_cropBorderLineThickness, options.borderLineThickness);
                    options.borderLineColor = ta.getInteger(R.styleable.CropImageView_cropBorderLineColor, options.borderLineColor);
                    options.borderCornerThickness = ta.getDimension(R.styleable.CropImageView_cropBorderCornerThickness, options.borderCornerThickness);
                    options.borderCornerOffset = ta.getDimension(R.styleable.CropImageView_cropBorderCornerOffset, options.borderCornerOffset);
                    options.borderCornerLength = ta.getDimension(R.styleable.CropImageView_cropBorderCornerLength, options.borderCornerLength);
                    options.borderCornerColor = ta.getInteger(R.styleable.CropImageView_cropBorderCornerColor, options.borderCornerColor);
                    options.guidelinesThickness = ta.getDimension(R.styleable.CropImageView_cropGuidelinesThickness, options.guidelinesThickness);
                    options.guidelinesColor = ta.getInteger(R.styleable.CropImageView_cropGuidelinesColor, options.guidelinesColor);
                    options.backgroundColor = ta.getInteger(R.styleable.CropImageView_cropBackgroundColor, options.backgroundColor);
                    options.showCropOverlay = ta.getBoolean(R.styleable.CropImageView_cropShowCropOverlay, this.mShowCropOverlay);
                    options.showProgressBar = ta.getBoolean(R.styleable.CropImageView_cropShowProgressBar, this.mShowProgressBar);
                    options.borderCornerThickness = ta.getDimension(R.styleable.CropImageView_cropBorderCornerThickness, options.borderCornerThickness);
                    options.minCropWindowWidth = (int)ta.getDimension(R.styleable.CropImageView_cropMinCropWindowWidth, (float)options.minCropWindowWidth);
                    options.minCropWindowHeight = (int)ta.getDimension(R.styleable.CropImageView_cropMinCropWindowHeight, (float)options.minCropWindowHeight);
                    options.minCropResultWidth = (int)ta.getFloat(R.styleable.CropImageView_cropMinCropResultWidthPX, (float)options.minCropResultWidth);
                    options.minCropResultHeight = (int)ta.getFloat(R.styleable.CropImageView_cropMinCropResultHeightPX, (float)options.minCropResultHeight);
                    options.maxCropResultWidth = (int)ta.getFloat(R.styleable.CropImageView_cropMaxCropResultWidthPX, (float)options.maxCropResultWidth);
                    options.maxCropResultHeight = (int)ta.getFloat(R.styleable.CropImageView_cropMaxCropResultHeightPX, (float)options.maxCropResultHeight);
                    options.flipHorizontally = ta.getBoolean(R.styleable.CropImageView_cropFlipHorizontally, options.flipHorizontally);
                    options.flipVertically = ta.getBoolean(R.styleable.CropImageView_cropFlipHorizontally, options.flipVertically);
                    this.mSaveBitmapToInstanceState = ta.getBoolean(R.styleable.CropImageView_cropSaveBitmapToInstanceState, this.mSaveBitmapToInstanceState);
                    if (ta.hasValue(R.styleable.CropImageView_cropAspectRatioX) && ta.hasValue(R.styleable.CropImageView_cropAspectRatioX) && !ta.hasValue(R.styleable.CropImageView_cropFixAspectRatio)) {
                        options.fixAspectRatio = true;
                    }
                }
                finally {
                    ta.recycle();
                }
            }
        }
        options.validate();
        this.mScaleType = options.scaleType;
        this.mAutoZoomEnabled = options.autoZoomEnabled;
        this.mMaxZoom = options.maxZoom;
        this.mShowCropOverlay = options.showCropOverlay;
        this.mShowProgressBar = options.showProgressBar;
        this.mFlipHorizontally = options.flipHorizontally;
        this.mFlipVertically = options.flipVertically;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View v = inflater.inflate(R.layout.crop_image_view, (ViewGroup)this, true);
        this.mImageView = (ImageView)v.findViewById(R.id.ImageView_image);
        this.mImageView.setScaleType(ImageView.ScaleType.MATRIX);
        this.mCropOverlayView = (CropOverlayView)v.findViewById(R.id.CropOverlayView);
        this.mCropOverlayView.setCropWindowChangeListener(inProgress -> {
            OnSetCropOverlayMovedListener movedListener;
            this.handleCropWindowChanged(inProgress, true);
            OnSetCropOverlayReleasedListener listener = this.mOnCropOverlayReleasedListener;
            if (listener != null && !inProgress) {
                listener.onCropOverlayReleased(this.getCropRect());
            }
            if ((movedListener = this.mOnSetCropOverlayMovedListener) != null && inProgress) {
                movedListener.onCropOverlayMoved(this.getCropRect());
            }
        });
        this.mCropOverlayView.setInitialAttributeValues(options);
        this.mProgressBar = (ProgressBar)v.findViewById(R.id.CropProgressBar);
        this.setProgressBarVisibility();
    }

    public ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ScaleType scaleType) {
        if (scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.mZoom = 1.0f;
            this.mZoomOffsetY = 0.0f;
            this.mZoomOffsetX = 0.0f;
            this.mCropOverlayView.resetCropOverlayView();
            this.requestLayout();
        }
    }

    public CropShape getCropShape() {
        return this.mCropOverlayView.getCropShape();
    }

    public void setCropShape(CropShape cropShape) {
        this.mCropOverlayView.setCropShape(cropShape);
    }

    public boolean isAutoZoomEnabled() {
        return this.mAutoZoomEnabled;
    }

    public void setAutoZoomEnabled(boolean autoZoomEnabled) {
        if (this.mAutoZoomEnabled != autoZoomEnabled) {
            this.mAutoZoomEnabled = autoZoomEnabled;
            this.handleCropWindowChanged(false, false);
            this.mCropOverlayView.invalidate();
        }
    }

    public void setMultiTouchEnabled(boolean multiTouchEnabled) {
        if (this.mCropOverlayView.setMultiTouchEnabled(multiTouchEnabled)) {
            this.handleCropWindowChanged(false, false);
            this.mCropOverlayView.invalidate();
        }
    }

    public int getMaxZoom() {
        return this.mMaxZoom;
    }

    public void setMaxZoom(int maxZoom) {
        if (this.mMaxZoom != maxZoom && maxZoom > 0) {
            this.mMaxZoom = maxZoom;
            this.handleCropWindowChanged(false, false);
            this.mCropOverlayView.invalidate();
        }
    }

    public void setMinCropResultSize(int minCropResultWidth, int minCropResultHeight) {
        this.mCropOverlayView.setMinCropResultSize(minCropResultWidth, minCropResultHeight);
    }

    public void setMaxCropResultSize(int maxCropResultWidth, int maxCropResultHeight) {
        this.mCropOverlayView.setMaxCropResultSize(maxCropResultWidth, maxCropResultHeight);
    }

    public int getRotatedDegrees() {
        return this.mDegreesRotated;
    }

    public void setRotatedDegrees(int degrees) {
        if (this.mDegreesRotated != degrees) {
            this.rotateImage(degrees - this.mDegreesRotated);
        }
    }

    public boolean isFixAspectRatio() {
        return this.mCropOverlayView.isFixAspectRatio();
    }

    public void setFixedAspectRatio(boolean fixAspectRatio) {
        this.mCropOverlayView.setFixedAspectRatio(fixAspectRatio);
    }

    public boolean isFlippedHorizontally() {
        return this.mFlipHorizontally;
    }

    public void setFlippedHorizontally(boolean flipHorizontally) {
        if (this.mFlipHorizontally != flipHorizontally) {
            this.mFlipHorizontally = flipHorizontally;
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
        }
    }

    public boolean isFlippedVertically() {
        return this.mFlipVertically;
    }

    public void setFlippedVertically(boolean flipVertically) {
        if (this.mFlipVertically != flipVertically) {
            this.mFlipVertically = flipVertically;
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
        }
    }

    public Guidelines getGuidelines() {
        return this.mCropOverlayView.getGuidelines();
    }

    public void setGuidelines(Guidelines guidelines) {
        this.mCropOverlayView.setGuidelines(guidelines);
    }

    public Pair<Integer, Integer> getAspectRatio() {
        return new Pair((Object)this.mCropOverlayView.getAspectRatioX(), (Object)this.mCropOverlayView.getAspectRatioY());
    }

    public void setAspectRatio(int aspectRatioX, int aspectRatioY) {
        this.mCropOverlayView.setAspectRatioX(aspectRatioX);
        this.mCropOverlayView.setAspectRatioY(aspectRatioY);
        this.setFixedAspectRatio(true);
    }

    public void clearAspectRatio() {
        this.mCropOverlayView.setAspectRatioX(1);
        this.mCropOverlayView.setAspectRatioY(1);
        this.setFixedAspectRatio(false);
    }

    public void setSnapRadius(float snapRadius) {
        if (snapRadius >= 0.0f) {
            this.mCropOverlayView.setSnapRadius(snapRadius);
        }
    }

    public boolean isShowProgressBar() {
        return this.mShowProgressBar;
    }

    public void setShowProgressBar(boolean showProgressBar) {
        if (this.mShowProgressBar != showProgressBar) {
            this.mShowProgressBar = showProgressBar;
            this.setProgressBarVisibility();
        }
    }

    public boolean isShowCropOverlay() {
        return this.mShowCropOverlay;
    }

    public void setShowCropOverlay(boolean showCropOverlay) {
        if (this.mShowCropOverlay != showCropOverlay) {
            this.mShowCropOverlay = showCropOverlay;
            this.setCropOverlayVisibility();
        }
    }

    public boolean isSaveBitmapToInstanceState() {
        return this.mSaveBitmapToInstanceState;
    }

    public void setSaveBitmapToInstanceState(boolean saveBitmapToInstanceState) {
        this.mSaveBitmapToInstanceState = saveBitmapToInstanceState;
    }

    public int getImageResource() {
        return this.mImageResource;
    }

    public Uri getImageUri() {
        return this.mLoadedImageUri;
    }

    public Rect getWholeImageRect() {
        int loadedSampleSize = this.mLoadedSampleSize;
        Bitmap bitmap = this.mBitmap;
        if (bitmap == null) {
            return null;
        }
        int orgWidth = bitmap.getWidth() * loadedSampleSize;
        int orgHeight = bitmap.getHeight() * loadedSampleSize;
        return new Rect(0, 0, orgWidth, orgHeight);
    }

    public Rect getCropRect() {
        int loadedSampleSize = this.mLoadedSampleSize;
        Bitmap bitmap = this.mBitmap;
        if (bitmap == null) {
            return null;
        }
        float[] points = this.getCropPoints();
        int orgWidth = bitmap.getWidth() * loadedSampleSize;
        int orgHeight = bitmap.getHeight() * loadedSampleSize;
        return BitmapUtils.getRectFromPoints(points, orgWidth, orgHeight, this.mCropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY());
    }

    public RectF getCropWindowRect() {
        if (this.mCropOverlayView == null) {
            return null;
        }
        return this.mCropOverlayView.getCropWindowRect();
    }

    public float[] getCropPoints() {
        RectF cropWindowRect = this.mCropOverlayView.getCropWindowRect();
        float[] points = new float[]{cropWindowRect.left, cropWindowRect.top, cropWindowRect.right, cropWindowRect.top, cropWindowRect.right, cropWindowRect.bottom, cropWindowRect.left, cropWindowRect.bottom};
        this.mImageMatrix.invert(this.mImageInverseMatrix);
        this.mImageInverseMatrix.mapPoints(points);
        int i = 0;
        while (i < points.length) {
            int n = i++;
            points[n] = points[n] * (float)this.mLoadedSampleSize;
        }
        return points;
    }

    public void setCropRect(Rect rect) {
        this.mCropOverlayView.setInitialCropWindowRect(rect);
    }

    public void resetCropRect() {
        this.mZoom = 1.0f;
        this.mZoomOffsetX = 0.0f;
        this.mZoomOffsetY = 0.0f;
        this.mDegreesRotated = this.mInitialDegreesRotated;
        this.mFlipHorizontally = false;
        this.mFlipVertically = false;
        this.applyImageMatrix(this.getWidth(), this.getHeight(), false, false);
        this.mCropOverlayView.resetCropWindowRect();
    }

    public Bitmap getCroppedImage() {
        return this.getCroppedImage(0, 0, RequestSizeOptions.NONE);
    }

    public Bitmap getCroppedImage(int reqWidth, int reqHeight) {
        return this.getCroppedImage(reqWidth, reqHeight, RequestSizeOptions.RESIZE_INSIDE);
    }

    public Bitmap getCroppedImage(int reqWidth, int reqHeight, RequestSizeOptions options) {
        Bitmap croppedBitmap = null;
        if (this.mBitmap != null) {
            this.mImageView.clearAnimation();
            reqWidth = options != RequestSizeOptions.NONE ? reqWidth : 0;
            int n = reqHeight = options != RequestSizeOptions.NONE ? reqHeight : 0;
            if (this.mLoadedImageUri != null && (this.mLoadedSampleSize > 1 || options == RequestSizeOptions.SAMPLING)) {
                int orgWidth = this.mBitmap.getWidth() * this.mLoadedSampleSize;
                int orgHeight = this.mBitmap.getHeight() * this.mLoadedSampleSize;
                BitmapUtils.BitmapSampled bitmapSampled = BitmapUtils.cropBitmap(this.getContext(), this.mLoadedImageUri, this.getCropPoints(), this.mDegreesRotated, orgWidth, orgHeight, this.mCropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY(), reqWidth, reqHeight, this.mFlipHorizontally, this.mFlipVertically);
                croppedBitmap = bitmapSampled.bitmap;
            } else {
                croppedBitmap = BitmapUtils.cropBitmapObjectHandleOOM((Bitmap)this.mBitmap, (float[])this.getCropPoints(), (int)this.mDegreesRotated, (boolean)this.mCropOverlayView.isFixAspectRatio(), (int)this.mCropOverlayView.getAspectRatioX(), (int)this.mCropOverlayView.getAspectRatioY(), (boolean)this.mFlipHorizontally, (boolean)this.mFlipVertically).bitmap;
            }
            croppedBitmap = BitmapUtils.resizeBitmap(croppedBitmap, reqWidth, reqHeight, options);
        }
        return croppedBitmap;
    }

    public void getCroppedImageAsync() {
        this.getCroppedImageAsync(0, 0, RequestSizeOptions.NONE);
    }

    public void getCroppedImageAsync(int reqWidth, int reqHeight) {
        this.getCroppedImageAsync(reqWidth, reqHeight, RequestSizeOptions.RESIZE_INSIDE);
    }

    public void getCroppedImageAsync(int reqWidth, int reqHeight, RequestSizeOptions options) {
        if (this.mOnCropImageCompleteListener == null) {
            throw new IllegalArgumentException("mOnCropImageCompleteListener is not set");
        }
        this.startCropWorkerTask(reqWidth, reqHeight, options, null, null, 0);
    }

    public void saveCroppedImageAsync(Uri saveUri) {
        this.saveCroppedImageAsync(saveUri, Bitmap.CompressFormat.JPEG, 90, 0, 0, RequestSizeOptions.NONE);
    }

    public void saveCroppedImageAsync(Uri saveUri, Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality) {
        this.saveCroppedImageAsync(saveUri, saveCompressFormat, saveCompressQuality, 0, 0, RequestSizeOptions.NONE);
    }

    public void saveCroppedImageAsync(Uri saveUri, Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality, int reqWidth, int reqHeight) {
        this.saveCroppedImageAsync(saveUri, saveCompressFormat, saveCompressQuality, reqWidth, reqHeight, RequestSizeOptions.RESIZE_INSIDE);
    }

    public void saveCroppedImageAsync(Uri saveUri, Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality, int reqWidth, int reqHeight, RequestSizeOptions options) {
        if (this.mOnCropImageCompleteListener == null) {
            throw new IllegalArgumentException("mOnCropImageCompleteListener is not set");
        }
        this.startCropWorkerTask(reqWidth, reqHeight, options, saveUri, saveCompressFormat, saveCompressQuality);
    }

    public void setOnSetCropOverlayReleasedListener(OnSetCropOverlayReleasedListener listener) {
        this.mOnCropOverlayReleasedListener = listener;
    }

    public void setOnSetCropOverlayMovedListener(OnSetCropOverlayMovedListener listener) {
        this.mOnSetCropOverlayMovedListener = listener;
    }

    public void setOnCropWindowChangedListener(OnSetCropWindowChangeListener listener) {
        this.mOnSetCropWindowChangeListener = listener;
    }

    public void setOnSetImageUriCompleteListener(OnSetImageUriCompleteListener listener) {
        this.mOnSetImageUriCompleteListener = listener;
    }

    public void setOnCropImageCompleteListener(OnCropImageCompleteListener listener) {
        this.mOnCropImageCompleteListener = listener;
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.mCropOverlayView.setInitialCropWindowRect(null);
        this.setBitmap(bitmap, 0, null, 1, 0);
    }

    public void setImageBitmap(Bitmap bitmap, ExifInterface exif) {
        Bitmap setBitmap;
        int degreesRotated = 0;
        if (bitmap != null && exif != null) {
            BitmapUtils.RotateBitmapResult result = BitmapUtils.rotateBitmapByExif(bitmap, exif);
            setBitmap = result.bitmap;
            degreesRotated = result.degrees;
            this.mInitialDegreesRotated = result.degrees;
        } else {
            setBitmap = bitmap;
        }
        this.mCropOverlayView.setInitialCropWindowRect(null);
        this.setBitmap(setBitmap, 0, null, 1, degreesRotated);
    }

    public void setImageResource(int resId) {
        if (resId != 0) {
            this.mCropOverlayView.setInitialCropWindowRect(null);
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
            this.setBitmap(bitmap, resId, null, 1, 0);
        }
    }

    public void setImageUriAsync(Uri uri) {
        if (uri != null) {
            BitmapLoadingWorkerJob currentTask;
            BitmapLoadingWorkerJob bitmapLoadingWorkerJob = currentTask = this.mBitmapLoadingWorkerJob != null ? (BitmapLoadingWorkerJob)this.mBitmapLoadingWorkerJob.get() : null;
            if (currentTask != null) {
                currentTask.cancel();
            }
            this.clearImageInt();
            this.mRestoreCropWindowRect = null;
            this.mRestoreDegreesRotated = 0;
            this.mCropOverlayView.setInitialCropWindowRect(null);
            this.mBitmapLoadingWorkerJob = new WeakReference<BitmapLoadingWorkerJob>(new BitmapLoadingWorkerJob((FragmentActivity)this.getContext(), this, uri));
            ((BitmapLoadingWorkerJob)this.mBitmapLoadingWorkerJob.get()).start();
            this.setProgressBarVisibility();
        }
    }

    public void clearImage() {
        this.clearImageInt();
        this.mCropOverlayView.setInitialCropWindowRect(null);
    }

    public void rotateImage(int degrees) {
        if (this.mBitmap != null) {
            degrees = degrees < 0 ? degrees % 360 + 360 : (degrees %= 360);
            boolean flipAxes = !this.mCropOverlayView.isFixAspectRatio() && (degrees > 45 && degrees < 135 || degrees > 215 && degrees < 305);
            BitmapUtils.RECT.set(this.mCropOverlayView.getCropWindowRect());
            float halfWidth = (flipAxes ? BitmapUtils.RECT.height() : BitmapUtils.RECT.width()) / 2.0f;
            float halfHeight = (flipAxes ? BitmapUtils.RECT.width() : BitmapUtils.RECT.height()) / 2.0f;
            if (flipAxes) {
                boolean isFlippedHorizontally = this.mFlipHorizontally;
                this.mFlipHorizontally = this.mFlipVertically;
                this.mFlipVertically = isFlippedHorizontally;
            }
            this.mImageMatrix.invert(this.mImageInverseMatrix);
            BitmapUtils.POINTS[0] = BitmapUtils.RECT.centerX();
            BitmapUtils.POINTS[1] = BitmapUtils.RECT.centerY();
            BitmapUtils.POINTS[2] = 0.0f;
            BitmapUtils.POINTS[3] = 0.0f;
            BitmapUtils.POINTS[4] = 1.0f;
            BitmapUtils.POINTS[5] = 0.0f;
            this.mImageInverseMatrix.mapPoints(BitmapUtils.POINTS);
            this.mDegreesRotated = (this.mDegreesRotated + degrees) % 360;
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
            this.mImageMatrix.mapPoints(BitmapUtils.POINTS2, BitmapUtils.POINTS);
            this.mZoom = (float)((double)this.mZoom / Math.sqrt(Math.pow(BitmapUtils.POINTS2[4] - BitmapUtils.POINTS2[2], 2.0) + Math.pow(BitmapUtils.POINTS2[5] - BitmapUtils.POINTS2[3], 2.0)));
            this.mZoom = Math.max(this.mZoom, 1.0f);
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
            this.mImageMatrix.mapPoints(BitmapUtils.POINTS2, BitmapUtils.POINTS);
            double change = Math.sqrt(Math.pow(BitmapUtils.POINTS2[4] - BitmapUtils.POINTS2[2], 2.0) + Math.pow(BitmapUtils.POINTS2[5] - BitmapUtils.POINTS2[3], 2.0));
            halfWidth = (float)((double)halfWidth * change);
            halfHeight = (float)((double)halfHeight * change);
            BitmapUtils.RECT.set(BitmapUtils.POINTS2[0] - halfWidth, BitmapUtils.POINTS2[1] - halfHeight, BitmapUtils.POINTS2[0] + halfWidth, BitmapUtils.POINTS2[1] + halfHeight);
            this.mCropOverlayView.resetCropOverlayView();
            this.mCropOverlayView.setCropWindowRect(BitmapUtils.RECT);
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
            this.handleCropWindowChanged(false, false);
            this.mCropOverlayView.fixCurrentCropWindowRect();
        }
    }

    public void flipImageHorizontally() {
        this.mFlipHorizontally = !this.mFlipHorizontally;
        this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
    }

    public void flipImageVertically() {
        this.mFlipVertically = !this.mFlipVertically;
        this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
    }

    void onSetImageUriAsyncComplete(BitmapLoadingWorkerJob.Result result) {
        OnSetImageUriCompleteListener listener;
        this.mBitmapLoadingWorkerJob = null;
        this.setProgressBarVisibility();
        if (result.getError() == null) {
            this.mInitialDegreesRotated = result.getDegreesRotated();
            this.setBitmap(result.getBitmap(), 0, result.getUri(), result.getLoadSampleSize(), result.getDegreesRotated());
        }
        if ((listener = this.mOnSetImageUriCompleteListener) != null) {
            listener.onSetImageUriComplete(this, result.getUri(), result.getError());
        }
    }

    void onImageCroppingAsyncComplete(BitmapCroppingWorkerJob.Result result) {
        this.mBitmapCroppingWorkerJob = null;
        this.setProgressBarVisibility();
        OnCropImageCompleteListener listener = this.mOnCropImageCompleteListener;
        if (listener != null) {
            CropResult cropResult = new CropResult(this.mBitmap, this.mLoadedImageUri, result.getBitmap(), result.getUri(), result.getError(), this.getCropPoints(), this.getCropRect(), this.getWholeImageRect(), this.getRotatedDegrees(), result.getSampleSize());
            listener.onCropImageComplete(this, cropResult);
        }
    }

    private void setBitmap(Bitmap bitmap, int imageResource, Uri imageUri, int loadSampleSize, int degreesRotated) {
        if (this.mBitmap == null || !this.mBitmap.equals(bitmap)) {
            this.mImageView.clearAnimation();
            this.clearImageInt();
            this.mBitmap = bitmap;
            this.mImageView.setImageBitmap(this.mBitmap);
            this.mLoadedImageUri = imageUri;
            this.mImageResource = imageResource;
            this.mLoadedSampleSize = loadSampleSize;
            this.mDegreesRotated = degreesRotated;
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
            if (this.mCropOverlayView != null) {
                this.mCropOverlayView.resetCropOverlayView();
                this.setCropOverlayVisibility();
            }
        }
    }

    private void clearImageInt() {
        if (this.mBitmap != null && (this.mImageResource > 0 || this.mLoadedImageUri != null)) {
            this.mBitmap.recycle();
        }
        this.mBitmap = null;
        this.mImageResource = 0;
        this.mLoadedImageUri = null;
        this.mLoadedSampleSize = 1;
        this.mDegreesRotated = 0;
        this.mZoom = 1.0f;
        this.mZoomOffsetX = 0.0f;
        this.mZoomOffsetY = 0.0f;
        this.mImageMatrix.reset();
        this.mSaveInstanceStateBitmapUri = null;
        this.mImageView.setImageBitmap(null);
        this.setCropOverlayVisibility();
    }

    public void startCropWorkerTask(int reqWidth, int reqHeight, RequestSizeOptions options, Uri saveUri, Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality) {
        Bitmap bitmap = this.mBitmap;
        if (bitmap != null) {
            BitmapCroppingWorkerJob currentTask;
            this.mImageView.clearAnimation();
            BitmapCroppingWorkerJob bitmapCroppingWorkerJob = currentTask = this.mBitmapCroppingWorkerJob != null ? (BitmapCroppingWorkerJob)this.mBitmapCroppingWorkerJob.get() : null;
            if (currentTask != null) {
                currentTask.cancel();
            }
            reqWidth = options != RequestSizeOptions.NONE ? reqWidth : 0;
            reqHeight = options != RequestSizeOptions.NONE ? reqHeight : 0;
            int orgWidth = bitmap.getWidth() * this.mLoadedSampleSize;
            int orgHeight = bitmap.getHeight() * this.mLoadedSampleSize;
            this.mBitmapCroppingWorkerJob = this.mLoadedImageUri != null && (this.mLoadedSampleSize > 1 || options == RequestSizeOptions.SAMPLING) ? new WeakReference<BitmapCroppingWorkerJob>(new BitmapCroppingWorkerJob((FragmentActivity)this.getContext(), this, this.mLoadedImageUri, this.getCropPoints(), this.mDegreesRotated, orgWidth, orgHeight, this.mCropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY(), reqWidth, reqHeight, this.mFlipHorizontally, this.mFlipVertically, options, saveUri, saveCompressFormat, saveCompressQuality)) : new WeakReference<BitmapCroppingWorkerJob>(new BitmapCroppingWorkerJob((FragmentActivity)this.getContext(), this, bitmap, this.getCropPoints(), this.mDegreesRotated, this.mCropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY(), reqWidth, reqHeight, this.mFlipHorizontally, this.mFlipVertically, options, saveUri, saveCompressFormat, saveCompressQuality));
            ((BitmapCroppingWorkerJob)this.mBitmapCroppingWorkerJob.get()).start();
            this.setProgressBarVisibility();
        }
    }

    public Parcelable onSaveInstanceState() {
        BitmapLoadingWorkerJob task;
        if (this.mLoadedImageUri == null && this.mBitmap == null && this.mImageResource < 1) {
            return super.onSaveInstanceState();
        }
        Bundle bundle = new Bundle();
        Uri imageUri = this.mLoadedImageUri;
        if (this.mSaveBitmapToInstanceState && imageUri == null && this.mImageResource < 1) {
            this.mSaveInstanceStateBitmapUri = imageUri = BitmapUtils.writeTempStateStoreBitmap(this.getContext(), this.mBitmap, this.mSaveInstanceStateBitmapUri);
        }
        if (imageUri != null && this.mBitmap != null) {
            String key = UUID.randomUUID().toString();
            BitmapUtils.mStateBitmap = new Pair((Object)key, new WeakReference<Bitmap>(this.mBitmap));
            bundle.putString("LOADED_IMAGE_STATE_BITMAP_KEY", key);
        }
        if (this.mBitmapLoadingWorkerJob != null && (task = (BitmapLoadingWorkerJob)this.mBitmapLoadingWorkerJob.get()) != null) {
            bundle.putParcelable("LOADING_IMAGE_URI", (Parcelable)task.getUri());
        }
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putParcelable("LOADED_IMAGE_URI", (Parcelable)imageUri);
        bundle.putInt("LOADED_IMAGE_RESOURCE", this.mImageResource);
        bundle.putInt("LOADED_SAMPLE_SIZE", this.mLoadedSampleSize);
        bundle.putInt("DEGREES_ROTATED", this.mDegreesRotated);
        bundle.putParcelable("INITIAL_CROP_RECT", (Parcelable)this.mCropOverlayView.getInitialCropWindowRect());
        BitmapUtils.RECT.set(this.mCropOverlayView.getCropWindowRect());
        this.mImageMatrix.invert(this.mImageInverseMatrix);
        this.mImageInverseMatrix.mapRect(BitmapUtils.RECT);
        bundle.putParcelable("CROP_WINDOW_RECT", (Parcelable)BitmapUtils.RECT);
        bundle.putString("CROP_SHAPE", this.mCropOverlayView.getCropShape().name());
        bundle.putBoolean("CROP_AUTO_ZOOM_ENABLED", this.mAutoZoomEnabled);
        bundle.putInt("CROP_MAX_ZOOM", this.mMaxZoom);
        bundle.putBoolean("CROP_FLIP_HORIZONTALLY", this.mFlipHorizontally);
        bundle.putBoolean("CROP_FLIP_VERTICALLY", this.mFlipVertically);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            if (this.mBitmapLoadingWorkerJob == null && this.mLoadedImageUri == null && this.mBitmap == null && this.mImageResource == 0) {
                RectF cropWindowRect;
                Uri uri = (Uri)bundle.getParcelable("LOADED_IMAGE_URI");
                if (uri != null) {
                    String key = bundle.getString("LOADED_IMAGE_STATE_BITMAP_KEY");
                    if (key != null) {
                        Bitmap stateBitmap = BitmapUtils.mStateBitmap != null && ((String)BitmapUtils.mStateBitmap.first).equals(key) ? (Bitmap)((WeakReference)BitmapUtils.mStateBitmap.second).get() : null;
                        BitmapUtils.mStateBitmap = null;
                        if (stateBitmap != null && !stateBitmap.isRecycled()) {
                            this.setBitmap(stateBitmap, 0, uri, bundle.getInt("LOADED_SAMPLE_SIZE"), 0);
                        }
                    }
                    if (this.mLoadedImageUri == null) {
                        this.setImageUriAsync(uri);
                    }
                } else {
                    int resId = bundle.getInt("LOADED_IMAGE_RESOURCE");
                    if (resId > 0) {
                        this.setImageResource(resId);
                    } else {
                        uri = (Uri)bundle.getParcelable("LOADING_IMAGE_URI");
                        if (uri != null) {
                            this.setImageUriAsync(uri);
                        }
                    }
                }
                this.mDegreesRotated = this.mRestoreDegreesRotated = bundle.getInt("DEGREES_ROTATED");
                Rect initialCropRect = (Rect)bundle.getParcelable("INITIAL_CROP_RECT");
                if (initialCropRect != null && (initialCropRect.width() > 0 || initialCropRect.height() > 0)) {
                    this.mCropOverlayView.setInitialCropWindowRect(initialCropRect);
                }
                if ((cropWindowRect = (RectF)bundle.getParcelable("CROP_WINDOW_RECT")) != null && (cropWindowRect.width() > 0.0f || cropWindowRect.height() > 0.0f)) {
                    this.mRestoreCropWindowRect = cropWindowRect;
                }
                this.mCropOverlayView.setCropShape(CropShape.valueOf(bundle.getString("CROP_SHAPE")));
                this.mAutoZoomEnabled = bundle.getBoolean("CROP_AUTO_ZOOM_ENABLED");
                this.mMaxZoom = bundle.getInt("CROP_MAX_ZOOM");
                this.mFlipHorizontally = bundle.getBoolean("CROP_FLIP_HORIZONTALLY");
                this.mFlipVertically = bundle.getBoolean("CROP_FLIP_VERTICALLY");
            }
            super.onRestoreInstanceState(bundle.getParcelable("instanceState"));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mBitmap != null) {
            int desiredHeight;
            int desiredWidth;
            if (heightSize == 0) {
                heightSize = this.mBitmap.getHeight();
            }
            double viewToBitmapWidthRatio = Double.POSITIVE_INFINITY;
            double viewToBitmapHeightRatio = Double.POSITIVE_INFINITY;
            if (widthSize < this.mBitmap.getWidth()) {
                viewToBitmapWidthRatio = (double)widthSize / (double)this.mBitmap.getWidth();
            }
            if (heightSize < this.mBitmap.getHeight()) {
                viewToBitmapHeightRatio = (double)heightSize / (double)this.mBitmap.getHeight();
            }
            if (viewToBitmapWidthRatio != Double.POSITIVE_INFINITY || viewToBitmapHeightRatio != Double.POSITIVE_INFINITY) {
                if (viewToBitmapWidthRatio <= viewToBitmapHeightRatio) {
                    desiredWidth = widthSize;
                    desiredHeight = (int)((double)this.mBitmap.getHeight() * viewToBitmapWidthRatio);
                } else {
                    desiredHeight = heightSize;
                    desiredWidth = (int)((double)this.mBitmap.getWidth() * viewToBitmapHeightRatio);
                }
            } else {
                desiredWidth = this.mBitmap.getWidth();
                desiredHeight = this.mBitmap.getHeight();
            }
            int width = CropImageView.getOnMeasureSpec(widthMode, widthSize, desiredWidth);
            int height = CropImageView.getOnMeasureSpec(heightMode, heightSize, desiredHeight);
            this.mLayoutWidth = width;
            this.mLayoutHeight = height;
            this.setMeasuredDimension(this.mLayoutWidth, this.mLayoutHeight);
        } else {
            this.setMeasuredDimension(widthSize, heightSize);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mLayoutWidth > 0 && this.mLayoutHeight > 0) {
            ViewGroup.LayoutParams origParams = this.getLayoutParams();
            origParams.width = this.mLayoutWidth;
            origParams.height = this.mLayoutHeight;
            this.setLayoutParams(origParams);
            if (this.mBitmap != null) {
                this.applyImageMatrix(r - l, b - t, true, false);
                if (this.mRestoreCropWindowRect != null) {
                    if (this.mRestoreDegreesRotated != this.mInitialDegreesRotated) {
                        this.mDegreesRotated = this.mRestoreDegreesRotated;
                        this.applyImageMatrix(r - l, b - t, true, false);
                    }
                    this.mImageMatrix.mapRect(this.mRestoreCropWindowRect);
                    this.mCropOverlayView.setCropWindowRect(this.mRestoreCropWindowRect);
                    this.handleCropWindowChanged(false, false);
                    this.mCropOverlayView.fixCurrentCropWindowRect();
                    this.mRestoreCropWindowRect = null;
                } else if (this.mSizeChanged) {
                    this.mSizeChanged = false;
                    this.handleCropWindowChanged(false, false);
                }
            } else {
                this.updateImageBounds(true);
            }
        } else {
            this.updateImageBounds(true);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mSizeChanged = oldw > 0 && oldh > 0;
    }

    private void handleCropWindowChanged(boolean inProgress, boolean animate) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mBitmap != null && width > 0 && height > 0) {
            RectF cropRect = this.mCropOverlayView.getCropWindowRect();
            if (inProgress) {
                if (cropRect.left < 0.0f || cropRect.top < 0.0f || cropRect.right > (float)width || cropRect.bottom > (float)height) {
                    this.applyImageMatrix(width, height, false, false);
                }
            } else if (this.mAutoZoomEnabled || this.mZoom > 1.0f) {
                float newZoom = 0.0f;
                if (this.mZoom < (float)this.mMaxZoom && cropRect.width() < (float)width * 0.5f && cropRect.height() < (float)height * 0.5f) {
                    newZoom = Math.min((float)this.mMaxZoom, Math.min((float)width / (cropRect.width() / this.mZoom / 0.64f), (float)height / (cropRect.height() / this.mZoom / 0.64f)));
                }
                if (this.mZoom > 1.0f && (cropRect.width() > (float)width * 0.65f || cropRect.height() > (float)height * 0.65f)) {
                    newZoom = Math.max(1.0f, Math.min((float)width / (cropRect.width() / this.mZoom / 0.51f), (float)height / (cropRect.height() / this.mZoom / 0.51f)));
                }
                if (!this.mAutoZoomEnabled) {
                    newZoom = 1.0f;
                }
                if (newZoom > 0.0f && newZoom != this.mZoom) {
                    if (animate) {
                        if (this.mAnimation == null) {
                            this.mAnimation = new CropImageAnimation(this.mImageView, this.mCropOverlayView);
                        }
                        this.mAnimation.setStartState(this.mImagePoints, this.mImageMatrix);
                    }
                    this.mZoom = newZoom;
                    this.applyImageMatrix(width, height, true, animate);
                }
            }
            if (this.mOnSetCropWindowChangeListener != null && !inProgress) {
                this.mOnSetCropWindowChangeListener.onCropWindowChanged();
            }
        }
    }

    private void applyImageMatrix(float width, float height, boolean center, boolean animate) {
        if (this.mBitmap != null && width > 0.0f && height > 0.0f) {
            this.mImageMatrix.invert(this.mImageInverseMatrix);
            RectF cropRect = this.mCropOverlayView.getCropWindowRect();
            this.mImageInverseMatrix.mapRect(cropRect);
            this.mImageMatrix.reset();
            this.mImageMatrix.postTranslate((width - (float)this.mBitmap.getWidth()) / 2.0f, (height - (float)this.mBitmap.getHeight()) / 2.0f);
            this.mapImagePointsByImageMatrix();
            if (this.mDegreesRotated > 0) {
                this.mImageMatrix.postRotate((float)this.mDegreesRotated, BitmapUtils.getRectCenterX(this.mImagePoints), BitmapUtils.getRectCenterY(this.mImagePoints));
                this.mapImagePointsByImageMatrix();
            }
            float scale = Math.min(width / BitmapUtils.getRectWidth(this.mImagePoints), height / BitmapUtils.getRectHeight(this.mImagePoints));
            if (this.mScaleType == ScaleType.FIT_CENTER || this.mScaleType == ScaleType.CENTER_INSIDE && scale < 1.0f || scale > 1.0f && this.mAutoZoomEnabled) {
                this.mImageMatrix.postScale(scale, scale, BitmapUtils.getRectCenterX(this.mImagePoints), BitmapUtils.getRectCenterY(this.mImagePoints));
                this.mapImagePointsByImageMatrix();
            }
            float scaleX = this.mFlipHorizontally ? -this.mZoom : this.mZoom;
            float scaleY = this.mFlipVertically ? -this.mZoom : this.mZoom;
            this.mImageMatrix.postScale(scaleX, scaleY, BitmapUtils.getRectCenterX(this.mImagePoints), BitmapUtils.getRectCenterY(this.mImagePoints));
            this.mapImagePointsByImageMatrix();
            this.mImageMatrix.mapRect(cropRect);
            if (center) {
                this.mZoomOffsetX = width > BitmapUtils.getRectWidth(this.mImagePoints) ? 0.0f : Math.max(Math.min(width / 2.0f - cropRect.centerX(), -BitmapUtils.getRectLeft(this.mImagePoints)), (float)this.getWidth() - BitmapUtils.getRectRight(this.mImagePoints)) / scaleX;
                this.mZoomOffsetY = height > BitmapUtils.getRectHeight(this.mImagePoints) ? 0.0f : Math.max(Math.min(height / 2.0f - cropRect.centerY(), -BitmapUtils.getRectTop(this.mImagePoints)), (float)this.getHeight() - BitmapUtils.getRectBottom(this.mImagePoints)) / scaleY;
            } else {
                this.mZoomOffsetX = Math.min(Math.max(this.mZoomOffsetX * scaleX, -cropRect.left), -cropRect.right + width) / scaleX;
                this.mZoomOffsetY = Math.min(Math.max(this.mZoomOffsetY * scaleY, -cropRect.top), -cropRect.bottom + height) / scaleY;
            }
            this.mImageMatrix.postTranslate(this.mZoomOffsetX * scaleX, this.mZoomOffsetY * scaleY);
            cropRect.offset(this.mZoomOffsetX * scaleX, this.mZoomOffsetY * scaleY);
            this.mCropOverlayView.setCropWindowRect(cropRect);
            this.mapImagePointsByImageMatrix();
            this.mCropOverlayView.invalidate();
            if (animate) {
                this.mAnimation.setEndState(this.mImagePoints, this.mImageMatrix);
                this.mImageView.startAnimation((Animation)this.mAnimation);
            } else {
                this.mImageView.setImageMatrix(this.mImageMatrix);
            }
            this.updateImageBounds(false);
        }
    }

    private void mapImagePointsByImageMatrix() {
        this.mImagePoints[0] = 0.0f;
        this.mImagePoints[1] = 0.0f;
        this.mImagePoints[2] = this.mBitmap.getWidth();
        this.mImagePoints[3] = 0.0f;
        this.mImagePoints[4] = this.mBitmap.getWidth();
        this.mImagePoints[5] = this.mBitmap.getHeight();
        this.mImagePoints[6] = 0.0f;
        this.mImagePoints[7] = this.mBitmap.getHeight();
        this.mImageMatrix.mapPoints(this.mImagePoints);
        this.mScaleImagePoints[0] = 0.0f;
        this.mScaleImagePoints[1] = 0.0f;
        this.mScaleImagePoints[2] = 100.0f;
        this.mScaleImagePoints[3] = 0.0f;
        this.mScaleImagePoints[4] = 100.0f;
        this.mScaleImagePoints[5] = 100.0f;
        this.mScaleImagePoints[6] = 0.0f;
        this.mScaleImagePoints[7] = 100.0f;
        this.mImageMatrix.mapPoints(this.mScaleImagePoints);
    }

    private static int getOnMeasureSpec(int measureSpecMode, int measureSpecSize, int desiredSize) {
        int spec = measureSpecMode == 0x40000000 ? measureSpecSize : (measureSpecMode == Integer.MIN_VALUE ? Math.min(desiredSize, measureSpecSize) : desiredSize);
        return spec;
    }

    private void setCropOverlayVisibility() {
        if (this.mCropOverlayView != null) {
            this.mCropOverlayView.setVisibility(this.mShowCropOverlay && this.mBitmap != null ? 0 : 4);
        }
    }

    private void setProgressBarVisibility() {
        boolean visible = this.mShowProgressBar && (this.mBitmap == null && this.mBitmapLoadingWorkerJob != null || this.mBitmapCroppingWorkerJob != null);
        this.mProgressBar.setVisibility(visible ? 0 : 4);
    }

    private void updateImageBounds(boolean clear) {
        if (this.mBitmap != null && !clear) {
            float scaleFactorWidth = 100.0f * (float)this.mLoadedSampleSize / BitmapUtils.getRectWidth(this.mScaleImagePoints);
            float scaleFactorHeight = 100.0f * (float)this.mLoadedSampleSize / BitmapUtils.getRectHeight(this.mScaleImagePoints);
            this.mCropOverlayView.setCropWindowLimits(this.getWidth(), this.getHeight(), scaleFactorWidth, scaleFactorHeight);
        }
        this.mCropOverlayView.setBounds(clear ? null : this.mImagePoints, this.getWidth(), this.getHeight());
    }

    public static class CropResult {
        private final Bitmap mOriginalBitmap;
        private final Uri mOriginalUri;
        private final Bitmap mBitmap;
        private final Uri mUri;
        private final Exception mError;
        private final float[] mCropPoints;
        private final Rect mCropRect;
        private final Rect mWholeImageRect;
        private final int mRotation;
        private final int mSampleSize;

        CropResult(Bitmap originalBitmap, Uri originalUri, Bitmap bitmap, Uri uri, Exception error, float[] cropPoints, Rect cropRect, Rect wholeImageRect, int rotation, int sampleSize) {
            this.mOriginalBitmap = originalBitmap;
            this.mOriginalUri = originalUri;
            this.mBitmap = bitmap;
            this.mUri = uri;
            this.mError = error;
            this.mCropPoints = cropPoints;
            this.mCropRect = cropRect;
            this.mWholeImageRect = wholeImageRect;
            this.mRotation = rotation;
            this.mSampleSize = sampleSize;
        }

        public Bitmap getOriginalBitmap() {
            return this.mOriginalBitmap;
        }

        public Uri getOriginalUri() {
            return this.mOriginalUri;
        }

        public boolean isSuccessful() {
            return this.mError == null;
        }

        public Bitmap getBitmap() {
            return this.mBitmap;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public Exception getError() {
            return this.mError;
        }

        public float[] getCropPoints() {
            return this.mCropPoints;
        }

        public Rect getCropRect() {
            return this.mCropRect;
        }

        public Rect getWholeImageRect() {
            return this.mWholeImageRect;
        }

        public int getRotation() {
            return this.mRotation;
        }

        public int getSampleSize() {
            return this.mSampleSize;
        }
    }

    public static interface OnCropImageCompleteListener {
        public void onCropImageComplete(CropImageView var1, CropResult var2);
    }

    public static interface OnSetImageUriCompleteListener {
        public void onSetImageUriComplete(CropImageView var1, Uri var2, Exception var3);
    }

    public static interface OnSetCropWindowChangeListener {
        public void onCropWindowChanged();
    }

    public static interface OnSetCropOverlayMovedListener {
        public void onCropOverlayMoved(Rect var1);
    }

    public static interface OnSetCropOverlayReleasedListener {
        public void onCropOverlayReleased(Rect var1);
    }

    public static enum RequestSizeOptions {
        NONE,
        SAMPLING,
        RESIZE_INSIDE,
        RESIZE_FIT,
        RESIZE_EXACT;

    }

    public static enum Guidelines {
        OFF,
        ON_TOUCH,
        ON;

    }

    public static enum ScaleType {
        FIT_CENTER,
        CENTER,
        CENTER_CROP,
        CENTER_INSIDE;

    }

    public static enum CropShape {
        RECTANGLE,
        OVAL;

    }
}

