/*
 * Decompiled with CFR 0.152.
 */
package io.calidog.certstream;

import io.calidog.certstream.CertStreamClientImplFactory;
import io.calidog.certstream.CertStreamCloseHandler;
import io.calidog.certstream.CertStreamErrorHandler;
import io.calidog.certstream.CertStreamOpenHandler;
import io.calidog.certstream.CertStreamStringMessageHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoringParts
implements CertStreamErrorHandler,
CertStreamCloseHandler,
CertStreamOpenHandler {
    private static final Logger logger = LoggerFactory.getLogger(BoringParts.class);
    private final long sleepBeforeReconnect;
    private HashSet<Integer> recoverableCloseCodes = new HashSet<Integer>(Arrays.asList(1000, 1001, 1002, 1005, 1006, 1009));
    private final Supplier<WebSocketClient> webSocketClientSupplier;
    private WebSocketClient webSocketClient;
    private final CertStreamClientImplFactory defaultImplFactory = new CertStreamClientImplFactory(this, this, this);

    public BoringParts(CertStreamStringMessageHandler handler) {
        this(handler, 0L);
    }

    public BoringParts(CertStreamStringMessageHandler messageHandler, long sleepBeforeReconnect) {
        this.sleepBeforeReconnect = sleepBeforeReconnect;
        this.webSocketClientSupplier = () -> this.defaultImplFactory.make(messageHandler);
        this.webSocketClient = this.webSocketClientSupplier.get();
    }

    public BoringParts(CertStreamStringMessageHandler messageHandler, long sleepBeforeReconnect, String serverURI) {
        this.sleepBeforeReconnect = sleepBeforeReconnect;
        this.webSocketClientSupplier = () -> this.defaultImplFactory.make(messageHandler, serverURI);
        this.webSocketClient = this.webSocketClientSupplier.get();
    }

    @Override
    public void onClose(int i, String s, boolean b) {
        logger.debug("OnClose was called wih i = " + i + ", s = " + s + ", b = b");
        if (this.recoverableCloseCodes.contains(i)) {
            if (this.sleepBeforeReconnect >= 0L) {
                try {
                    Thread.yield();
                    Thread.sleep(this.sleepBeforeReconnect);
                }
                catch (InterruptedException e) {
                    logger.info("Thread sleep interrupted, weird, exiting", (Throwable)e);
                    return;
                }
            }
            this.webSocketClient = this.webSocketClientSupplier.get();
        } else {
            logger.warn("OnClose was called wih i = " + i + ", s = " + s + ", b = b");
        }
    }

    @Override
    public void onError(Exception e) {
        System.out.println("Exception occurred: " + e.getMessage());
        e.printStackTrace();
        logger.debug("OnError was called for: " + e);
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        StackTraceElement[] currentStack = Thread.getAllStackTraces().get(Thread.currentThread());
        StringBuilder bob = new StringBuilder();
        for (StackTraceElement i : currentStack) {
            bob.append(i.toString()).append("\n");
        }
        logger.debug("OnOpen was called with this call tree: " + bob.toString());
    }

    public boolean isNotClosed() {
        return !this.webSocketClient.isClosed();
    }
}

