/*
 * Decompiled with CFR 0.152.
 */
package com.bytehamster.lib.preferencesearch;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.ColorInt;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.fragment.app.FragmentManager;
import androidx.preference.Preference;
import androidx.preference.PreferenceFragmentCompat;
import com.bytehamster.lib.preferencesearch.R;

public class SearchPreferenceResult {
    private final String key;
    private final int file;
    private final String screen;

    SearchPreferenceResult(String key, int file, String screen) {
        this.key = key;
        this.file = file;
        this.screen = screen;
    }

    public String getKey() {
        return this.key;
    }

    public int getResourceFile() {
        return this.file;
    }

    public String getScreen() {
        return this.screen;
    }

    public void highlight(PreferenceFragmentCompat prefsFragment) {
        this.highlight(prefsFragment, -12627531);
    }

    public void highlight(final PreferenceFragmentCompat prefsFragment, final @ColorInt int color) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                SearchPreferenceResult.this.doHighlight(prefsFragment, color);
            }
        });
    }

    private void doHighlight(PreferenceFragmentCompat prefsFragment, @ColorInt int color) {
        final Preference prefResult = prefsFragment.findPreference((CharSequence)this.getKey());
        if (prefResult == null) {
            Log.e((String)"doHighlight", (String)"Preference not found on given screen");
            return;
        }
        if ((color & 0xFF000000) == 0) {
            color -= 0x1000000;
        }
        prefsFragment.scrollToPreference(prefResult);
        final Drawable oldIcon = prefResult.getIcon();
        final boolean oldSpaceReserved = prefResult.isIconSpaceReserved();
        Drawable arrow = AppCompatResources.getDrawable((Context)prefsFragment.getContext(), (int)R.drawable.searchpreference_ic_arrow_right);
        arrow.setColorFilter(color, PorterDuff.Mode.SRC_IN);
        prefResult.setIcon(arrow);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                prefResult.setIcon(oldIcon);
                prefResult.setIconSpaceReserved(oldSpaceReserved);
            }
        }, 1000L);
    }

    public void closeSearchPage(AppCompatActivity activity) {
        FragmentManager fm = activity.getSupportFragmentManager();
        fm.beginTransaction().remove(fm.findFragmentByTag("SearchPreferenceFragment")).commit();
    }
}

