/*
 * Decompiled with CFR 0.152.
 */
package com.bytehamster.lib.preferencesearch;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.PopupMenu;
import androidx.cardview.widget.CardView;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bytehamster.lib.preferencesearch.HistoryItem;
import com.bytehamster.lib.preferencesearch.ListItem;
import com.bytehamster.lib.preferencesearch.PreferenceItem;
import com.bytehamster.lib.preferencesearch.PreferenceParser;
import com.bytehamster.lib.preferencesearch.R;
import com.bytehamster.lib.preferencesearch.SearchConfiguration;
import com.bytehamster.lib.preferencesearch.SearchPreferenceAdapter;
import com.bytehamster.lib.preferencesearch.SearchPreferenceResult;
import com.bytehamster.lib.preferencesearch.SearchPreferenceResultListener;
import com.bytehamster.lib.preferencesearch.ui.AnimationUtils;
import com.bytehamster.lib.preferencesearch.ui.RevealAnimationSetting;
import java.util.ArrayList;
import java.util.List;

public class SearchPreferenceFragment
extends Fragment
implements SearchPreferenceAdapter.SearchClickListener {
    static final String NAME = "SearchPreferenceFragment";
    private static final String SHARED_PREFS_FILE = "preferenceSearch";
    private static final int MAX_HISTORY = 5;
    private PreferenceParser searcher;
    private List<PreferenceItem> results;
    private List<HistoryItem> history;
    private SharedPreferences prefs;
    private SearchViewHolder viewHolder;
    private SearchConfiguration searchConfiguration;
    private SearchPreferenceAdapter adapter;
    private HistoryClickListener historyClickListener;
    private CharSequence searchTermPreset = null;
    private TextWatcher textWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void afterTextChanged(Editable editable) {
            SearchPreferenceFragment.this.updateSearchResults(editable.toString());
            SearchPreferenceFragment.this.viewHolder.clearButton.setVisibility(editable.toString().isEmpty() ? 8 : 0);
        }
    };

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.prefs = this.getContext().getSharedPreferences(SHARED_PREFS_FILE, 0);
        this.searcher = new PreferenceParser(this.getContext());
        this.searchConfiguration = SearchConfiguration.fromBundle(this.getArguments());
        ArrayList<SearchConfiguration.SearchIndexItem> files = this.searchConfiguration.getFiles();
        for (SearchConfiguration.SearchIndexItem file : files) {
            this.searcher.addResourceFile(file);
        }
        this.loadHistory();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        RevealAnimationSetting anim;
        View rootView = inflater.inflate(R.layout.searchpreference_fragment, container, false);
        this.viewHolder = new SearchViewHolder(rootView);
        this.viewHolder.clearButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SearchPreferenceFragment.this.viewHolder.searchView.setText((CharSequence)"");
            }
        });
        if (this.searchConfiguration.isHistoryEnabled()) {
            this.viewHolder.moreButton.setVisibility(0);
        }
        if (this.searchConfiguration.getTextHint() != null) {
            this.viewHolder.searchView.setHint((CharSequence)this.searchConfiguration.getTextHint());
        }
        if (this.searchConfiguration.getTextNoResults() != null) {
            this.viewHolder.noResults.setText((CharSequence)this.searchConfiguration.getTextNoResults());
        }
        this.viewHolder.moreButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PopupMenu popup = new PopupMenu(SearchPreferenceFragment.this.getContext(), (View)SearchPreferenceFragment.this.viewHolder.moreButton);
                popup.getMenuInflater().inflate(R.menu.searchpreference_more, popup.getMenu());
                if (SearchPreferenceFragment.this.searchConfiguration.getTextClearHistory() != null) {
                    popup.getMenu().findItem(R.id.clear_history).setTitle((CharSequence)SearchPreferenceFragment.this.searchConfiguration.getTextClearHistory());
                }
                popup.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

                    public boolean onMenuItemClick(MenuItem item) {
                        if (item.getItemId() == R.id.clear_history) {
                            SearchPreferenceFragment.this.clearHistory();
                        }
                        return true;
                    }
                });
                popup.show();
            }
        });
        this.viewHolder.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.adapter = new SearchPreferenceAdapter();
        this.adapter.setSearchConfiguration(this.searchConfiguration);
        this.adapter.setOnItemClickListener(this);
        this.viewHolder.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.viewHolder.searchView.addTextChangedListener(this.textWatcher);
        if (!this.searchConfiguration.isSearchBarEnabled()) {
            this.viewHolder.cardView.setVisibility(8);
        }
        if (this.searchTermPreset != null) {
            this.viewHolder.searchView.setText(this.searchTermPreset);
        }
        if ((anim = this.searchConfiguration.getRevealAnimationSetting()) != null) {
            AnimationUtils.registerCircularRevealAnimation(this.getContext(), rootView, anim);
        }
        return rootView;
    }

    private void loadHistory() {
        this.history = new ArrayList<HistoryItem>();
        if (!this.searchConfiguration.isHistoryEnabled()) {
            return;
        }
        int size = this.prefs.getInt("history_size", 0);
        for (int i = 0; i < size; ++i) {
            String title = this.prefs.getString("history_" + i, null);
            this.history.add(new HistoryItem(title));
        }
    }

    private void saveHistory() {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putInt("history_size", this.history.size());
        for (int i = 0; i < this.history.size(); ++i) {
            editor.putString("history_" + i, this.history.get(i).getTerm());
        }
        editor.apply();
    }

    private void clearHistory() {
        this.viewHolder.searchView.setText((CharSequence)"");
        this.history.clear();
        this.saveHistory();
        this.updateSearchResults("");
    }

    private void addHistoryEntry(String entry) {
        HistoryItem newItem = new HistoryItem(entry);
        if (!this.history.contains(newItem)) {
            if (this.history.size() >= 5) {
                this.history.remove(this.history.size() - 1);
            }
            this.history.add(0, newItem);
            this.saveHistory();
            this.updateSearchResults(this.viewHolder.searchView.getText().toString());
        }
    }

    public void onResume() {
        super.onResume();
        this.updateSearchResults(this.viewHolder.searchView.getText().toString());
        if (this.searchConfiguration.isSearchBarEnabled()) {
            this.showKeyboard();
        }
    }

    private void showKeyboard() {
        this.viewHolder.searchView.post(new Runnable(){

            @Override
            public void run() {
                SearchPreferenceFragment.this.viewHolder.searchView.requestFocus();
                InputMethodManager imm = (InputMethodManager)SearchPreferenceFragment.this.getActivity().getSystemService("input_method");
                if (imm != null) {
                    imm.showSoftInput((View)SearchPreferenceFragment.this.viewHolder.searchView, 1);
                }
            }
        });
    }

    private void hideKeyboard() {
        View view = this.getActivity().getCurrentFocus();
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        if (view != null && imm != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void setSearchTerm(CharSequence term) {
        if (this.viewHolder != null) {
            this.viewHolder.searchView.setText(term);
        } else {
            this.searchTermPreset = term;
        }
    }

    private void updateSearchResults(String keyword) {
        if (TextUtils.isEmpty((CharSequence)keyword)) {
            this.showHistory();
            return;
        }
        this.results = this.searcher.searchFor(keyword, this.searchConfiguration.isFuzzySearchEnabled());
        this.adapter.setContent(new ArrayList<ListItem>(this.results));
        this.setEmptyViewShown(this.results.isEmpty());
    }

    private void setEmptyViewShown(boolean shown) {
        if (shown) {
            this.viewHolder.noResults.setVisibility(0);
            this.viewHolder.recyclerView.setVisibility(8);
        } else {
            this.viewHolder.noResults.setVisibility(8);
            this.viewHolder.recyclerView.setVisibility(0);
        }
    }

    private void showHistory() {
        this.viewHolder.noResults.setVisibility(8);
        this.viewHolder.recyclerView.setVisibility(0);
        this.adapter.setContent(new ArrayList<ListItem>(this.history));
        this.setEmptyViewShown(this.history.isEmpty());
    }

    @Override
    public void onItemClicked(ListItem item, int position) {
        if (item.getType() == 1) {
            String text = ((HistoryItem)item).getTerm();
            this.viewHolder.searchView.setText((CharSequence)text);
            this.viewHolder.searchView.setSelection(text.length());
            if (this.historyClickListener != null) {
                this.historyClickListener.onHistoryEntryClicked(text.toString());
            }
        } else {
            this.addHistoryEntry(this.viewHolder.searchView.getText().toString());
            this.hideKeyboard();
            try {
                SearchPreferenceResultListener callback = (SearchPreferenceResultListener)this.getActivity();
                PreferenceItem r = this.results.get(position);
                String screen = null;
                if (!r.keyBreadcrumbs.isEmpty()) {
                    screen = r.keyBreadcrumbs.get(r.keyBreadcrumbs.size() - 1);
                }
                SearchPreferenceResult result = new SearchPreferenceResult(r.key, r.resId, screen);
                callback.onSearchResultClicked(result);
            }
            catch (ClassCastException e) {
                throw new ClassCastException(this.getActivity().toString() + " must implement SearchPreferenceResultListener");
            }
        }
    }

    public void setHistoryClickListener(HistoryClickListener historyClickListener) {
        this.historyClickListener = historyClickListener;
    }

    public static interface HistoryClickListener {
        public void onHistoryEntryClicked(String var1);
    }

    private static class SearchViewHolder {
        private ImageView clearButton;
        private ImageView moreButton;
        private EditText searchView;
        private RecyclerView recyclerView;
        private TextView noResults;
        private CardView cardView;

        SearchViewHolder(View root) {
            this.searchView = (EditText)root.findViewById(R.id.search);
            this.clearButton = (ImageView)root.findViewById(R.id.clear);
            this.recyclerView = (RecyclerView)root.findViewById(R.id.list);
            this.moreButton = (ImageView)root.findViewById(R.id.more);
            this.noResults = (TextView)root.findViewById(R.id.no_results);
            this.cardView = (CardView)root.findViewById(R.id.search_card);
        }
    }
}

