/*
 * Decompiled with CFR 0.152.
 */
package com.bytehamster.lib.preferencesearch;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import com.bytehamster.lib.preferencesearch.R;
import com.bytehamster.lib.preferencesearch.SearchConfiguration;

public class SearchPreference
extends Preference
implements View.OnClickListener {
    private SearchConfiguration searchConfiguration = new SearchConfiguration();
    private String hint = null;

    public SearchPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayoutResource(R.layout.searchpreference_preference);
        this.parseAttrs(attrs);
    }

    public SearchPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayoutResource(R.layout.searchpreference_preference);
        this.parseAttrs(attrs);
    }

    public SearchPreference(Context context) {
        super(context);
        this.setLayoutResource(R.layout.searchpreference_preference);
    }

    private void parseAttrs(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, new int[]{R.attr.textHint});
        if (a.getText(0) != null) {
            this.hint = a.getText(0).toString();
            this.searchConfiguration.setTextHint(a.getText(0).toString());
        }
        a.recycle();
        a = this.getContext().obtainStyledAttributes(attrs, new int[]{R.attr.textClearHistory});
        if (a.getText(0) != null) {
            this.searchConfiguration.setTextClearHistory(a.getText(0).toString());
        }
        a.recycle();
        a = this.getContext().obtainStyledAttributes(attrs, new int[]{R.attr.textNoResults});
        if (a.getText(0) != null) {
            this.searchConfiguration.setTextNoResults(a.getText(0).toString());
        }
        a.recycle();
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        EditText searchText = (EditText)holder.findViewById(R.id.search);
        searchText.setFocusable(false);
        searchText.setInputType(0);
        searchText.setOnClickListener((View.OnClickListener)this);
        if (this.hint != null) {
            searchText.setHint((CharSequence)this.hint);
        }
        holder.findViewById(R.id.search_card).setOnClickListener((View.OnClickListener)this);
        holder.itemView.setOnClickListener((View.OnClickListener)this);
        holder.itemView.setBackgroundColor(0);
    }

    public void onClick(View view) {
        this.getSearchConfiguration().showSearchFragment();
    }

    public SearchConfiguration getSearchConfiguration() {
        return this.searchConfiguration;
    }
}

