/*
 * Decompiled with CFR 0.152.
 */
package com.blackcat.currencyedittext;

import java.text.DecimalFormat;
import java.util.Currency;
import java.util.Locale;

public final class CurrencyTextFormatter {
    static final int MAX_RAW_INPUT_LENGTH = 15;

    private CurrencyTextFormatter() {
    }

    public static String formatText(String val, Currency currency, Locale locale) {
        return CurrencyTextFormatter.formatText(val, currency, locale, Locale.US);
    }

    public static String formatText(String val, Currency currency, Locale locale, Locale defaultLocale) {
        double CURRENCY_DECIMAL_DIVISOR;
        if (val.equals("-")) {
            return val;
        }
        DecimalFormat currencyFormatter = null;
        try {
            CURRENCY_DECIMAL_DIVISOR = (int)Math.pow(10.0, currency.getDefaultFractionDigits());
            currencyFormatter = (DecimalFormat)DecimalFormat.getCurrencyInstance(locale);
        }
        catch (IllegalArgumentException e) {
            CURRENCY_DECIMAL_DIVISOR = (int)Math.pow(10.0, Currency.getInstance(defaultLocale).getDefaultFractionDigits());
            currencyFormatter = (DecimalFormat)DecimalFormat.getCurrencyInstance(defaultLocale);
        }
        if (val.equals("") || val.length() >= 15 || val.equals("-")) {
            throw new IllegalArgumentException("Invalid amount of digits found (either zero or too many) in argument val");
        }
        double newTextValue = Double.valueOf(val);
        val = currencyFormatter.format(newTextValue /= CURRENCY_DECIMAL_DIVISOR);
        return val;
    }
}

