/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.impl;

import com.whatsapp.api.WhatsappApiServiceGenerator;
import com.whatsapp.api.configuration.ApiVersion;
import com.whatsapp.api.configuration.WhatsappApiConfig;
import com.whatsapp.api.domain.media.FileType;
import com.whatsapp.api.domain.media.Media;
import com.whatsapp.api.domain.media.MediaFile;
import com.whatsapp.api.domain.media.UploadResponse;
import com.whatsapp.api.domain.messages.Message;
import com.whatsapp.api.domain.messages.ReadMessage;
import com.whatsapp.api.domain.messages.response.MessageResponse;
import com.whatsapp.api.domain.phone.TwoStepCode;
import com.whatsapp.api.domain.response.Response;
import com.whatsapp.api.service.WhatsappBusinessCloudApiService;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class WhatsappBusinessCloudApi {
    private final WhatsappBusinessCloudApiService whatsappBusinessCloudApiService;
    private final ApiVersion apiVersion;

    public WhatsappBusinessCloudApi(String token) {
        this.apiVersion = WhatsappApiConfig.getApiVersion();
        this.whatsappBusinessCloudApiService = WhatsappApiServiceGenerator.createService(WhatsappBusinessCloudApiService.class, token);
    }

    public WhatsappBusinessCloudApi(String token, ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        this.whatsappBusinessCloudApiService = WhatsappApiServiceGenerator.createService(WhatsappBusinessCloudApiService.class, token);
    }

    public MessageResponse sendMessage(String phoneNumberId, Message message) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.sendMessage(this.apiVersion.getValue(), phoneNumberId, message));
    }

    public UploadResponse uploadMedia(String phoneNumberId, String fileName, FileType fileType, byte[] file) {
        RequestBody requestFile = MultipartBody.create((byte[])file, (MediaType)MediaType.parse((String)fileType.getType()));
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)fileName, (RequestBody)requestFile);
        MultipartBody.Part messageProduct = MultipartBody.Part.createFormData((String)"messaging_product", (String)"whatsapp");
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.uploadMedia(this.apiVersion.getValue(), phoneNumberId, body, messageProduct));
    }

    public Media retrieveMediaUrl(String mediaId) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.retrieveMediaUrl(this.apiVersion.getValue(), mediaId));
    }

    public MediaFile downloadMediaFile(String url) {
        return WhatsappApiServiceGenerator.executeDownloadSync(this.whatsappBusinessCloudApiService.downloadMediaFile(url));
    }

    public Response deleteMedia(String mediaId) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.deleteMedia(this.apiVersion.getValue(), mediaId));
    }

    public Response markMessageAsRead(String phoneNumberId, ReadMessage message) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.markMessageAsRead(this.apiVersion.getValue(), phoneNumberId, message));
    }

    public Response twoStepVerification(String phoneNumberId, TwoStepCode twoStepCode) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.twoStepVerification(this.apiVersion.getValue(), phoneNumberId, twoStepCode));
    }
}

