/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.domain.messages;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.whatsapp.api.domain.messages.AudioMessage;
import com.whatsapp.api.domain.messages.Contact;
import com.whatsapp.api.domain.messages.ContactMessage;
import com.whatsapp.api.domain.messages.Context;
import com.whatsapp.api.domain.messages.DocumentMessage;
import com.whatsapp.api.domain.messages.ImageMessage;
import com.whatsapp.api.domain.messages.InteractiveMessage;
import com.whatsapp.api.domain.messages.LocationMessage;
import com.whatsapp.api.domain.messages.ReactionMessage;
import com.whatsapp.api.domain.messages.StickerMessage;
import com.whatsapp.api.domain.messages.TemplateMessage;
import com.whatsapp.api.domain.messages.TextMessage;
import com.whatsapp.api.domain.messages.VideoMessage;
import com.whatsapp.api.domain.messages.type.MessageType;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Message {
    @JsonProperty(value="messaging_product")
    private final String messagingProduct = "whatsapp";
    @JsonProperty(value="recipient_type")
    private final String recipientType = "individual";
    @JsonProperty(value="context")
    private Context context;
    @JsonProperty(value="interactive")
    private InteractiveMessage interactiveMessage;
    @JsonProperty(value="to")
    private String to;
    @JsonProperty(value="type")
    private MessageType type;
    @JsonProperty(value="text")
    private TextMessage textMessage;
    @JsonProperty(value="contacts")
    private List<Contact> contactMessage;
    @JsonProperty(value="template")
    private TemplateMessage templateMessage;
    @JsonProperty(value="audio")
    private AudioMessage audioMessage;
    @JsonProperty(value="document")
    private DocumentMessage documentMessage;
    @JsonProperty(value="image")
    private ImageMessage imageMessage;
    @JsonProperty(value="sticker")
    private StickerMessage stickerMessage;
    @JsonProperty(value="video")
    private VideoMessage videoMessage;
    @JsonProperty(value="reaction")
    private ReactionMessage reactionMessage;
    @JsonProperty(value="location")
    private LocationMessage locationMessage;

    private Message() {
    }

    private Message(String to, MessageType type, Context context) {
        this.to = to;
        this.type = type;
        this.context = context;
    }

    public String getMessagingProduct() {
        return "whatsapp";
    }

    public String getRecipientType() {
        return "individual";
    }

    public Context getContext() {
        return this.context;
    }

    public InteractiveMessage getInteractiveMessage() {
        return this.interactiveMessage;
    }

    public String getTo() {
        return this.to;
    }

    public MessageType getType() {
        return this.type;
    }

    public TextMessage getTextMessage() {
        return this.textMessage;
    }

    public List<Contact> getContactMessage() {
        return this.contactMessage;
    }

    public TemplateMessage getTemplateMessage() {
        return this.templateMessage;
    }

    public AudioMessage getAudioMessage() {
        return this.audioMessage;
    }

    public DocumentMessage getDocumentMessage() {
        return this.documentMessage;
    }

    public ImageMessage getImageMessage() {
        return this.imageMessage;
    }

    public StickerMessage getStickerMessage() {
        return this.stickerMessage;
    }

    public VideoMessage getVideoMessage() {
        return this.videoMessage;
    }

    public ReactionMessage getReactionMessage() {
        return this.reactionMessage;
    }

    public LocationMessage getLocationMessage() {
        return this.locationMessage;
    }

    public static class MessageBuilder {
        private String to;
        private Context context;

        private MessageBuilder() {
        }

        public static MessageBuilder builder() {
            return new MessageBuilder();
        }

        public MessageBuilder setTo(String to) {
            this.to = to;
            return this;
        }

        public MessageBuilder setContext(Context context) {
            this.context = context;
            return this;
        }

        public Message buildTextMessage(TextMessage textMessage) {
            Message message = new Message(this.to, MessageType.TEXT, this.context);
            message.textMessage = textMessage;
            return message;
        }

        public Message buildContactMessage(ContactMessage contactMessage) {
            Message message = new Message(this.to, MessageType.CONTACTS, this.context);
            message.contactMessage = contactMessage.getContacts();
            return message;
        }

        public Message buildTemplateMessage(TemplateMessage templateMessage) {
            Message message = new Message(this.to, MessageType.TEMPLATE, this.context);
            message.templateMessage = templateMessage;
            return message;
        }

        public Message buildInteractiveMessage(InteractiveMessage interactiveMessage) {
            Message message = new Message(this.to, MessageType.INTERACTIVE, this.context);
            message.interactiveMessage = interactiveMessage;
            return message;
        }

        public Message buildAudioMessage(AudioMessage audioMessage) {
            Message message = new Message(this.to, MessageType.AUDIO, this.context);
            message.audioMessage = audioMessage;
            return message;
        }

        public Message buildDocumentMessage(DocumentMessage documentMessage) {
            Message message = new Message(this.to, MessageType.DOCUMENT, this.context);
            message.documentMessage = documentMessage;
            return message;
        }

        public Message buildImageMessage(ImageMessage imageMessage) {
            Message message = new Message(this.to, MessageType.IMAGE, this.context);
            message.imageMessage = imageMessage;
            return message;
        }

        public Message buildStickerMessage(StickerMessage stickerMessage) {
            Message message = new Message(this.to, MessageType.STICKER, this.context);
            message.stickerMessage = stickerMessage;
            return message;
        }

        public Message buildVideoMessage(VideoMessage videoMessage) {
            Message message = new Message(this.to, MessageType.VIDEO, this.context);
            message.videoMessage = videoMessage;
            return message;
        }

        public Message buildReactionMessage(ReactionMessage reactionMessage) {
            Message message = new Message(this.to, MessageType.REACTION, this.context);
            message.reactionMessage = reactionMessage;
            return message;
        }

        public Message buildLocationMessage(LocationMessage locationMessage) {
            Message message = new Message(this.to, MessageType.LOCATION, this.context);
            message.locationMessage = locationMessage;
            return message;
        }
    }
}

