/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.domain.templates;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.whatsapp.api.domain.templates.Component;
import com.whatsapp.api.domain.templates.type.Category;
import com.whatsapp.api.domain.templates.type.LanguageType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessageTemplate {
    private String name;
    private LanguageType languageType;
    private Category category;
    private List<Component<?>> components;

    public MessageTemplate addComponent(Component<?> component) {
        if (this.components == null) {
            this.components = new ArrayList();
        }
        this.components.add(component);
        return this;
    }

    public MessageTemplate addComponents(Component<?> ... components) {
        if (this.components == null) {
            this.components = new ArrayList();
        }
        if (components != null) {
            this.components.addAll(Arrays.stream(components).toList());
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MessageTemplate setName(String name) {
        this.name = name;
        return this;
    }

    public LanguageType getLanguage() {
        return this.languageType;
    }

    public MessageTemplate setLanguage(LanguageType languageType) {
        this.languageType = languageType;
        return this;
    }

    public Category getCategory() {
        return this.category;
    }

    public MessageTemplate setCategory(Category category) {
        this.category = category;
        return this;
    }

    public List<Component<?>> getComponents() {
        return this.components;
    }

    public MessageTemplate setComponents(List<Component<?>> components) {
        this.components = components;
        return this;
    }
}

