/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.impl;

import com.whatsapp.api.WhatsappApiServiceGenerator;
import com.whatsapp.api.domain.response.Response;
import com.whatsapp.api.domain.templates.MessageTemplate;
import com.whatsapp.api.domain.templates.response.MessageTemplateIDResponse;
import com.whatsapp.api.domain.templates.response.MessageTemplates;
import com.whatsapp.api.service.WhatsappBusinessManagementApiService;
import java.util.Map;

public class WhatsappBusinessManagementApi {
    private final WhatsappBusinessManagementApiService whatsappBusinessManagementApiService;

    public WhatsappBusinessManagementApi(String token) {
        this.whatsappBusinessManagementApiService = WhatsappApiServiceGenerator.createService(WhatsappBusinessManagementApiService.class, token);
    }

    public MessageTemplateIDResponse createMessageTemplate(String whatsappBusinessAccountId, MessageTemplate messageTemplate) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.createMessageTemplate(whatsappBusinessAccountId, messageTemplate));
    }

    public MessageTemplateIDResponse updateMessageTemplate(String whatsappBusinessAccountId, String messageTemplateId, MessageTemplate messageTemplate) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.updateMessageTemplate(whatsappBusinessAccountId, messageTemplateId, messageTemplate));
    }

    public Response deleteMessageTemplate(String whatsappBusinessAccountId, String name) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.deleteMessageTemplate(whatsappBusinessAccountId, name));
    }

    public MessageTemplates retrieveTemplates(String whatsappBusinessAccountId) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.retrieveTemplates(whatsappBusinessAccountId));
    }

    public MessageTemplates retrieveTemplates(String whatsappBusinessAccountId, int limit) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.retrieveTemplates(whatsappBusinessAccountId, Map.of("limit", limit)));
    }

    public MessageTemplates retrieveTemplates(String whatsappBusinessAccountId, String templateName) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.retrieveTemplates(whatsappBusinessAccountId, Map.of("name", templateName)));
    }

    public MessageTemplates retrieveTemplates(String whatsappBusinessAccountId, int limit, String after) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.retrieveTemplates(whatsappBusinessAccountId, Map.of("limit", limit, "after", after)));
    }
}

