/*
 * Decompiled with CFR 0.152.
 */
package com.github.iOS;

import com.github.device.Device;
import com.github.interfaces.Manager;
import com.github.utils.CommandPromptUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.json.JSONObject;

public class IOSManager
implements Manager {
    private CommandPromptUtil cmd = new CommandPromptUtil();
    private static final int IOS_UDID_LENGTH = 40;
    private static final int SIM_UDID_LENGTH = 36;
    JSONObject iOSDevices = new JSONObject();
    String profile = "system_profiler SPUSBDataType | sed -n -E -e '/(iPhone|iPad|iPod)/,/Serial/s/ *Serial Number: *(.+)/\\1/p'";

    @Override
    public Device getDevice(String udid) {
        Optional<Device> device = this.getDevices().stream().filter(d -> udid.equals(d.getUdid())).findFirst();
        return device.orElseThrow(() -> new RuntimeException("Provided DeviceUDID " + udid + " is not found on the machine"));
    }

    @Override
    public List<Device> getDevices() {
        ArrayList<Device> device = new ArrayList<Device>();
        this.getIOSUDID().forEach(udid -> {
            try {
                device.add(new Device(this.getDeviceInfo((String)udid)));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return device;
    }

    public JSONObject getDeviceInfo(String udid) throws InterruptedException, IOException {
        String model = this.cmd.runProcessCommandToGetDeviceID("ideviceinfo -u " + udid + " | grep ProductType").replace("\n", "");
        String name = this.cmd.runProcessCommandToGetDeviceID("idevicename --udid " + udid);
        String osVersion = this.cmd.runProcessCommandToGetDeviceID("ideviceinfo --udid " + udid + " | grep ProductVersion").replace("ProductVersion:", "").replace("\n", "").trim();
        this.iOSDevices.put("deviceModel", (Object)model);
        this.iOSDevices.put("udid", (Object)udid);
        this.iOSDevices.put("name", (Object)name);
        this.iOSDevices.put("brand", (Object)"Apple");
        this.iOSDevices.put("isDevice", (Object)"true");
        this.iOSDevices.put("screenSize", (Object)"Not Supported");
        this.iOSDevices.put("apiLevel", (Object)"");
        this.iOSDevices.put("osVersion", (Object)osVersion);
        this.iOSDevices.put("os", (Object)"iOS");
        this.iOSDevices.put("deviceManufacturer", (Object)"apple");
        return this.iOSDevices;
    }

    private List<String> getIOSUDID() {
        ArrayList<String> iosDeviceUDIDS = new ArrayList<String>();
        try {
            String[] iosDevices;
            Optional<String> getIOSDeviceID = Optional.of(this.cmd.runProcessCommandToGetDeviceID(this.profile));
            for (String iosDevice : iosDevices = getIOSDeviceID.get().split("\n")) {
                if (iosDevice.length() == 24) {
                    iosDeviceUDIDS.add(this.addChar(iosDevice, '-', 8));
                    continue;
                }
                iosDeviceUDIDS.add(iosDevice);
            }
            return iosDeviceUDIDS;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to fetch iOS device connected");
        }
    }

    private String addChar(String str, char ch, int position) {
        return str.substring(0, position) + ch + str.substring(position);
    }
}

