/*
 * Decompiled with CFR 0.152.
 */
package com.github.device;

import org.json.JSONObject;

public class IOSRuntime {
    private final String buildversion;
    private final boolean isAvailable;
    private final String name;
    private final String identifier;
    private final String version;
    private final String os;

    public IOSRuntime(JSONObject runtimeJSON) {
        this.buildversion = runtimeJSON.getString("buildversion");
        this.name = runtimeJSON.getString("name");
        this.version = runtimeJSON.getString("version");
        this.identifier = runtimeJSON.getString("identifier");
        this.isAvailable = runtimeJSON.getString("availability").equals("(available)");
        this.os = this.name.split(" ")[0];
    }

    public String getBuildversion() {
        return this.buildversion;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOs() {
        return this.os;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IOSRuntime)) {
            return false;
        }
        IOSRuntime other = (IOSRuntime)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$buildversion = this.getBuildversion();
        String other$buildversion = other.getBuildversion();
        if (this$buildversion == null ? other$buildversion != null : !this$buildversion.equals(other$buildversion)) {
            return false;
        }
        if (this.isAvailable() != other.isAvailable()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$os = this.getOs();
        String other$os = other.getOs();
        return !(this$os == null ? other$os != null : !this$os.equals(other$os));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IOSRuntime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $buildversion = this.getBuildversion();
        result = result * 59 + ($buildversion == null ? 43 : $buildversion.hashCode());
        result = result * 59 + (this.isAvailable() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : $os.hashCode());
        return result;
    }

    public String toString() {
        return "IOSRuntime(buildversion=" + this.getBuildversion() + ", isAvailable=" + this.isAvailable() + ", name=" + this.getName() + ", identifier=" + this.getIdentifier() + ", version=" + this.getVersion() + ", os=" + this.getOs() + ")";
    }
}

