/*
 * Decompiled with CFR 0.152.
 */
package com.github.android;

import com.github.device.Device;
import com.github.interfaces.Manager;
import com.github.utils.CommandPromptUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.JSONObject;

public class AndroidManager
implements Manager {
    private CommandPromptUtil cmd = new CommandPromptUtil();
    private JSONObject adbDevices = new JSONObject();
    private static Map<String, Process> processUDIDs = new HashMap<String, Process>();
    Process process;

    public void startADB() throws Exception {
        String output = this.cmd.runCommandThruProcess("adb start-server");
        String[] lines = output.split("\n");
        if (lines[0].contains("internal or external command")) {
            System.out.println("Please set ANDROID_HOME in your system variables");
        }
    }

    public JSONObject getDeviceInfo(String deviceID) throws InterruptedException, IOException {
        String model = this.cmd.runCommandThruProcess("adb -s " + deviceID + " shell getprop ro.product.model");
        String brand = this.cmd.runCommandThruProcess("adb -s " + deviceID + " shell getprop ro.product.brand").replaceAll("\\s+", "");
        String osVersion = this.cmd.runCommandThruProcess("adb -s " + deviceID + " shell getprop ro.build.version.release").replaceAll("\\s+", "");
        String deviceName = brand + " " + model;
        String apiLevel = this.cmd.runCommandThruProcess("adb -s " + deviceID + " shell getprop ro.build.version.sdk").replaceAll("\n", "");
        String deviceOrEmulator = this.cmd.runCommandThruProcess("adb -s " + deviceID + " shell getprop ro.product.manufacturer");
        String getScreenResolution = this.cmd.runCommandThruProcess("adb -s " + deviceID + " shell wm size").split(":")[1].replace("\n", "");
        boolean isDevice = true;
        if (deviceOrEmulator.contains("Genymotion") || deviceOrEmulator.contains("unknown")) {
            isDevice = false;
        }
        String deviceModel = this.cmd.runCommandThruProcess("adb -s " + deviceID + " shell getprop ro.product.model");
        this.adbDevices.put("name", (Object)deviceName);
        this.adbDevices.put("osVersion", (Object)osVersion);
        this.adbDevices.put("apiLevel", (Object)apiLevel);
        this.adbDevices.put("brand", (Object)brand);
        this.adbDevices.put("udid", (Object)deviceID);
        this.adbDevices.put("isDevice", isDevice);
        this.adbDevices.put("deviceModel", (Object)deviceModel);
        this.adbDevices.put("screenSize", (Object)getScreenResolution);
        this.adbDevices.put("deviceManufacturer", (Object)deviceOrEmulator);
        this.adbDevices.put("os", (Object)"android");
        return this.adbDevices;
    }

    @Override
    public List<Device> getDevices() throws Exception {
        ArrayList<Device> devices = new ArrayList<Device>();
        this.startADB();
        String output = this.cmd.runCommandThruProcess("adb devices");
        String[] lines = output.split("\n");
        if (lines.length > 1) {
            for (int i = 1; i < lines.length; ++i) {
                lines[i] = lines[i].replaceAll("\\s+", "");
                if (!lines[i].contains("device")) continue;
                lines[i] = lines[i].replaceAll("device", "");
                String deviceID = lines[i];
                JSONObject deviceInfo = this.getDeviceInfo(deviceID);
                devices.add(new Device(deviceInfo));
            }
        }
        return devices;
    }

    @Override
    public Device getDevice(String udid) throws Exception {
        Optional<Device> device = this.getDevices().stream().filter(d -> udid.equals(d.getUdid())).findFirst();
        return device.orElseThrow(() -> new RuntimeException("Provided DeviceUDID " + udid + " is not found on the machine"));
    }

    public String startADBLog(String udid, String filePath) throws Exception {
        this.cmd.execForProcessToExecute("adb -s " + udid + " logcat -b all -c");
        this.process = this.cmd.execForProcessToExecute("adb -s " + udid + " logcat > " + filePath);
        processUDIDs.put(udid, this.process);
        return "Collecting ADB logs for device " + udid + " in file " + filePath;
    }

    public String startADBLogWithPackage(String udid, String packageName, String filePath) throws Exception {
        this.cmd.execForProcessToExecute("adb -s " + udid + " logcat -b all -c");
        this.process = this.cmd.execForProcessToExecute("adb -s " + udid + " logcat | grep -F \"`adb shell ps | grep " + packageName + " | cut -c10-15`\" > " + filePath);
        processUDIDs.put(udid, this.process);
        return "Collecting ADB logs for device " + udid + " for package " + packageName + " in file " + filePath;
    }

    public String stopADBLog(String udid) throws Exception {
        Process p = processUDIDs.get(udid);
        if (this.getPid(p) > 0) {
            this.cmd.runCommandThruProcess("kill -9 " + this.getPid(p));
            return "Stopped collecting ADB logs " + udid;
        }
        return "No process found to kill";
    }

    public int getPid(Process process) {
        try {
            Class<?> cProcessImpl = process.getClass();
            Field fPid = cProcessImpl.getDeclaredField("pid");
            if (!fPid.isAccessible()) {
                fPid.setAccessible(true);
            }
            return fPid.getInt(process);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

