/*
 * Decompiled with CFR 0.152.
 */
package com.anychart;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.anychart.APIlib;
import com.anychart.JsObject;
import com.anychart.R;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.Chart;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class AnyChartView
extends FrameLayout {
    private JsListener jsListener;
    private OnRenderedListener onRenderedListener;
    private WebView webView;
    private Chart chart;
    private boolean isRestored;
    private boolean isRendered;
    private boolean isDebug;
    private StringBuilder scripts = new StringBuilder();
    private StringBuilder fonts = new StringBuilder();
    protected StringBuilder js = new StringBuilder();
    private String licenceKey = "";
    private View progressBar;
    private String backgroundColor;

    public AnyChartView(Context context) {
        super(context);
        this.init();
    }

    public AnyChartView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AnyChartView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putString("js", this.js.toString());
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.js.append(bundle.getString("js"));
            state = bundle.getParcelable("superState");
        }
        this.isRestored = true;
        super.onRestoreInstanceState(state);
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.view_anychart, (ViewGroup)this, true);
        APIlib.getInstance().setActiveAnyChartView(this);
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
        this.webView = (WebView)view.findViewById(R.id.web_view);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setLoadWithOverviewMode(true);
        this.webView.setLongClickable(true);
        this.webView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return true;
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                if (AnyChartView.this.isDebug) {
                    Log.e((String)"AnyChart", (String)consoleMessage.message());
                }
                AnyChartView.this.webView.setEnabled(false);
                return true;
            }
        });
        this.isRendered = false;
        JsObject.variableIndex = 0;
        this.setJsListener(new JsListener(){

            @Override
            public void onJsLineAdd(final String jsLine) {
                AnyChartView.this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (AnyChartView.this.isRestored) {
                            return;
                        }
                        if (AnyChartView.this.isRendered) {
                            if (Build.VERSION.SDK_INT >= 19) {
                                AnyChartView.this.webView.evaluateJavascript(jsLine, null);
                            } else {
                                AnyChartView.this.webView.loadUrl("javascript:" + jsLine);
                            }
                        } else {
                            AnyChartView.this.js.append(jsLine);
                        }
                    }
                });
            }
        });
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return true;
            }

            public void onPageFinished(WebView view, String url) {
                String resultJs = AnyChartView.this.isRestored ? AnyChartView.this.js.toString() : AnyChartView.this.js.append(AnyChartView.this.getContext().getPackageName() != "com.anychart.anychart" ? AnyChartView.this.androidCheck(AnyChartView.this.licenceKey) : "").append(AnyChartView.this.chart.getJsBase()).append(".container(\"container\");").toString();
                AnyChartView.this.webView.evaluateJavascript("anychart.theme({\n     chart: {\n       credits: {\n         logoSrc: 'https://static.anychart.com/logo-for-android.png',\n         text: 'AnyChart Trial Version'\n       }\n     }\n   });anychart.onDocumentReady(function () {\n" + resultJs + "});", (ValueCallback)new ValueCallback<String>(){

                    public void onReceiveValue(String value) {
                        if (AnyChartView.this.onRenderedListener != null) {
                            AnyChartView.this.onRenderedListener.onRendered();
                        }
                        if (AnyChartView.this.progressBar != null) {
                            AnyChartView.this.progressBar.setVisibility(8);
                        }
                    }
                });
                AnyChartView.this.isRestored = false;
                AnyChartView.this.isRendered = true;
            }
        });
        this.webView.addJavascriptInterface((Object)ListenersInterface.getInstance(), "android");
    }

    private void loadHtml() {
        String htmlData = "<html>\n<head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n    <style type=\"text/css\">\n        html, body, #container {\n            width: 100%;\n            height: 100%;\n            margin: 0;\n            padding: 0;\n" + (this.backgroundColor != null ? "background-color: " + this.backgroundColor + ";" : "") + "        }\n" + this.fonts.toString() + "    </style>\n</head>\n<body>\n<script src=\"file:///android_asset/anychart-android.min.js\"></script>" + this.scripts.toString() + "<link rel=\"stylesheet\" href=\"file:///android_asset/anychart-ui.min.css\"/>\n<div id=\"container\"></div>\n</body>\n</html>";
        this.webView.loadDataWithBaseURL("https://www.google.com", htmlData, "text/html", "UTF-8", null);
    }

    public void addScript(String url) {
        this.scripts.append("<script src=\"").append(url).append("\"></script>\n");
    }

    public void addCss(String url) {
        this.scripts.append("<link rel=\"stylesheet\" href=\"").append(url).append("\"/>\n");
    }

    public void addFont(String fontFamily, String url) {
        this.fonts.append("@font-face {\n").append("font-family: ").append(fontFamily).append(";\n").append("src: url(").append(url).append(");\n").append("}\n");
    }

    public void setLicenceKey(String key) {
        this.licenceKey = key;
    }

    public void setZoomEnabled(Boolean value) {
        this.webView.getSettings().setBuiltInZoomControls(value.booleanValue());
        this.webView.getSettings().setDisplayZoomControls(value == false);
    }

    public void clear() {
        this.webView.loadUrl("about:blank");
        this.isRendered = false;
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
    }

    public void setChart(Chart chart) {
        this.isRestored = false;
        this.chart = chart;
        this.loadHtml();
    }

    public void setProgressBar(View progressBar) {
        this.progressBar = progressBar;
        progressBar.setVisibility(0);
    }

    public void setBackgroundColor(String color) {
        this.backgroundColor = color;
        this.webView.setBackgroundColor(Color.parseColor((String)color));
    }

    public void setJsListener(JsListener listener) {
        this.jsListener = listener;
    }

    public JsListener getJsListener() {
        return this.jsListener;
    }

    public OnRenderedListener getOnRenderedListener() {
        return this.onRenderedListener;
    }

    public void setOnRenderedListener(OnRenderedListener onRenderedListener) {
        this.onRenderedListener = onRenderedListener;
    }

    public void setDebug(boolean value) {
        this.isDebug = value;
    }

    private String md5(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(s.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }

    private String androidCheck(String l) {
        if (l == null || l.isEmpty() || this.md5(l) == "0df80e76aeca7dc40e01e876dca3542b") {
            return "var btoa = window.btoa(JSON.stringify({\n    chartType: '" + this.chart.getJsBase().replaceAll("\\d", "") + "',\n    apkName: \"" + this.getContext().getPackageName() + "\"\n}));" + this.chart.getJsBase() + ".credits({\n         logoSrc: 'https://static.anychart.com/logo-for-android.png?data=' + btoa,\n         text: 'AnyChart Trial Version'\n       });\n";
        }
        return "";
    }

    public static interface OnRenderedListener {
        public void onRendered();
    }

    public static interface JsListener {
        public void onJsLineAdd(String var1);
    }
}

