/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.data;

import com.anychart.APIlib;
import com.anychart.chart.common.dataentry.DataEntry;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.Base;
import com.anychart.data.TableComputer;
import com.anychart.data.TableMapping;
import java.util.List;
import java.util.Locale;

public class Table
extends Base {
    protected Table() {
    }

    public static Table instantiate() {
        return new Table("new anychart.data.table()");
    }

    public static Table instantiate(String keyIndex) {
        return new Table(String.format(Locale.US, "new anychart.data.table(%s)", Table.wrapQuotes(keyIndex)));
    }

    public Table(String jsChart) {
        this.jsBase = "table" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public Table addData(List<DataEntry> data) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".addData(%s);", Table.arrayToString(data)));
        return this;
    }

    public TableComputer createComputer(TableMapping mappingSettingsOrMapping) {
        return new TableComputer(String.format(Locale.US, this.jsBase + ".createComputer(%s)", mappingSettingsOrMapping != null ? mappingSettingsOrMapping.getJsBase() : null));
    }

    public TableMapping mapAs(String mapping) {
        return new TableMapping(String.format(Locale.US, this.jsBase + ".mapAs(%s)", Table.wrapQuotes(mapping)));
    }

    public Table remove(Number startKey, Number endKey) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".remove(%s, %s);", startKey, endKey));
        return this;
    }

    public Table remove(Number startKey, String endKey) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".remove(%s, %s);", startKey, Table.wrapQuotes(endKey)));
        return this;
    }

    public Table remove(String startKey, Number endKey) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".remove(%s, %s);", Table.wrapQuotes(startKey), endKey));
        return this;
    }

    public Table remove(String startKey, String endKey) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".remove(%s, %s);", Table.wrapQuotes(startKey), Table.wrapQuotes(endKey)));
        return this;
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Table.wrapQuotes(type)));
    }

    public Table removeFirst(Number count) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeFirst(%s);", count));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener, String type, String ePath) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(String.format(Locale.US, ".listen('%1$s', function(e) {", type));
        if (listener.getFields() != null) {
            ePath = ePath != null ? ePath + "." : "";
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.%2$s%1$s + ',' +", field, ePath));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Table.wrapQuotes(key)));
    }
}

