/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.data;

import com.anychart.APIlib;
import com.anychart.chart.common.dataentry.DataEntry;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.Base;
import com.anychart.data.Mapping;
import com.anychart.data.View;
import com.anychart.enums.TreeFillingMethod;
import java.util.List;
import java.util.Locale;

public class Set
extends Base {
    protected Set() {
    }

    public static Set instantiate() {
        return new Set("new anychart.data.set()");
    }

    public Set(String jsChart) {
        this.jsBase = "set" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public Set append(String var_args) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".append(%s);", Set.wrapQuotes(var_args)));
        return this;
    }

    public void data(List<DataEntry> data) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".data(%s);", Set.arrayToString(data)));
    }

    public void getRowsCount() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getRowsCount();");
    }

    public Set insert(String row, Number index) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".insert(%s, %s);", Set.wrapQuotes(row), index));
        return this;
    }

    public Mapping mapAs(String mapping) {
        return new Mapping(String.format(Locale.US, this.jsBase + ".mapAs(%s)", Set.wrapQuotes(mapping)));
    }

    public Set remove(Number index) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".remove(%s);", index));
        return this;
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Set.wrapQuotes(type)));
    }

    public void row(Number rowIndex) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".row(%s);", rowIndex));
    }

    public void row(Number rowIndex, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".row(%s, %s);", rowIndex, Set.wrapQuotes(value)));
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener, String type, String ePath) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(String.format(Locale.US, ".listen('%1$s', function(e) {", type));
        if (listener.getFields() != null) {
            ePath = ePath != null ? ePath + "." : "";
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.%2$s%1$s + ',' +", field, ePath));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Set.wrapQuotes(key)));
    }

    public Set data(View data) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".data(%s);", data != null ? data.getJsBase() : null));
        return this;
    }

    public Set data(List<DataEntry> data, TreeFillingMethod fillMethod) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".data(%s, %s);", Set.arrayToString(data), fillMethod != null ? fillMethod.getJsBase() : null));
        return this;
    }

    public Set data(List<DataEntry> data, String fillMethod) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".data(%s, %s);", Set.arrayToString(data), Set.wrapQuotes(fillMethod)));
        return this;
    }
}

