/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.graphics.vector;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.graphics.math.Coordinate;
import com.anychart.graphics.vector.Anchor;
import com.anychart.graphics.vector.ColoredFill;
import com.anychart.graphics.vector.Cursor;
import com.anychart.graphics.vector.Fill;
import com.anychart.graphics.vector.GradientKey;
import com.anychart.graphics.vector.Layer;
import com.anychart.graphics.vector.Rect;
import com.anychart.graphics.vector.Shape;
import com.anychart.graphics.vector.Stage;
import com.anychart.graphics.vector.Stroke;
import com.anychart.graphics.vector.StrokeLineCap;
import com.anychart.graphics.vector.StrokeLineJoin;
import java.util.Locale;

public class Path
extends Shape {
    protected Path() {
    }

    public static Path instantiate() {
        return new Path("new anychart.graphics.vector.path()");
    }

    public Path(String jsChart) {
        this.jsBase = "path" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    @Override
    public Path appendTransformationMatrix(Number m00, Number m10, Number m01, Number m11, Number m02, Number m12) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".appendTransformationMatrix(%s, %s, %s, %s, %s, %s);", m00, m10, m01, m11, m02, m12));
        return this;
    }

    public Path arcTo(Number rx, Number ry, Number fromAngle, Number extent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".arcTo(%s, %s, %s, %s);", rx, ry, fromAngle, extent));
        return this;
    }

    public Path arcToAsCurves(Number rx, Number ry, Number fromAngle, Number extent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".arcToAsCurves(%s, %s, %s, %s);", rx, ry, fromAngle, extent));
        return this;
    }

    public Path arcToByEndPoint(Number x, Number y, Number rx, Number ry, Boolean largeArc, Boolean clockwiseArc) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".arcToByEndPoint(%s, %s, %s, %s, %s, %s);", x, y, rx, ry, largeArc, clockwiseArc));
        return this;
    }

    @Override
    public void attr(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".attr(%s);", Path.wrapQuotes(key)));
    }

    @Override
    public Path attr(String key, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".attr(%s, %s);", Path.wrapQuotes(key), Path.wrapQuotes(value)));
        return this;
    }

    public Path circularArc(Number cx, Number cy, Number rx, Number ry, Number fromAngle, Number sweep, Boolean lineTo) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".circularArc(%s, %s, %s, %s, %s, %s, %s);", cx, cy, rx, ry, fromAngle, sweep, lineTo));
        return this;
    }

    public Path clear() {
        APIlib.getInstance().addJSLine(this.jsBase + ".clear();");
        return this;
    }

    @Override
    public com.anychart.graphics.math.Rect clip() {
        return new com.anychart.graphics.math.Rect(this.jsBase + ".clip()");
    }

    @Override
    public Path clip(com.anychart.graphics.math.Rect value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".clip(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Path clip(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".clip(%s);", Path.wrapQuotes(value)));
        return this;
    }

    public Path close() {
        APIlib.getInstance().addJSLine(this.jsBase + ".close();");
        return this;
    }

    @Override
    public void cursor() {
        APIlib.getInstance().addJSLine(this.jsBase + ".cursor();");
    }

    @Override
    public Path cursor(Cursor value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".cursor(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Path curveTo(Number control1X, Number control1Y, Number control2X, Number control2Y, Number endX, Number endY, Number var_args) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".curveTo(%s, %s, %s, %s, %s, %s, %s);", control1X, control1Y, control2X, control2Y, endX, endY, var_args));
        return this;
    }

    @Override
    public void desc() {
        APIlib.getInstance().addJSLine(this.jsBase + ".desc();");
    }

    @Override
    public Path desc(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".desc(%s);", Path.wrapQuotes(value)));
        return this;
    }

    @Override
    public void disablePointerEvents() {
        APIlib.getInstance().addJSLine(this.jsBase + ".disablePointerEvents();");
    }

    @Override
    public Path disablePointerEvents(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".disablePointerEvents(%s);", value));
        return this;
    }

    @Override
    public void disableStrokeScaling() {
        APIlib.getInstance().addJSLine(this.jsBase + ".disableStrokeScaling();");
    }

    @Override
    public Path disableStrokeScaling(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".disableStrokeScaling(%s);", value));
        return this;
    }

    @Override
    public void dispose() {
        APIlib.getInstance().addJSLine(this.jsBase + ".dispose();");
    }

    @Override
    public void domElement() {
        APIlib.getInstance().addJSLine(this.jsBase + ".domElement();");
    }

    @Override
    public void drag() {
        APIlib.getInstance().addJSLine(this.jsBase + ".drag();");
    }

    @Override
    public Path drag(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".drag(%s);", value));
        return this;
    }

    @Override
    public Path drag(com.anychart.graphics.math.Rect value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".drag(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public void fill() {
        APIlib.getInstance().addJSLine(this.jsBase + ".fill();");
    }

    @Override
    public Path fill(Fill color) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s);", color != null ? color.getJsBase() : null));
        return this;
    }

    @Override
    public Path fill(String color, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s);", Path.wrapQuotes(color), opacity));
        return this;
    }

    @Override
    public Path fill(GradientKey keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode, opacity));
        return this;
    }

    @Override
    public Path fill(GradientKey keys, Number angle, Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    @Override
    public Path fill(GradientKey keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, Path.wrapQuotes(mode), opacity));
        return this;
    }

    @Override
    public Path fill(String[] keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", Path.arrayToStringWrapQuotes(keys), angle, mode, opacity));
        return this;
    }

    @Override
    public Path fill(String[] keys, Number angle, Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", Path.arrayToStringWrapQuotes(keys), angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    @Override
    public Path fill(String[] keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", Path.arrayToStringWrapQuotes(keys), angle, Path.wrapQuotes(mode), opacity));
        return this;
    }

    @Override
    public Path fill(GradientKey keys, Number cx, Number cy, com.anychart.graphics.math.Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    @Override
    public Path fill(String[] keys, Number cx, Number cy, com.anychart.graphics.math.Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s, %s, %s, %s);", Path.arrayToStringWrapQuotes(keys), cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    @Override
    public com.anychart.graphics.math.Rect getAbsoluteBounds() {
        return new com.anychart.graphics.math.Rect(this.jsBase + ".getAbsoluteBounds()");
    }

    @Override
    public void getAbsoluteHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getAbsoluteHeight();");
    }

    @Override
    public void getAbsoluteWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getAbsoluteWidth();");
    }

    @Override
    public void getAbsoluteX() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getAbsoluteX();");
    }

    @Override
    public void getAbsoluteY() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getAbsoluteY();");
    }

    @Override
    public com.anychart.graphics.math.Rect getBounds() {
        return new com.anychart.graphics.math.Rect(this.jsBase + ".getBounds()");
    }

    public Coordinate getCurrentPoint() {
        return new Coordinate(this.jsBase + ".getCurrentPoint()");
    }

    @Override
    public void getHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getHeight();");
    }

    public void getLength() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getLength();");
    }

    @Override
    public void getRotationAngle() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getRotationAngle();");
    }

    @Override
    public Stage getStage() {
        return new Stage(this.jsBase + ".getStage()");
    }

    @Override
    public void getTransformationMatrix() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getTransformationMatrix();");
    }

    @Override
    public void getWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getWidth();");
    }

    @Override
    public void getX() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getX();");
    }

    @Override
    public void getY() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getY();");
    }

    @Override
    public void hasParent() {
        APIlib.getInstance().addJSLine(this.jsBase + ".hasParent();");
    }

    @Override
    public void id() {
        APIlib.getInstance().addJSLine(this.jsBase + ".id();");
    }

    @Override
    public Path id(String id2) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".id(%s);", Path.wrapQuotes(id2)));
        return this;
    }

    public Path lineTo(Number x, Number y, Number var_args) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".lineTo(%s, %s, %s);", x, y, var_args));
        return this;
    }

    public Path moveTo(Number x, Number y) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".moveTo(%s, %s);", x, y));
        return this;
    }

    @Override
    public Layer parent() {
        return new Layer(this.jsBase + ".parent()");
    }

    @Override
    public Path parent(Layer parent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".parent(%s);", parent != null ? parent.getJsBase() : null));
        return this;
    }

    @Override
    public Path parent(Stage parent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".parent(%s);", parent != null ? parent.getJsBase() : null));
        return this;
    }

    public Path quadraticCurveTo(Number controlX, Number controlY, Number endX, Number endY, Number var_args) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".quadraticCurveTo(%s, %s, %s, %s, %s);", controlX, controlY, endX, endY, var_args));
        return this;
    }

    @Override
    public Path remove() {
        APIlib.getInstance().addJSLine(this.jsBase + ".remove();");
        return this;
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Path.wrapQuotes(type)));
    }

    @Override
    public Path rotate(Number degrees, Number cx, Number cy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".rotate(%s, %s, %s);", degrees, cx, cy));
        return this;
    }

    @Override
    public Path rotateByAnchor(Number degrees, Anchor anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".rotateByAnchor(%s, %s);", degrees, anchor != null ? anchor.getJsBase() : null));
        return this;
    }

    @Override
    public Path rotateByAnchor(Number degrees, String anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".rotateByAnchor(%s, %s);", degrees, Path.wrapQuotes(anchor)));
        return this;
    }

    @Override
    public Path scale(Number sx, Number sy, Number cx, Number cy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scale(%s, %s, %s, %s);", sx, sy, cx, cy));
        return this;
    }

    @Override
    public Path scaleByAnchor(Number sx, Number sy, Anchor anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scaleByAnchor(%s, %s, %s);", sx, sy, anchor != null ? anchor.getJsBase() : null));
        return this;
    }

    @Override
    public Path scaleByAnchor(Number sx, Number sy, String anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scaleByAnchor(%s, %s, %s);", sx, sy, Path.wrapQuotes(anchor)));
        return this;
    }

    @Override
    public Path setPosition(Number x, Number y) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".setPosition(%s, %s);", x, y));
        return this;
    }

    @Override
    public Path setRotation(Number degrees, Number cx, Number cy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".setRotation(%s, %s, %s);", degrees, cx, cy));
        return this;
    }

    @Override
    public Path setRotationByAnchor(Number degrees, Anchor anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".setRotationByAnchor(%s, %s);", degrees, anchor != null ? anchor.getJsBase() : null));
        return this;
    }

    @Override
    public Path setRotationByAnchor(Number degrees, String anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".setRotationByAnchor(%s, %s);", degrees, Path.wrapQuotes(anchor)));
        return this;
    }

    @Override
    public Path setTransformationMatrix(Number m00, Number m10, Number m01, Number m11, Number m02, Number m12) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".setTransformationMatrix(%s, %s, %s, %s, %s, %s);", m00, m10, m01, m11, m02, m12));
        return this;
    }

    @Override
    public void stroke() {
        APIlib.getInstance().addJSLine(this.jsBase + ".stroke();");
    }

    @Override
    public Path stroke(Stroke value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Path stroke(ColoredFill value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Path stroke(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s);", Path.wrapQuotes(value)));
        return this;
    }

    @Override
    public Path stroke(Stroke value, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Path.wrapQuotes(dashpattern), Path.wrapQuotes(lineJoin), Path.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Path stroke(Stroke value, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Path.wrapQuotes(dashpattern), Path.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Path stroke(Stroke value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Path.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Path.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Path stroke(Stroke value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Path.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Path stroke(ColoredFill value, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Path.wrapQuotes(dashpattern), Path.wrapQuotes(lineJoin), Path.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Path stroke(ColoredFill value, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Path.wrapQuotes(dashpattern), Path.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Path stroke(ColoredFill value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Path.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Path.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Path stroke(ColoredFill value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Path.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Path stroke(String value, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", Path.wrapQuotes(value), thickness, Path.wrapQuotes(dashpattern), Path.wrapQuotes(lineJoin), Path.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Path stroke(String value, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", Path.wrapQuotes(value), thickness, Path.wrapQuotes(dashpattern), Path.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Path stroke(String value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", Path.wrapQuotes(value), thickness, Path.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Path.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Path stroke(String value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", Path.wrapQuotes(value), thickness, Path.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public void strokeThickness() {
        APIlib.getInstance().addJSLine(this.jsBase + ".strokeThickness();");
    }

    @Override
    public Path strokeThickness(Number thickness) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".strokeThickness(%s);", thickness));
        return this;
    }

    @Override
    public void title() {
        APIlib.getInstance().addJSLine(this.jsBase + ".title();");
    }

    @Override
    public Path title(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".title(%s);", Path.wrapQuotes(value)));
        return this;
    }

    @Override
    public Path translate(Number tx, Number ty) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".translate(%s, %s);", tx, ty));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void visible() {
        APIlib.getInstance().addJSLine(this.jsBase + ".visible();");
    }

    @Override
    public Path visible(Boolean isVisible) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".visible(%s);", isVisible));
        return this;
    }

    @Override
    public void zIndex() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zIndex();");
    }

    @Override
    public Path zIndex(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zIndex(%s);", value));
        return this;
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Path.wrapQuotes(key)));
    }

    @Override
    public Path fill(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s);", Path.wrapQuotes(value)));
        return this;
    }
}

