/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.core;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.NoDataSettings;
import com.anychart.core.VisualBaseWithBounds;
import com.anychart.core.ui.Background;
import com.anychart.core.ui.ChartCredits;
import com.anychart.core.ui.Label;
import com.anychart.core.ui.Title;
import com.anychart.core.ui.Tooltip;
import com.anychart.core.utils.Animation;
import com.anychart.core.utils.Bounds;
import com.anychart.core.utils.ChartA11y;
import com.anychart.core.utils.Exports;
import com.anychart.core.utils.Margin;
import com.anychart.core.utils.Padding;
import com.anychart.enums.ChartDataExportMode;
import com.anychart.enums.Statistics;
import com.anychart.graphics.math.Rect;
import com.anychart.graphics.vector.ColoredFill;
import com.anychart.graphics.vector.Fill;
import com.anychart.graphics.vector.GradientKey;
import com.anychart.graphics.vector.Layer;
import com.anychart.graphics.vector.PaperSize;
import com.anychart.graphics.vector.Stage;
import com.anychart.graphics.vector.Stroke;
import com.anychart.graphics.vector.StrokeLineCap;
import com.anychart.graphics.vector.StrokeLineJoin;
import com.anychart.ui.ContextMenu;
import com.anychart.utils.RectObj;
import java.util.Arrays;
import java.util.Locale;

public class Chart
extends VisualBaseWithBounds {
    protected Chart() {
    }

    public static Chart instantiate() {
        return new Chart("new anychart.core.chart()");
    }

    public Chart(String jsChart) {
        this.jsBase = "chart" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public ChartA11y a11y() {
        return new ChartA11y(this.jsBase + ".a11y()");
    }

    public Chart a11y(Boolean settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".a11y(%s);", settings));
        return this;
    }

    public Chart a11y(String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".a11y(%s);", Chart.wrapQuotes(settings)));
        return this;
    }

    public Animation animation() {
        return new Animation(this.jsBase + ".animation()");
    }

    public Chart animation(Boolean settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".animation(%s);", settings));
        return this;
    }

    public Chart animation(String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".animation(%s);", Chart.wrapQuotes(settings)));
        return this;
    }

    public Chart animation(Boolean enabled, Number duration) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".animation(%s, %s);", enabled, duration));
        return this;
    }

    public void autoRedraw() {
        APIlib.getInstance().addJSLine(this.jsBase + ".autoRedraw();");
    }

    public Chart autoRedraw(Boolean enabled) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".autoRedraw(%s);", enabled));
        return this;
    }

    public Background background() {
        return new Background(this.jsBase + ".background()");
    }

    public Chart background(String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".background(%s);", Chart.wrapQuotes(settings)));
        return this;
    }

    @Override
    public void bottom() {
        APIlib.getInstance().addJSLine(this.jsBase + ".bottom();");
    }

    @Override
    public Chart bottom(Number bottom) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bottom(%s);", bottom));
        return this;
    }

    @Override
    public Chart bottom(String bottom) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bottom(%s);", Chart.wrapQuotes(bottom)));
        return this;
    }

    @Override
    public Bounds bounds() {
        return new Bounds(this.jsBase + ".bounds()");
    }

    @Override
    public Chart bounds(RectObj bounds) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", bounds != null ? bounds.getJsBase() : null));
        return this;
    }

    @Override
    public Chart bounds(com.anychart.math.Rect bounds) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", bounds != null ? bounds.getJsBase() : null));
        return this;
    }

    @Override
    public Chart bounds(Bounds bounds) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", bounds != null ? bounds.getJsBase() : null));
        return this;
    }

    @Override
    public Chart bounds(Number x, Number y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, width, height));
        return this;
    }

    @Override
    public Chart bounds(Number x, Number y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, width, Chart.wrapQuotes(height)));
        return this;
    }

    @Override
    public Chart bounds(Number x, Number y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, Chart.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Chart bounds(Number x, Number y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, Chart.wrapQuotes(width), Chart.wrapQuotes(height)));
        return this;
    }

    @Override
    public Chart bounds(Number x, String y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Chart.wrapQuotes(y), width, height));
        return this;
    }

    @Override
    public Chart bounds(Number x, String y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Chart.wrapQuotes(y), width, Chart.wrapQuotes(height)));
        return this;
    }

    @Override
    public Chart bounds(Number x, String y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Chart.wrapQuotes(y), Chart.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Chart bounds(Number x, String y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Chart.wrapQuotes(y), Chart.wrapQuotes(width), Chart.wrapQuotes(height)));
        return this;
    }

    @Override
    public Chart bounds(String x, Number y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Chart.wrapQuotes(x), y, width, height));
        return this;
    }

    @Override
    public Chart bounds(String x, Number y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Chart.wrapQuotes(x), y, width, Chart.wrapQuotes(height)));
        return this;
    }

    @Override
    public Chart bounds(String x, Number y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Chart.wrapQuotes(x), y, Chart.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Chart bounds(String x, Number y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Chart.wrapQuotes(x), y, Chart.wrapQuotes(width), Chart.wrapQuotes(height)));
        return this;
    }

    @Override
    public Chart bounds(String x, String y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Chart.wrapQuotes(x), Chart.wrapQuotes(y), width, height));
        return this;
    }

    @Override
    public Chart bounds(String x, String y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Chart.wrapQuotes(x), Chart.wrapQuotes(y), width, Chart.wrapQuotes(height)));
        return this;
    }

    @Override
    public Chart bounds(String x, String y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Chart.wrapQuotes(x), Chart.wrapQuotes(y), Chart.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Chart bounds(String x, String y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Chart.wrapQuotes(x), Chart.wrapQuotes(y), Chart.wrapQuotes(width), Chart.wrapQuotes(height)));
        return this;
    }

    public Chart cancelMarquee() {
        APIlib.getInstance().addJSLine(this.jsBase + ".cancelMarquee();");
        return this;
    }

    @Override
    public Layer container() {
        return new Layer(this.jsBase + ".container()");
    }

    @Override
    public Chart container(Layer element) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".container(%s);", element != null ? element.getJsBase() : null));
        return this;
    }

    @Override
    public Chart container(Stage element) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".container(%s);", element != null ? element.getJsBase() : null));
        return this;
    }

    @Override
    public Chart container(String element) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".container(%s);", Chart.wrapQuotes(element)));
        return this;
    }

    public ContextMenu contextMenu() {
        return new ContextMenu(this.jsBase + ".contextMenu()");
    }

    public Chart contextMenu(String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".contextMenu(%s);", Chart.wrapQuotes(settings)));
        return this;
    }

    public Chart contextMenu(Boolean settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".contextMenu(%s);", settings));
        return this;
    }

    public ChartCredits credits() {
        return new ChartCredits(this.jsBase + ".credits()");
    }

    public Chart credits(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".credits(%s);", Chart.wrapQuotes(value)));
        return this;
    }

    public Chart credits(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".credits(%s);", value));
        return this;
    }

    public void dispose() {
        APIlib.getInstance().addJSLine(this.jsBase + ".dispose();");
    }

    public Chart draw(Boolean async) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".draw(%s);", async));
        return this;
    }

    @Override
    public void enabled() {
        APIlib.getInstance().addJSLine(this.jsBase + ".enabled();");
    }

    @Override
    public Chart enabled(Boolean enabled) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".enabled(%s);", enabled));
        return this;
    }

    public Exports exports() {
        return new Exports(this.jsBase + ".exports()");
    }

    public Chart exports(String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".exports(%s);", Chart.wrapQuotes(settings)));
        return this;
    }

    public void fullScreen() {
        APIlib.getInstance().addJSLine(this.jsBase + ".fullScreen();");
    }

    public Chart fullScreen(Boolean enabled) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fullScreen(%s);", enabled));
        return this;
    }

    @Override
    public com.anychart.math.Rect getPixelBounds() {
        return new com.anychart.math.Rect(this.jsBase + ".getPixelBounds()");
    }

    public void getSelectedPoints() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getSelectedPoints();");
    }

    public void getStat(Statistics key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getStat(%s);", key != null ? key.getJsBase() : null));
    }

    public void getStat(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getStat(%s);", Chart.wrapQuotes(key)));
    }

    public void globalToLocal(Number xCoord, Number yCoord) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".globalToLocal(%s, %s);", xCoord, yCoord));
    }

    @Override
    public void height() {
        APIlib.getInstance().addJSLine(this.jsBase + ".height();");
    }

    @Override
    public Chart height(Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", height));
        return this;
    }

    @Override
    public Chart height(String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", Chart.wrapQuotes(height)));
        return this;
    }

    public void id() {
        APIlib.getInstance().addJSLine(this.jsBase + ".id();");
    }

    public Chart id(String id2) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".id(%s);", Chart.wrapQuotes(id2)));
        return this;
    }

    public void inMarquee() {
        APIlib.getInstance().addJSLine(this.jsBase + ".inMarquee();");
    }

    public void isFullScreenAvailable() {
        APIlib.getInstance().addJSLine(this.jsBase + ".isFullScreenAvailable();");
    }

    public Label label(String index) {
        return new Label(String.format(Locale.US, this.jsBase + ".label(%s)", Chart.wrapQuotes(index)));
    }

    public Label label(Number index) {
        return new Label(String.format(Locale.US, this.jsBase + ".label(%s)", index));
    }

    public Chart label(Boolean settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".label(%s);", settings));
        return this;
    }

    public Chart label(String index, Boolean settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".label(%s, %s);", Chart.wrapQuotes(index), settings));
        return this;
    }

    public Chart label(String index, String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".label(%s, %s);", Chart.wrapQuotes(index), Chart.wrapQuotes(settings)));
        return this;
    }

    public Chart label(Number index, Boolean settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".label(%s, %s);", index, settings));
        return this;
    }

    public Chart label(Number index, String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".label(%s, %s);", index, Chart.wrapQuotes(settings)));
        return this;
    }

    @Override
    public void left() {
        APIlib.getInstance().addJSLine(this.jsBase + ".left();");
    }

    @Override
    public Chart left(Number left) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".left(%s);", left));
        return this;
    }

    @Override
    public Chart left(String left) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".left(%s);", Chart.wrapQuotes(left)));
        return this;
    }

    public void localToGlobal(Number xCoord, Number yCoord) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".localToGlobal(%s, %s);", xCoord, yCoord));
    }

    public Margin margin() {
        return new Margin(this.jsBase + ".margin()");
    }

    public Chart margin(Number[] margin) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s);", Arrays.toString(margin)));
        return this;
    }

    public Chart margin(String[] margin) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s);", Chart.arrayToStringWrapQuotes(margin)));
        return this;
    }

    public Chart margin(String margin) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s);", Chart.wrapQuotes(margin)));
        return this;
    }

    public Chart margin(String value1, String value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Chart.wrapQuotes(value1), Chart.wrapQuotes(value2), Chart.wrapQuotes(value3), Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart margin(String value1, String value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Chart.wrapQuotes(value1), Chart.wrapQuotes(value2), Chart.wrapQuotes(value3), value4));
        return this;
    }

    public Chart margin(String value1, String value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Chart.wrapQuotes(value1), Chart.wrapQuotes(value2), value3, Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart margin(String value1, String value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Chart.wrapQuotes(value1), Chart.wrapQuotes(value2), value3, value4));
        return this;
    }

    public Chart margin(String value1, Number value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Chart.wrapQuotes(value1), value2, Chart.wrapQuotes(value3), Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart margin(String value1, Number value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Chart.wrapQuotes(value1), value2, Chart.wrapQuotes(value3), value4));
        return this;
    }

    public Chart margin(String value1, Number value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Chart.wrapQuotes(value1), value2, value3, Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart margin(String value1, Number value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", Chart.wrapQuotes(value1), value2, value3, value4));
        return this;
    }

    public Chart margin(Number value1, String value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, Chart.wrapQuotes(value2), Chart.wrapQuotes(value3), Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart margin(Number value1, String value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, Chart.wrapQuotes(value2), Chart.wrapQuotes(value3), value4));
        return this;
    }

    public Chart margin(Number value1, String value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, Chart.wrapQuotes(value2), value3, Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart margin(Number value1, String value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, Chart.wrapQuotes(value2), value3, value4));
        return this;
    }

    public Chart margin(Number value1, Number value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, value2, Chart.wrapQuotes(value3), Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart margin(Number value1, Number value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, value2, Chart.wrapQuotes(value3), value4));
        return this;
    }

    public Chart margin(Number value1, Number value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, value2, value3, Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart margin(Number value1, Number value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".margin(%s, %s, %s, %s);", value1, value2, value3, value4));
        return this;
    }

    @Override
    public void maxHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxHeight();");
    }

    @Override
    public Chart maxHeight(Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxHeight(%s);", height));
        return this;
    }

    @Override
    public Chart maxHeight(String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxHeight(%s);", Chart.wrapQuotes(height)));
        return this;
    }

    @Override
    public void maxWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxWidth();");
    }

    @Override
    public Chart maxWidth(Number width) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxWidth(%s);", width));
        return this;
    }

    @Override
    public Chart maxWidth(String width) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxWidth(%s);", Chart.wrapQuotes(width)));
        return this;
    }

    @Override
    public void minHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minHeight();");
    }

    @Override
    public Chart minHeight(Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minHeight(%s);", height));
        return this;
    }

    @Override
    public Chart minHeight(String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minHeight(%s);", Chart.wrapQuotes(height)));
        return this;
    }

    @Override
    public void minWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minWidth();");
    }

    @Override
    public Chart minWidth(Number width) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minWidth(%s);", width));
        return this;
    }

    @Override
    public Chart minWidth(String width) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minWidth(%s);", Chart.wrapQuotes(width)));
        return this;
    }

    public NoDataSettings noData() {
        return new NoDataSettings(this.jsBase + ".noData()");
    }

    public Chart noData(String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".noData(%s);", Chart.wrapQuotes(settings)));
        return this;
    }

    public Padding padding() {
        return new Padding(this.jsBase + ".padding()");
    }

    public Chart padding(Number[] padding) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s);", Arrays.toString(padding)));
        return this;
    }

    public Chart padding(String[] padding) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s);", Chart.arrayToStringWrapQuotes(padding)));
        return this;
    }

    public Chart padding(String padding) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s);", Chart.wrapQuotes(padding)));
        return this;
    }

    public Chart padding(String value1, String value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Chart.wrapQuotes(value1), Chart.wrapQuotes(value2), Chart.wrapQuotes(value3), Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart padding(String value1, String value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Chart.wrapQuotes(value1), Chart.wrapQuotes(value2), Chart.wrapQuotes(value3), value4));
        return this;
    }

    public Chart padding(String value1, String value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Chart.wrapQuotes(value1), Chart.wrapQuotes(value2), value3, Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart padding(String value1, String value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Chart.wrapQuotes(value1), Chart.wrapQuotes(value2), value3, value4));
        return this;
    }

    public Chart padding(String value1, Number value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Chart.wrapQuotes(value1), value2, Chart.wrapQuotes(value3), Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart padding(String value1, Number value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Chart.wrapQuotes(value1), value2, Chart.wrapQuotes(value3), value4));
        return this;
    }

    public Chart padding(String value1, Number value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Chart.wrapQuotes(value1), value2, value3, Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart padding(String value1, Number value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", Chart.wrapQuotes(value1), value2, value3, value4));
        return this;
    }

    public Chart padding(Number value1, String value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, Chart.wrapQuotes(value2), Chart.wrapQuotes(value3), Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart padding(Number value1, String value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, Chart.wrapQuotes(value2), Chart.wrapQuotes(value3), value4));
        return this;
    }

    public Chart padding(Number value1, String value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, Chart.wrapQuotes(value2), value3, Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart padding(Number value1, String value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, Chart.wrapQuotes(value2), value3, value4));
        return this;
    }

    public Chart padding(Number value1, Number value2, String value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, value2, Chart.wrapQuotes(value3), Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart padding(Number value1, Number value2, String value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, value2, Chart.wrapQuotes(value3), value4));
        return this;
    }

    public Chart padding(Number value1, Number value2, Number value3, String value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, value2, value3, Chart.wrapQuotes(value4)));
        return this;
    }

    public Chart padding(Number value1, Number value2, Number value3, Number value4) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".padding(%s, %s, %s, %s);", value1, value2, value3, value4));
        return this;
    }

    @Override
    public void print(PaperSize paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", paperSizeOrOptions != null ? paperSizeOrOptions.getJsBase() : null, landscape));
    }

    @Override
    public void print(String paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", Chart.wrapQuotes(paperSizeOrOptions), landscape));
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Chart.wrapQuotes(type)));
    }

    @Override
    public void right() {
        APIlib.getInstance().addJSLine(this.jsBase + ".right();");
    }

    @Override
    public Chart right(Number right) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".right(%s);", right));
        return this;
    }

    @Override
    public Chart right(String right) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".right(%s);", Chart.wrapQuotes(right)));
        return this;
    }

    public void saveAsJpg(Number width, Number height, Number quality, Boolean forceTransparentWhite, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsJpg(%s, %s, %s, %s, %s);", width, height, quality, forceTransparentWhite, Chart.wrapQuotes(filename)));
    }

    public void saveAsJpg(String width, Number height, Number quality, Boolean forceTransparentWhite, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsJpg(%s, %s, %s, %s, %s);", Chart.wrapQuotes(width), height, quality, forceTransparentWhite, Chart.wrapQuotes(filename)));
    }

    public void saveAsJson(String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsJson(%s);", Chart.wrapQuotes(filename)));
    }

    public void saveAsPdf(Number paperSizeOrWidthOrOptions, Boolean landscape, Number x, Number y, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsPdf(%s, %s, %s, %s, %s);", paperSizeOrWidthOrOptions, landscape, x, y, Chart.wrapQuotes(filename)));
    }

    public void saveAsPdf(String paperSizeOrWidthOrOptions, Boolean landscape, Number x, Number y, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsPdf(%s, %s, %s, %s, %s);", Chart.wrapQuotes(paperSizeOrWidthOrOptions), landscape, x, y, Chart.wrapQuotes(filename)));
    }

    public void saveAsPng(Number width, Number height, Number quality, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsPng(%s, %s, %s, %s);", width, height, quality, Chart.wrapQuotes(filename)));
    }

    public void saveAsPng(String width, Number height, Number quality, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsPng(%s, %s, %s, %s);", Chart.wrapQuotes(width), height, quality, Chart.wrapQuotes(filename)));
    }

    public void saveAsSvg(String paperSize, Boolean landscape, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsSvg(%s, %s, %s);", Chart.wrapQuotes(paperSize), landscape, Chart.wrapQuotes(filename)));
    }

    public void saveAsSvg(Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsSvg(%s, %s);", width, height));
    }

    public void saveAsXlsx(ChartDataExportMode chartDataExportMode, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsXlsx(%s, %s);", chartDataExportMode != null ? chartDataExportMode.getJsBase() : null, Chart.wrapQuotes(filename)));
    }

    public void saveAsXlsx(String chartDataExportMode, String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsXlsx(%s, %s);", Chart.wrapQuotes(chartDataExportMode), Chart.wrapQuotes(filename)));
    }

    public void saveAsXml(String filename) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".saveAsXml(%s);", Chart.wrapQuotes(filename)));
    }

    public void selectMarqueeFill() {
        APIlib.getInstance().addJSLine(this.jsBase + ".selectMarqueeFill();");
    }

    public Chart selectMarqueeFill(Fill color) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s);", color != null ? color.getJsBase() : null));
        return this;
    }

    public Chart selectMarqueeFill(GradientKey color) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s);", color != null ? color.getJsBase() : null));
        return this;
    }

    public Chart selectMarqueeFill(String[] color) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s);", Chart.arrayToStringWrapQuotes(color)));
        return this;
    }

    public Chart selectMarqueeFill(String color, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s);", Chart.wrapQuotes(color), opacity));
        return this;
    }

    public Chart selectMarqueeFill(GradientKey keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode, opacity));
        return this;
    }

    public Chart selectMarqueeFill(GradientKey keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    public Chart selectMarqueeFill(GradientKey keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, Chart.wrapQuotes(mode), opacity));
        return this;
    }

    public Chart selectMarqueeFill(String[] keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", Chart.arrayToStringWrapQuotes(keys), angle, mode, opacity));
        return this;
    }

    public Chart selectMarqueeFill(String[] keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", Chart.arrayToStringWrapQuotes(keys), angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    public Chart selectMarqueeFill(String[] keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s);", Chart.arrayToStringWrapQuotes(keys), angle, Chart.wrapQuotes(mode), opacity));
        return this;
    }

    public Chart selectMarqueeFill(GradientKey keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    public Chart selectMarqueeFill(String[] keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeFill(%s, %s, %s, %s, %s, %s, %s);", Chart.arrayToStringWrapQuotes(keys), cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    public void selectMarqueeStroke() {
        APIlib.getInstance().addJSLine(this.jsBase + ".selectMarqueeStroke();");
    }

    public Chart selectMarqueeStroke(Stroke color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Chart.wrapQuotes(dashpattern), Chart.wrapQuotes(lineJoin), Chart.wrapQuotes(lineCap)));
        return this;
    }

    public Chart selectMarqueeStroke(Stroke color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Chart.wrapQuotes(dashpattern), Chart.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Chart selectMarqueeStroke(Stroke color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Chart.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Chart.wrapQuotes(lineCap)));
        return this;
    }

    public Chart selectMarqueeStroke(Stroke color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Chart.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Chart selectMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Chart.wrapQuotes(dashpattern), Chart.wrapQuotes(lineJoin), Chart.wrapQuotes(lineCap)));
        return this;
    }

    public Chart selectMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Chart.wrapQuotes(dashpattern), Chart.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Chart selectMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Chart.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Chart.wrapQuotes(lineCap)));
        return this;
    }

    public Chart selectMarqueeStroke(ColoredFill color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Chart.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Chart selectMarqueeStroke(String color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", Chart.wrapQuotes(color), thickness, Chart.wrapQuotes(dashpattern), Chart.wrapQuotes(lineJoin), Chart.wrapQuotes(lineCap)));
        return this;
    }

    public Chart selectMarqueeStroke(String color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", Chart.wrapQuotes(color), thickness, Chart.wrapQuotes(dashpattern), Chart.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Chart selectMarqueeStroke(String color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", Chart.wrapQuotes(color), thickness, Chart.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Chart.wrapQuotes(lineCap)));
        return this;
    }

    public Chart selectMarqueeStroke(String color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectMarqueeStroke(%s, %s, %s, %s, %s);", Chart.wrapQuotes(color), thickness, Chart.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public void shareWithFacebook(String captionOrOptions, String link, String name, String description) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareWithFacebook(%s, %s, %s, %s);", Chart.wrapQuotes(captionOrOptions), Chart.wrapQuotes(link), Chart.wrapQuotes(name), Chart.wrapQuotes(description)));
    }

    public void shareWithLinkedIn(String captionOrOptions, String description) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareWithLinkedIn(%s, %s);", Chart.wrapQuotes(captionOrOptions), Chart.wrapQuotes(description)));
    }

    public void shareWithPinterest(String linkOrOptions, String description) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".shareWithPinterest(%s, %s);", Chart.wrapQuotes(linkOrOptions), Chart.wrapQuotes(description)));
    }

    public void shareWithTwitter() {
        APIlib.getInstance().addJSLine(this.jsBase + ".shareWithTwitter();");
    }

    public Chart startSelectMarquee(Boolean repeat) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".startSelectMarquee(%s);", repeat));
        return this;
    }

    public Title title() {
        return new Title(this.jsBase + ".title()");
    }

    public Chart title(Boolean settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".title(%s);", settings));
        return this;
    }

    public Chart title(String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".title(%s);", Chart.wrapQuotes(settings)));
        return this;
    }

    public void toA11yTable(String title, Boolean asString) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toA11yTable(%s, %s);", Chart.wrapQuotes(title), asString));
    }

    public void toHtmlTable(String title, Boolean asString) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toHtmlTable(%s, %s);", Chart.wrapQuotes(title), asString));
    }

    public void toJson(Boolean stringify) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toJson(%s);", stringify));
    }

    public void toSvg(String paperSize, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toSvg(%s, %s);", Chart.wrapQuotes(paperSize), landscape));
    }

    public void toSvg(Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toSvg(%s, %s);", width, height));
    }

    public void toXml(Boolean asXmlNode) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".toXml(%s);", asXmlNode));
    }

    public Tooltip tooltip() {
        return new Tooltip(this.jsBase + ".tooltip()");
    }

    public Chart tooltip(String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".tooltip(%s);", Chart.wrapQuotes(settings)));
        return this;
    }

    public Chart tooltip(Boolean settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".tooltip(%s);", settings));
        return this;
    }

    @Override
    public void top() {
        APIlib.getInstance().addJSLine(this.jsBase + ".top();");
    }

    @Override
    public Chart top(Number top) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".top(%s);", top));
        return this;
    }

    @Override
    public Chart top(String top) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".top(%s);", Chart.wrapQuotes(top)));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Chart.wrapQuotes(key)));
    }

    @Override
    public void width() {
        APIlib.getInstance().addJSLine(this.jsBase + ".width();");
    }

    @Override
    public Chart width(Number width) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".width(%s);", width));
        return this;
    }

    @Override
    public Chart width(String width) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".width(%s);", Chart.wrapQuotes(width)));
        return this;
    }

    @Override
    public void zIndex() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zIndex();");
    }

    @Override
    public Chart zIndex(Number zIndex) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zIndex(%s);", zIndex));
        return this;
    }

    @Override
    public com.anychart.math.Rect parentBounds() {
        return new com.anychart.math.Rect(this.jsBase + ".parentBounds()");
    }

    @Override
    public Chart parentBounds(com.anychart.math.Rect bounds) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".parentBounds(%s);", bounds != null ? bounds.getJsBase() : null));
        return this;
    }

    @Override
    public Chart parentBounds(String bounds) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".parentBounds(%s);", Chart.wrapQuotes(bounds)));
        return this;
    }

    @Override
    public Chart parentBounds(Number bounds) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".parentBounds(%s);", bounds));
        return this;
    }

    @Override
    public Chart parentBounds(Number left, Number top, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".parentBounds(%s, %s, %s, %s);", left, top, width, height));
        return this;
    }
}

