/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.core.stock;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.Base;
import com.anychart.core.stock.grouping.Level;
import java.util.Locale;

public class Grouping
extends Base {
    protected Grouping() {
    }

    public static Grouping instantiate() {
        return new Grouping("new anychart.core.stock.grouping()");
    }

    public Grouping(String jsChart) {
        this.jsBase = "grouping" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public void enabled() {
        APIlib.getInstance().addJSLine(this.jsBase + ".enabled();");
    }

    public Grouping enabled(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".enabled(%s);", value));
        return this;
    }

    public void forced() {
        APIlib.getInstance().addJSLine(this.jsBase + ".forced();");
    }

    public Grouping forced(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".forced(%s);", value));
        return this;
    }

    public void getCurrentDataInterval() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getCurrentDataInterval();");
    }

    public void isGrouped() {
        APIlib.getInstance().addJSLine(this.jsBase + ".isGrouped();");
    }

    public void levels() {
        APIlib.getInstance().addJSLine(this.jsBase + ".levels();");
    }

    public Grouping levels(Level value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".levels(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Grouping levels(String[] value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".levels(%s);", Grouping.arrayToStringWrapQuotes(value)));
        return this;
    }

    public void maxVisiblePoints() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxVisiblePoints();");
    }

    public Grouping maxVisiblePoints(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxVisiblePoints(%s);", value));
        return this;
    }

    public void minPixPerPoint() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minPixPerPoint();");
    }

    public Grouping minPixPerPoint(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minPixPerPoint(%s);", value));
        return this;
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Grouping.wrapQuotes(type)));
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Grouping.wrapQuotes(key)));
    }
}

