/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.scales;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.Base;
import java.util.Locale;

public class GeoTicks
extends Base {
    protected GeoTicks() {
    }

    public static GeoTicks instantiate() {
        return new GeoTicks("new anychart.scales.geoTicks()");
    }

    public GeoTicks(String jsChart) {
        this.jsBase = "geoTicks" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public void count() {
        APIlib.getInstance().addJSLine(this.jsBase + ".count();");
    }

    public GeoTicks count(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".count(%s);", value));
        return this;
    }

    public GeoTicks count(Number minimumCount, Number maximumCount) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".count(%s, %s);", minimumCount, maximumCount));
        return this;
    }

    public void get() {
        APIlib.getInstance().addJSLine(this.jsBase + ".get();");
    }

    public void interval() {
        APIlib.getInstance().addJSLine(this.jsBase + ".interval();");
    }

    public GeoTicks interval(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".interval(%s);", value));
        return this;
    }

    public GeoTicks set(String[] ticks) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".set(%s);", GeoTicks.arrayToStringWrapQuotes(ticks)));
        return this;
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", GeoTicks.wrapQuotes(type)));
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", GeoTicks.wrapQuotes(key)));
    }
}

