package com.anychart.core.stock.indicators;

import com.anychart.APIlib;
import com.anychart.JsObject;

import java.util.Locale;

// class
/**
 * Bollinger Bands Width (BBands Width) indicator class.
 */
public class BBandsWidth extends JsObject {

    protected BBandsWidth() {

    }

    public static BBandsWidth instantiate() {
        return new BBandsWidth("new anychart.core.stock.indicators.bBandsWidth()");
    }

    

    public BBandsWidth(String jsChart) {
        jsBase = "bBandsWidth" + ++variableIndex;
        APIlib.getInstance().addJSLine(jsBase + " = " + jsChart + ";");
    }

    public String getJsBase() {
        return jsBase;
    }

    
    /**
     * Getter for the deviation.
     */
    public void deviation() {
        APIlib.getInstance().addJSLine(jsBase + ".deviation();");
    }
    /**
     * Setter for the deviation.
     */
    public com.anychart.core.stock.indicators.BBandsWidth deviation(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, jsBase + ".deviation(%s);", value));

        return this;
    }
    /**
     * Getter for the period.
     */
    public void period() {
        APIlib.getInstance().addJSLine(jsBase + ".period();");
    }
    /**
     * Setter for the period.
     */
    public com.anychart.core.stock.indicators.BBandsWidth period(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, jsBase + ".period(%s);", value));

        return this;
    }
    /**
     * Getter for the indicator series.
     */
    public com.anychart.core.stock.series.Base series() {
        return new com.anychart.core.stock.series.Base(jsBase + ".series()");
    }
    /**
     * Setter for the indicator series.
     */
    public com.anychart.core.stock.indicators.BBandsWidth series(com.anychart.enums.StockSeriesType type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, jsBase + ".series(%s);", (type != null) ? type.getJsBase() : null));

        return this;
    }
    /**
     * Setter for the indicator series.
     */
    public com.anychart.core.stock.indicators.BBandsWidth series(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, jsBase + ".series(%s);", wrapQuotes(type)));

        return this;
    }

}