/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.core.stock;

import com.anychart.APIlib;
import com.anychart.chart.common.dataentry.DataEntry;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.NoDataSettings;
import com.anychart.core.VisualBaseWithBounds;
import com.anychart.core.annotations.PlotController;
import com.anychart.core.axes.Linear;
import com.anychart.core.axes.StockDateTime;
import com.anychart.core.axismarkers.CurrentPriceIndicator;
import com.anychart.core.grids.Stock;
import com.anychart.core.stock.eventmarkers.Controller;
import com.anychart.core.stock.indicators.ADL;
import com.anychart.core.stock.indicators.AMA;
import com.anychart.core.stock.indicators.ATR;
import com.anychart.core.stock.indicators.Aroon;
import com.anychart.core.stock.indicators.BBands;
import com.anychart.core.stock.indicators.BBandsB;
import com.anychart.core.stock.indicators.BBandsWidth;
import com.anychart.core.stock.indicators.CCI;
import com.anychart.core.stock.indicators.CHO;
import com.anychart.core.stock.indicators.CMF;
import com.anychart.core.stock.indicators.DMI;
import com.anychart.core.stock.indicators.EMA;
import com.anychart.core.stock.indicators.KDJ;
import com.anychart.core.stock.indicators.MACD;
import com.anychart.core.stock.indicators.MFI;
import com.anychart.core.stock.indicators.MMA;
import com.anychart.core.stock.indicators.Momentum;
import com.anychart.core.stock.indicators.PSAR;
import com.anychart.core.stock.indicators.RSI;
import com.anychart.core.stock.indicators.RoC;
import com.anychart.core.stock.indicators.SMA;
import com.anychart.core.stock.indicators.Stochastic;
import com.anychart.core.stock.indicators.WilliamsR;
import com.anychart.core.stock.series.Area;
import com.anychart.core.stock.series.Base;
import com.anychart.core.stock.series.Hilo;
import com.anychart.core.stock.series.OHLC;
import com.anychart.core.ui.Background;
import com.anychart.core.ui.Crosshair;
import com.anychart.core.ui.Legend;
import com.anychart.core.utils.Bounds;
import com.anychart.data.Table;
import com.anychart.data.TableMapping;
import com.anychart.data.View;
import com.anychart.enums.MarkerType;
import com.anychart.enums.MovingAverageType;
import com.anychart.enums.ScatterScaleTypes;
import com.anychart.enums.StockSeriesType;
import com.anychart.graphics.vector.PaperSize;
import com.anychart.graphics.vector.hatchfill.HatchFillType;
import com.anychart.math.Rect;
import com.anychart.palettes.DistinctColors;
import com.anychart.palettes.HatchFills;
import com.anychart.palettes.Markers;
import com.anychart.palettes.RangeColors;
import com.anychart.scales.ScatterBase;
import com.anychart.utils.RectObj;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;

public class Plot
extends VisualBaseWithBounds {
    protected Plot() {
    }

    public static Plot instantiate() {
        return new Plot("new anychart.core.stock.plot()");
    }

    public Plot(String jsChart) {
        this.jsBase = "plot" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public void addSeries(TableMapping var_args) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".addSeries(%s);", var_args != null ? var_args.getJsBase() : null));
    }

    public ADL adl(TableMapping mapping, StockSeriesType seriesType) {
        return new ADL(String.format(Locale.US, this.jsBase + ".adl(%s, %s)", mapping != null ? mapping.getJsBase() : null, seriesType != null ? seriesType.getJsBase() : null));
    }

    public ADL adl(TableMapping mapping, String seriesType) {
        return new ADL(String.format(Locale.US, this.jsBase + ".adl(%s, %s)", mapping != null ? mapping.getJsBase() : null, Plot.wrapQuotes(seriesType)));
    }

    public AMA ama(TableMapping mapping, Number period, Number fastPeriod, Number slowPeriod, StockSeriesType seriesType) {
        return new AMA(String.format(Locale.US, this.jsBase + ".ama(%s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, fastPeriod, slowPeriod, seriesType != null ? seriesType.getJsBase() : null));
    }

    public AMA ama(TableMapping mapping, Number period, Number fastPeriod, Number slowPeriod, String seriesType) {
        return new AMA(String.format(Locale.US, this.jsBase + ".ama(%s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, fastPeriod, slowPeriod, Plot.wrapQuotes(seriesType)));
    }

    public PlotController annotations() {
        return new PlotController(this.jsBase + ".annotations()");
    }

    public Plot annotations(String[] annotationsList) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".annotations(%s);", Plot.arrayToStringWrapQuotes(annotationsList)));
        return this;
    }

    public Area area(List<DataEntry> data) {
        return new Area(String.format(Locale.US, this.jsBase + ".area(%s)", Plot.arrayToString(data)));
    }

    public Aroon aroon(TableMapping mapping, Number period, StockSeriesType upSeriesType, StockSeriesType downSeriesType) {
        return new Aroon(String.format(Locale.US, this.jsBase + ".aroon(%s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, upSeriesType != null ? upSeriesType.getJsBase() : null, downSeriesType != null ? downSeriesType.getJsBase() : null));
    }

    public Aroon aroon(TableMapping mapping, Number period, StockSeriesType upSeriesType, String downSeriesType) {
        return new Aroon(String.format(Locale.US, this.jsBase + ".aroon(%s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, upSeriesType != null ? upSeriesType.getJsBase() : null, Plot.wrapQuotes(downSeriesType)));
    }

    public Aroon aroon(TableMapping mapping, Number period, String upSeriesType, StockSeriesType downSeriesType) {
        return new Aroon(String.format(Locale.US, this.jsBase + ".aroon(%s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(upSeriesType), downSeriesType != null ? downSeriesType.getJsBase() : null));
    }

    public Aroon aroon(TableMapping mapping, Number period, String upSeriesType, String downSeriesType) {
        return new Aroon(String.format(Locale.US, this.jsBase + ".aroon(%s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(upSeriesType), Plot.wrapQuotes(downSeriesType)));
    }

    public ATR atr(TableMapping mapping, Number period, StockSeriesType seriesType) {
        return new ATR(String.format(Locale.US, this.jsBase + ".atr(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, seriesType != null ? seriesType.getJsBase() : null));
    }

    public ATR atr(TableMapping mapping, Number period, String seriesType) {
        return new ATR(String.format(Locale.US, this.jsBase + ".atr(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(seriesType)));
    }

    public Background background() {
        return new Background(this.jsBase + ".background()");
    }

    public Plot background(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".background(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot background(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".background(%s);", value));
        return this;
    }

    public BBands bbands(TableMapping mapping, Number period, Number deviation, StockSeriesType upperSeriesType, StockSeriesType lowerSeriesType, StockSeriesType middleSeriesType) {
        return new BBands(String.format(Locale.US, this.jsBase + ".bbands(%s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, upperSeriesType != null ? upperSeriesType.getJsBase() : null, lowerSeriesType != null ? lowerSeriesType.getJsBase() : null, middleSeriesType != null ? middleSeriesType.getJsBase() : null));
    }

    public BBands bbands(TableMapping mapping, Number period, Number deviation, StockSeriesType upperSeriesType, StockSeriesType lowerSeriesType, String middleSeriesType) {
        return new BBands(String.format(Locale.US, this.jsBase + ".bbands(%s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, upperSeriesType != null ? upperSeriesType.getJsBase() : null, lowerSeriesType != null ? lowerSeriesType.getJsBase() : null, Plot.wrapQuotes(middleSeriesType)));
    }

    public BBands bbands(TableMapping mapping, Number period, Number deviation, StockSeriesType upperSeriesType, String lowerSeriesType, StockSeriesType middleSeriesType) {
        return new BBands(String.format(Locale.US, this.jsBase + ".bbands(%s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, upperSeriesType != null ? upperSeriesType.getJsBase() : null, Plot.wrapQuotes(lowerSeriesType), middleSeriesType != null ? middleSeriesType.getJsBase() : null));
    }

    public BBands bbands(TableMapping mapping, Number period, Number deviation, StockSeriesType upperSeriesType, String lowerSeriesType, String middleSeriesType) {
        return new BBands(String.format(Locale.US, this.jsBase + ".bbands(%s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, upperSeriesType != null ? upperSeriesType.getJsBase() : null, Plot.wrapQuotes(lowerSeriesType), Plot.wrapQuotes(middleSeriesType)));
    }

    public BBands bbands(TableMapping mapping, Number period, Number deviation, String upperSeriesType, StockSeriesType lowerSeriesType, StockSeriesType middleSeriesType) {
        return new BBands(String.format(Locale.US, this.jsBase + ".bbands(%s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, Plot.wrapQuotes(upperSeriesType), lowerSeriesType != null ? lowerSeriesType.getJsBase() : null, middleSeriesType != null ? middleSeriesType.getJsBase() : null));
    }

    public BBands bbands(TableMapping mapping, Number period, Number deviation, String upperSeriesType, StockSeriesType lowerSeriesType, String middleSeriesType) {
        return new BBands(String.format(Locale.US, this.jsBase + ".bbands(%s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, Plot.wrapQuotes(upperSeriesType), lowerSeriesType != null ? lowerSeriesType.getJsBase() : null, Plot.wrapQuotes(middleSeriesType)));
    }

    public BBands bbands(TableMapping mapping, Number period, Number deviation, String upperSeriesType, String lowerSeriesType, StockSeriesType middleSeriesType) {
        return new BBands(String.format(Locale.US, this.jsBase + ".bbands(%s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, Plot.wrapQuotes(upperSeriesType), Plot.wrapQuotes(lowerSeriesType), middleSeriesType != null ? middleSeriesType.getJsBase() : null));
    }

    public BBands bbands(TableMapping mapping, Number period, Number deviation, String upperSeriesType, String lowerSeriesType, String middleSeriesType) {
        return new BBands(String.format(Locale.US, this.jsBase + ".bbands(%s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, Plot.wrapQuotes(upperSeriesType), Plot.wrapQuotes(lowerSeriesType), Plot.wrapQuotes(middleSeriesType)));
    }

    public BBandsB bbandsB(TableMapping mapping, Number period, Number deviation, StockSeriesType seriesType) {
        return new BBandsB(String.format(Locale.US, this.jsBase + ".bbandsB(%s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, seriesType != null ? seriesType.getJsBase() : null));
    }

    public BBandsB bbandsB(TableMapping mapping, Number period, Number deviation, String seriesType) {
        return new BBandsB(String.format(Locale.US, this.jsBase + ".bbandsB(%s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, Plot.wrapQuotes(seriesType)));
    }

    public BBandsWidth bbandsWidth(TableMapping mapping, Number period, Number deviation, StockSeriesType seriesType) {
        return new BBandsWidth(String.format(Locale.US, this.jsBase + ".bbandsWidth(%s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, seriesType != null ? seriesType.getJsBase() : null));
    }

    public BBandsWidth bbandsWidth(TableMapping mapping, Number period, Number deviation, String seriesType) {
        return new BBandsWidth(String.format(Locale.US, this.jsBase + ".bbandsWidth(%s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, deviation, Plot.wrapQuotes(seriesType)));
    }

    @Override
    public void bottom() {
        APIlib.getInstance().addJSLine(this.jsBase + ".bottom();");
    }

    @Override
    public Plot bottom(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bottom(%s);", value));
        return this;
    }

    @Override
    public Plot bottom(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bottom(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    @Override
    public Bounds bounds() {
        return new Bounds(this.jsBase + ".bounds()");
    }

    @Override
    public Plot bounds(RectObj value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Plot bounds(Rect value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Plot bounds(Bounds value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Plot bounds(Number x, Number y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, width, height));
        return this;
    }

    @Override
    public Plot bounds(Number x, Number y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, width, Plot.wrapQuotes(height)));
        return this;
    }

    @Override
    public Plot bounds(Number x, Number y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, Plot.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Plot bounds(Number x, Number y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, Plot.wrapQuotes(width), Plot.wrapQuotes(height)));
        return this;
    }

    @Override
    public Plot bounds(Number x, String y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Plot.wrapQuotes(y), width, height));
        return this;
    }

    @Override
    public Plot bounds(Number x, String y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Plot.wrapQuotes(y), width, Plot.wrapQuotes(height)));
        return this;
    }

    @Override
    public Plot bounds(Number x, String y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Plot.wrapQuotes(y), Plot.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Plot bounds(Number x, String y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Plot.wrapQuotes(y), Plot.wrapQuotes(width), Plot.wrapQuotes(height)));
        return this;
    }

    @Override
    public Plot bounds(String x, Number y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Plot.wrapQuotes(x), y, width, height));
        return this;
    }

    @Override
    public Plot bounds(String x, Number y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Plot.wrapQuotes(x), y, width, Plot.wrapQuotes(height)));
        return this;
    }

    @Override
    public Plot bounds(String x, Number y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Plot.wrapQuotes(x), y, Plot.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Plot bounds(String x, Number y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Plot.wrapQuotes(x), y, Plot.wrapQuotes(width), Plot.wrapQuotes(height)));
        return this;
    }

    @Override
    public Plot bounds(String x, String y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Plot.wrapQuotes(x), Plot.wrapQuotes(y), width, height));
        return this;
    }

    @Override
    public Plot bounds(String x, String y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Plot.wrapQuotes(x), Plot.wrapQuotes(y), width, Plot.wrapQuotes(height)));
        return this;
    }

    @Override
    public Plot bounds(String x, String y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Plot.wrapQuotes(x), Plot.wrapQuotes(y), Plot.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Plot bounds(String x, String y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Plot.wrapQuotes(x), Plot.wrapQuotes(y), Plot.wrapQuotes(width), Plot.wrapQuotes(height)));
        return this;
    }

    public CCI cci(TableMapping mapping, Number period, StockSeriesType seriesType) {
        return new CCI(String.format(Locale.US, this.jsBase + ".cci(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, seriesType != null ? seriesType.getJsBase() : null));
    }

    public CCI cci(TableMapping mapping, Number period, String seriesType) {
        return new CCI(String.format(Locale.US, this.jsBase + ".cci(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(seriesType)));
    }

    public CHO cho(TableMapping mapping, Number fastPeriod, Number slowPeriod, MovingAverageType maType, StockSeriesType seriesType) {
        return new CHO(String.format(Locale.US, this.jsBase + ".cho(%s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, maType != null ? maType.getJsBase() : null, seriesType != null ? seriesType.getJsBase() : null));
    }

    public CHO cho(TableMapping mapping, Number fastPeriod, Number slowPeriod, MovingAverageType maType, String seriesType) {
        return new CHO(String.format(Locale.US, this.jsBase + ".cho(%s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, maType != null ? maType.getJsBase() : null, Plot.wrapQuotes(seriesType)));
    }

    public CHO cho(TableMapping mapping, Number fastPeriod, Number slowPeriod, String maType, StockSeriesType seriesType) {
        return new CHO(String.format(Locale.US, this.jsBase + ".cho(%s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, Plot.wrapQuotes(maType), seriesType != null ? seriesType.getJsBase() : null));
    }

    public CHO cho(TableMapping mapping, Number fastPeriod, Number slowPeriod, String maType, String seriesType) {
        return new CHO(String.format(Locale.US, this.jsBase + ".cho(%s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, Plot.wrapQuotes(maType), Plot.wrapQuotes(seriesType)));
    }

    public CMF cmf(TableMapping mapping, Number period, StockSeriesType seriesType) {
        return new CMF(String.format(Locale.US, this.jsBase + ".cmf(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, seriesType != null ? seriesType.getJsBase() : null));
    }

    public CMF cmf(TableMapping mapping, Number period, String seriesType) {
        return new CMF(String.format(Locale.US, this.jsBase + ".cmf(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(seriesType)));
    }

    public Crosshair crosshair() {
        return new Crosshair(this.jsBase + ".crosshair()");
    }

    public Plot crosshair(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".crosshair(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot crosshair(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".crosshair(%s);", value));
        return this;
    }

    public void defaultSeriesType() {
        APIlib.getInstance().addJSLine(this.jsBase + ".defaultSeriesType();");
    }

    public Plot defaultSeriesType(StockSeriesType value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".defaultSeriesType(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Plot defaultSeriesType(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".defaultSeriesType(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public DMI dmi(TableMapping mapping, Number period, Number adxPeriod, Boolean useWildersSmoothing, StockSeriesType pdiSeriesType, StockSeriesType ndiSeriesType, StockSeriesType adxSeriesType) {
        return new DMI(String.format(Locale.US, this.jsBase + ".dmi(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, adxPeriod, useWildersSmoothing, pdiSeriesType != null ? pdiSeriesType.getJsBase() : null, ndiSeriesType != null ? ndiSeriesType.getJsBase() : null, adxSeriesType != null ? adxSeriesType.getJsBase() : null));
    }

    public DMI dmi(TableMapping mapping, Number period, Number adxPeriod, Boolean useWildersSmoothing, StockSeriesType pdiSeriesType, StockSeriesType ndiSeriesType, String adxSeriesType) {
        return new DMI(String.format(Locale.US, this.jsBase + ".dmi(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, adxPeriod, useWildersSmoothing, pdiSeriesType != null ? pdiSeriesType.getJsBase() : null, ndiSeriesType != null ? ndiSeriesType.getJsBase() : null, Plot.wrapQuotes(adxSeriesType)));
    }

    public DMI dmi(TableMapping mapping, Number period, Number adxPeriod, Boolean useWildersSmoothing, StockSeriesType pdiSeriesType, String ndiSeriesType, StockSeriesType adxSeriesType) {
        return new DMI(String.format(Locale.US, this.jsBase + ".dmi(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, adxPeriod, useWildersSmoothing, pdiSeriesType != null ? pdiSeriesType.getJsBase() : null, Plot.wrapQuotes(ndiSeriesType), adxSeriesType != null ? adxSeriesType.getJsBase() : null));
    }

    public DMI dmi(TableMapping mapping, Number period, Number adxPeriod, Boolean useWildersSmoothing, StockSeriesType pdiSeriesType, String ndiSeriesType, String adxSeriesType) {
        return new DMI(String.format(Locale.US, this.jsBase + ".dmi(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, adxPeriod, useWildersSmoothing, pdiSeriesType != null ? pdiSeriesType.getJsBase() : null, Plot.wrapQuotes(ndiSeriesType), Plot.wrapQuotes(adxSeriesType)));
    }

    public DMI dmi(TableMapping mapping, Number period, Number adxPeriod, Boolean useWildersSmoothing, String pdiSeriesType, StockSeriesType ndiSeriesType, StockSeriesType adxSeriesType) {
        return new DMI(String.format(Locale.US, this.jsBase + ".dmi(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, adxPeriod, useWildersSmoothing, Plot.wrapQuotes(pdiSeriesType), ndiSeriesType != null ? ndiSeriesType.getJsBase() : null, adxSeriesType != null ? adxSeriesType.getJsBase() : null));
    }

    public DMI dmi(TableMapping mapping, Number period, Number adxPeriod, Boolean useWildersSmoothing, String pdiSeriesType, StockSeriesType ndiSeriesType, String adxSeriesType) {
        return new DMI(String.format(Locale.US, this.jsBase + ".dmi(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, adxPeriod, useWildersSmoothing, Plot.wrapQuotes(pdiSeriesType), ndiSeriesType != null ? ndiSeriesType.getJsBase() : null, Plot.wrapQuotes(adxSeriesType)));
    }

    public DMI dmi(TableMapping mapping, Number period, Number adxPeriod, Boolean useWildersSmoothing, String pdiSeriesType, String ndiSeriesType, StockSeriesType adxSeriesType) {
        return new DMI(String.format(Locale.US, this.jsBase + ".dmi(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, adxPeriod, useWildersSmoothing, Plot.wrapQuotes(pdiSeriesType), Plot.wrapQuotes(ndiSeriesType), adxSeriesType != null ? adxSeriesType.getJsBase() : null));
    }

    public DMI dmi(TableMapping mapping, Number period, Number adxPeriod, Boolean useWildersSmoothing, String pdiSeriesType, String ndiSeriesType, String adxSeriesType) {
        return new DMI(String.format(Locale.US, this.jsBase + ".dmi(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, adxPeriod, useWildersSmoothing, Plot.wrapQuotes(pdiSeriesType), Plot.wrapQuotes(ndiSeriesType), Plot.wrapQuotes(adxSeriesType)));
    }

    public EMA ema(TableMapping mapping, Number period, StockSeriesType seriesType) {
        return new EMA(String.format(Locale.US, this.jsBase + ".ema(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, seriesType != null ? seriesType.getJsBase() : null));
    }

    public EMA ema(TableMapping mapping, Number period, String seriesType) {
        return new EMA(String.format(Locale.US, this.jsBase + ".ema(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(seriesType)));
    }

    @Override
    public void enabled() {
        APIlib.getInstance().addJSLine(this.jsBase + ".enabled();");
    }

    @Override
    public Plot enabled(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".enabled(%s);", value));
        return this;
    }

    public Controller eventMarkers() {
        return new Controller(this.jsBase + ".eventMarkers()");
    }

    public Plot eventMarkers(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".eventMarkers(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot eventMarkers(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".eventMarkers(%s);", value));
        return this;
    }

    @Override
    public Rect getPixelBounds() {
        return new Rect(this.jsBase + ".getPixelBounds()");
    }

    public Base getSeries(Number id2) {
        return new Base(String.format(Locale.US, this.jsBase + ".getSeries(%s)", id2));
    }

    public Base getSeries(String id2) {
        return new Base(String.format(Locale.US, this.jsBase + ".getSeries(%s)", Plot.wrapQuotes(id2)));
    }

    public Base getSeriesAt(Number index) {
        return new Base(String.format(Locale.US, this.jsBase + ".getSeriesAt(%s)", index));
    }

    public void getSeriesCount() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getSeriesCount();");
    }

    public HatchFills hatchFillPalette() {
        return new HatchFills(this.jsBase + ".hatchFillPalette()");
    }

    public HatchFills hatchFillPalette(HatchFillType[] value) {
        return new HatchFills(String.format(Locale.US, this.jsBase + ".hatchFillPalette(%s)", Plot.arrayToString((Object[])value)));
    }

    public HatchFills hatchFillPalette(String value) {
        return new HatchFills(String.format(Locale.US, this.jsBase + ".hatchFillPalette(%s)", Plot.wrapQuotes(value)));
    }

    public HatchFills hatchFillPalette(HatchFills value) {
        return new HatchFills(String.format(Locale.US, this.jsBase + ".hatchFillPalette(%s)", value != null ? value.getJsBase() : null));
    }

    @Override
    public void height() {
        APIlib.getInstance().addJSLine(this.jsBase + ".height();");
    }

    @Override
    public Plot height(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", value));
        return this;
    }

    @Override
    public Plot height(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Hilo hilo(Table data) {
        return new Hilo(String.format(Locale.US, this.jsBase + ".hilo(%s)", data != null ? data.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, StockSeriesType dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null, jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, StockSeriesType dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null, Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, String dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType), jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, String dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType), Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, StockSeriesType dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null, jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, StockSeriesType dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null, Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, String dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType), jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, String dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType), Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, StockSeriesType dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null, jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, StockSeriesType dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null, Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, String dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType), jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, String dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType), Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, StockSeriesType dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null, jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, StockSeriesType dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null, Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, String dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType), jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, String dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType), Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, StockSeriesType dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null, jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, StockSeriesType dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null, Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, String dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType), jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, String dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType), Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, StockSeriesType dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null, jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, StockSeriesType dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null, Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, String dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType), jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, String dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType), Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, StockSeriesType dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null, jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, StockSeriesType dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null, Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, String dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType), jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, Number kMultiplier, Number dMultiplier, StockSeriesType kSeriesType, String dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType), Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, StockSeriesType dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null, jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, StockSeriesType dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null, Plot.wrapQuotes(jSeriesType)));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, String dSeriesType, StockSeriesType jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType), jSeriesType != null ? jSeriesType.getJsBase() : null));
    }

    public KDJ kdj(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, Number kMultiplier, Number dMultiplier, String kSeriesType, String dSeriesType, String jSeriesType) {
        return new KDJ(String.format(Locale.US, this.jsBase + ".kdj(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), kMultiplier, dMultiplier, Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType), Plot.wrapQuotes(jSeriesType)));
    }

    @Override
    public void left() {
        APIlib.getInstance().addJSLine(this.jsBase + ".left();");
    }

    @Override
    public Plot left(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".left(%s);", value));
        return this;
    }

    @Override
    public Plot left(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".left(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Legend legend() {
        return new Legend(this.jsBase + ".legend()");
    }

    public Plot legend(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".legend(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot legend(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".legend(%s);", value));
        return this;
    }

    public MACD macd(TableMapping mapping, Number fastPeriod, Number slowPeriod, Number signalPeriod, StockSeriesType macdSeriesType, StockSeriesType signalSeriesType, StockSeriesType histogramSeriesType) {
        return new MACD(String.format(Locale.US, this.jsBase + ".macd(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, signalPeriod, macdSeriesType != null ? macdSeriesType.getJsBase() : null, signalSeriesType != null ? signalSeriesType.getJsBase() : null, histogramSeriesType != null ? histogramSeriesType.getJsBase() : null));
    }

    public MACD macd(TableMapping mapping, Number fastPeriod, Number slowPeriod, Number signalPeriod, StockSeriesType macdSeriesType, StockSeriesType signalSeriesType, String histogramSeriesType) {
        return new MACD(String.format(Locale.US, this.jsBase + ".macd(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, signalPeriod, macdSeriesType != null ? macdSeriesType.getJsBase() : null, signalSeriesType != null ? signalSeriesType.getJsBase() : null, Plot.wrapQuotes(histogramSeriesType)));
    }

    public MACD macd(TableMapping mapping, Number fastPeriod, Number slowPeriod, Number signalPeriod, StockSeriesType macdSeriesType, String signalSeriesType, StockSeriesType histogramSeriesType) {
        return new MACD(String.format(Locale.US, this.jsBase + ".macd(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, signalPeriod, macdSeriesType != null ? macdSeriesType.getJsBase() : null, Plot.wrapQuotes(signalSeriesType), histogramSeriesType != null ? histogramSeriesType.getJsBase() : null));
    }

    public MACD macd(TableMapping mapping, Number fastPeriod, Number slowPeriod, Number signalPeriod, StockSeriesType macdSeriesType, String signalSeriesType, String histogramSeriesType) {
        return new MACD(String.format(Locale.US, this.jsBase + ".macd(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, signalPeriod, macdSeriesType != null ? macdSeriesType.getJsBase() : null, Plot.wrapQuotes(signalSeriesType), Plot.wrapQuotes(histogramSeriesType)));
    }

    public MACD macd(TableMapping mapping, Number fastPeriod, Number slowPeriod, Number signalPeriod, String macdSeriesType, StockSeriesType signalSeriesType, StockSeriesType histogramSeriesType) {
        return new MACD(String.format(Locale.US, this.jsBase + ".macd(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, signalPeriod, Plot.wrapQuotes(macdSeriesType), signalSeriesType != null ? signalSeriesType.getJsBase() : null, histogramSeriesType != null ? histogramSeriesType.getJsBase() : null));
    }

    public MACD macd(TableMapping mapping, Number fastPeriod, Number slowPeriod, Number signalPeriod, String macdSeriesType, StockSeriesType signalSeriesType, String histogramSeriesType) {
        return new MACD(String.format(Locale.US, this.jsBase + ".macd(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, signalPeriod, Plot.wrapQuotes(macdSeriesType), signalSeriesType != null ? signalSeriesType.getJsBase() : null, Plot.wrapQuotes(histogramSeriesType)));
    }

    public MACD macd(TableMapping mapping, Number fastPeriod, Number slowPeriod, Number signalPeriod, String macdSeriesType, String signalSeriesType, StockSeriesType histogramSeriesType) {
        return new MACD(String.format(Locale.US, this.jsBase + ".macd(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, signalPeriod, Plot.wrapQuotes(macdSeriesType), Plot.wrapQuotes(signalSeriesType), histogramSeriesType != null ? histogramSeriesType.getJsBase() : null));
    }

    public MACD macd(TableMapping mapping, Number fastPeriod, Number slowPeriod, Number signalPeriod, String macdSeriesType, String signalSeriesType, String histogramSeriesType) {
        return new MACD(String.format(Locale.US, this.jsBase + ".macd(%s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, fastPeriod, slowPeriod, signalPeriod, Plot.wrapQuotes(macdSeriesType), Plot.wrapQuotes(signalSeriesType), Plot.wrapQuotes(histogramSeriesType)));
    }

    public Markers markerPalette() {
        return new Markers(this.jsBase + ".markerPalette()");
    }

    public Plot markerPalette(Markers value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".markerPalette(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Plot markerPalette(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".markerPalette(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot markerPalette(MarkerType value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".markerPalette(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Plot markerPalette(String[] value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".markerPalette(%s);", Plot.arrayToStringWrapQuotes(value)));
        return this;
    }

    @Override
    public void maxHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxHeight();");
    }

    @Override
    public Plot maxHeight(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxHeight(%s);", value));
        return this;
    }

    @Override
    public Plot maxHeight(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxHeight(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public void maxPointWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxPointWidth();");
    }

    public Plot maxPointWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxPointWidth(%s);", value));
        return this;
    }

    public Plot maxPointWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxPointWidth(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    @Override
    public void maxWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxWidth();");
    }

    @Override
    public Plot maxWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxWidth(%s);", value));
        return this;
    }

    @Override
    public Plot maxWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxWidth(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public MFI mfi(TableMapping mapping, Number period, StockSeriesType seriesType) {
        return new MFI(String.format(Locale.US, this.jsBase + ".mfi(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, seriesType != null ? seriesType.getJsBase() : null));
    }

    public MFI mfi(TableMapping mapping, Number period, String seriesType) {
        return new MFI(String.format(Locale.US, this.jsBase + ".mfi(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(seriesType)));
    }

    @Override
    public void minHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minHeight();");
    }

    @Override
    public Plot minHeight(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minHeight(%s);", value));
        return this;
    }

    @Override
    public Plot minHeight(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minHeight(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public void minPointLength() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minPointLength();");
    }

    public Plot minPointLength(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minPointLength(%s);", value));
        return this;
    }

    public Plot minPointLength(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minPointLength(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    @Override
    public void minWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minWidth();");
    }

    @Override
    public Plot minWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minWidth(%s);", value));
        return this;
    }

    @Override
    public Plot minWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minWidth(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public MMA mma(TableMapping mapping, Number period, StockSeriesType seriesType) {
        return new MMA(String.format(Locale.US, this.jsBase + ".mma(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, seriesType != null ? seriesType.getJsBase() : null));
    }

    public MMA mma(TableMapping mapping, Number period, String seriesType) {
        return new MMA(String.format(Locale.US, this.jsBase + ".mma(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(seriesType)));
    }

    public Momentum momentum(TableMapping mapping, Number period, StockSeriesType seriesType) {
        return new Momentum(String.format(Locale.US, this.jsBase + ".momentum(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, seriesType != null ? seriesType.getJsBase() : null));
    }

    public Momentum momentum(TableMapping mapping, Number period, String seriesType) {
        return new Momentum(String.format(Locale.US, this.jsBase + ".momentum(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(seriesType)));
    }

    public NoDataSettings noData() {
        return new NoDataSettings(this.jsBase + ".noData()");
    }

    public Plot noData(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".noData(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public OHLC ohlc(Table data) {
        return new OHLC(String.format(Locale.US, this.jsBase + ".ohlc(%s)", data != null ? data.getJsBase() : null));
    }

    public RangeColors palette() {
        return new RangeColors(this.jsBase + ".palette()");
    }

    public Plot palette(RangeColors value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".palette(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Plot palette(DistinctColors value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".palette(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Plot palette(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".palette(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot palette(String[] value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".palette(%s);", Plot.arrayToStringWrapQuotes(value)));
        return this;
    }

    public void pointWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".pointWidth();");
    }

    public Plot pointWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".pointWidth(%s);", value));
        return this;
    }

    public Plot pointWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".pointWidth(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public CurrentPriceIndicator priceIndicator(Number index) {
        return new CurrentPriceIndicator(String.format(Locale.US, this.jsBase + ".priceIndicator(%s)", index));
    }

    public Plot priceIndicator(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".priceIndicator(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot priceIndicator(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".priceIndicator(%s);", value));
        return this;
    }

    public Plot priceIndicator(Number index, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".priceIndicator(%s, %s);", index, Plot.wrapQuotes(value)));
        return this;
    }

    public Plot priceIndicator(Number index, Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".priceIndicator(%s, %s);", index, value));
        return this;
    }

    @Override
    public void print(PaperSize paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", paperSizeOrOptions != null ? paperSizeOrOptions.getJsBase() : null, landscape));
    }

    @Override
    public void print(String paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", Plot.wrapQuotes(paperSizeOrOptions), landscape));
    }

    public PSAR psar(TableMapping mapping, Number accelerationFactorStart, Number accelerationFactorIncrement, Number accelerationFactorMaximum, StockSeriesType seriesType) {
        return new PSAR(String.format(Locale.US, this.jsBase + ".psar(%s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, accelerationFactorStart, accelerationFactorIncrement, accelerationFactorMaximum, seriesType != null ? seriesType.getJsBase() : null));
    }

    public PSAR psar(TableMapping mapping, Number accelerationFactorStart, Number accelerationFactorIncrement, Number accelerationFactorMaximum, String seriesType) {
        return new PSAR(String.format(Locale.US, this.jsBase + ".psar(%s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, accelerationFactorStart, accelerationFactorIncrement, accelerationFactorMaximum, Plot.wrapQuotes(seriesType)));
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Plot.wrapQuotes(type)));
    }

    public Plot removeAllSeries() {
        APIlib.getInstance().addJSLine(this.jsBase + ".removeAllSeries();");
        return this;
    }

    public Plot removeSeries(Number id2) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeSeries(%s);", id2));
        return this;
    }

    public Plot removeSeries(String id2) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeSeries(%s);", Plot.wrapQuotes(id2)));
        return this;
    }

    public Plot removeSeriesAt(Number index) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeSeriesAt(%s);", index));
        return this;
    }

    @Override
    public void right() {
        APIlib.getInstance().addJSLine(this.jsBase + ".right();");
    }

    @Override
    public Plot right(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".right(%s);", value));
        return this;
    }

    @Override
    public Plot right(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".right(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public RoC roc(TableMapping mapping, Number period, StockSeriesType seriesType) {
        return new RoC(String.format(Locale.US, this.jsBase + ".roc(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, seriesType != null ? seriesType.getJsBase() : null));
    }

    public RoC roc(TableMapping mapping, Number period, String seriesType) {
        return new RoC(String.format(Locale.US, this.jsBase + ".roc(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(seriesType)));
    }

    public RSI rsi(TableMapping mapping, Number period, StockSeriesType seriesType) {
        return new RSI(String.format(Locale.US, this.jsBase + ".rsi(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, seriesType != null ? seriesType.getJsBase() : null));
    }

    public RSI rsi(TableMapping mapping, Number period, String seriesType) {
        return new RSI(String.format(Locale.US, this.jsBase + ".rsi(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(seriesType)));
    }

    public SMA sma(TableMapping mapping, Number period, StockSeriesType seriesType) {
        return new SMA(String.format(Locale.US, this.jsBase + ".sma(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, seriesType != null ? seriesType.getJsBase() : null));
    }

    public SMA sma(TableMapping mapping, Number period, String seriesType) {
        return new SMA(String.format(Locale.US, this.jsBase + ".sma(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(seriesType)));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, StockSeriesType kSeriesType, StockSeriesType dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, StockSeriesType kSeriesType, String dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType)));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, String kSeriesType, StockSeriesType dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, MovingAverageType dMAType, String kSeriesType, String dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, dMAType != null ? dMAType.getJsBase() : null, Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType)));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, StockSeriesType kSeriesType, StockSeriesType dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, StockSeriesType kSeriesType, String dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType)));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, String kSeriesType, StockSeriesType dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, MovingAverageType kMAType, String dMAType, String kSeriesType, String dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, kMAType != null ? kMAType.getJsBase() : null, Plot.wrapQuotes(dMAType), Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType)));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, StockSeriesType kSeriesType, StockSeriesType dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, StockSeriesType kSeriesType, String dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType)));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, String kSeriesType, StockSeriesType dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, MovingAverageType dMAType, String kSeriesType, String dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), dMAType != null ? dMAType.getJsBase() : null, Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType)));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, StockSeriesType kSeriesType, StockSeriesType dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), kSeriesType != null ? kSeriesType.getJsBase() : null, dSeriesType != null ? dSeriesType.getJsBase() : null));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, StockSeriesType kSeriesType, String dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), kSeriesType != null ? kSeriesType.getJsBase() : null, Plot.wrapQuotes(dSeriesType)));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, String kSeriesType, StockSeriesType dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), Plot.wrapQuotes(kSeriesType), dSeriesType != null ? dSeriesType.getJsBase() : null));
    }

    public Stochastic stochastic(TableMapping mapping, Number kPeriod, Number kMAPeriod, Number dPeriod, String kMAType, String dMAType, String kSeriesType, String dSeriesType) {
        return new Stochastic(String.format(Locale.US, this.jsBase + ".stochastic(%s, %s, %s, %s, %s, %s, %s, %s)", mapping != null ? mapping.getJsBase() : null, kPeriod, kMAPeriod, dPeriod, Plot.wrapQuotes(kMAType), Plot.wrapQuotes(dMAType), Plot.wrapQuotes(kSeriesType), Plot.wrapQuotes(dSeriesType)));
    }

    @Override
    public void top() {
        APIlib.getInstance().addJSLine(this.jsBase + ".top();");
    }

    @Override
    public Plot top(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".top(%s);", value));
        return this;
    }

    @Override
    public Plot top(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".top(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Plot.wrapQuotes(key)));
    }

    @Override
    public void width() {
        APIlib.getInstance().addJSLine(this.jsBase + ".width();");
    }

    @Override
    public Plot width(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".width(%s);", value));
        return this;
    }

    @Override
    public Plot width(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".width(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public WilliamsR williamsR(TableMapping mapping, Number period, StockSeriesType seriesType) {
        return new WilliamsR(String.format(Locale.US, this.jsBase + ".williamsR(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, seriesType != null ? seriesType.getJsBase() : null));
    }

    public WilliamsR williamsR(TableMapping mapping, Number period, String seriesType) {
        return new WilliamsR(String.format(Locale.US, this.jsBase + ".williamsR(%s, %s, %s)", mapping != null ? mapping.getJsBase() : null, period, Plot.wrapQuotes(seriesType)));
    }

    public StockDateTime xAxis() {
        return new StockDateTime(this.jsBase + ".xAxis()");
    }

    public Plot xAxis(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xAxis(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot xAxis(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xAxis(%s);", value));
        return this;
    }

    public Stock xGrid(Number index) {
        return new Stock(String.format(Locale.US, this.jsBase + ".xGrid(%s)", index));
    }

    public Plot xGrid(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xGrid(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot xGrid(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xGrid(%s);", value));
        return this;
    }

    public Plot xGrid(Number index, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xGrid(%s, %s);", index, Plot.wrapQuotes(value)));
        return this;
    }

    public Plot xGrid(Number index, Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xGrid(%s, %s);", index, value));
        return this;
    }

    public Stock xMinorGrid(Number index) {
        return new Stock(String.format(Locale.US, this.jsBase + ".xMinorGrid(%s)", index));
    }

    public Plot xMinorGrid(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xMinorGrid(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot xMinorGrid(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xMinorGrid(%s);", value));
        return this;
    }

    public Plot xMinorGrid(Number indexOrValue, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xMinorGrid(%s, %s);", indexOrValue, Plot.wrapQuotes(value)));
        return this;
    }

    public Plot xMinorGrid(Number indexOrValue, Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".xMinorGrid(%s, %s);", indexOrValue, value));
        return this;
    }

    public Linear yAxis(Number index) {
        return new Linear(String.format(Locale.US, this.jsBase + ".yAxis(%s)", index));
    }

    public Plot yAxis(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yAxis(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot yAxis(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yAxis(%s);", value));
        return this;
    }

    public Plot yAxis(Number index, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yAxis(%s, %s);", index, Plot.wrapQuotes(value)));
        return this;
    }

    public Plot yAxis(Number index, Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yAxis(%s, %s);", index, value));
        return this;
    }

    public Stock yGrid(Number index) {
        return new Stock(String.format(Locale.US, this.jsBase + ".yGrid(%s)", index));
    }

    public Plot yGrid(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yGrid(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot yGrid(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yGrid(%s);", value));
        return this;
    }

    public Plot yGrid(Number index, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yGrid(%s, %s);", index, Plot.wrapQuotes(value)));
        return this;
    }

    public Plot yGrid(Number index, Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yGrid(%s, %s);", index, value));
        return this;
    }

    public Stock yMinorGrid(Number index) {
        return new Stock(String.format(Locale.US, this.jsBase + ".yMinorGrid(%s)", index));
    }

    public Plot yMinorGrid(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yMinorGrid(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot yMinorGrid(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yMinorGrid(%s);", value));
        return this;
    }

    public Plot yMinorGrid(Number indexOrValue, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yMinorGrid(%s, %s);", indexOrValue, Plot.wrapQuotes(value)));
        return this;
    }

    public Plot yMinorGrid(Number indexOrValue, Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yMinorGrid(%s, %s);", indexOrValue, value));
        return this;
    }

    public ScatterBase yScale() {
        return new ScatterBase(this.jsBase + ".yScale()");
    }

    public Plot yScale(ScatterScaleTypes value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yScale(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Plot yScale(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yScale(%s);", Plot.wrapQuotes(value)));
        return this;
    }

    public Plot yScale(ScatterBase value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yScale(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public void zIndex() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zIndex();");
    }

    @Override
    public Plot zIndex(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zIndex(%s);", value));
        return this;
    }

    public Area area(View data) {
        return new Area(String.format(Locale.US, this.jsBase + ".area(%s)", data != null ? data.getJsBase() : null));
    }

    public Hilo hilo(TableMapping data) {
        return new Hilo(String.format(Locale.US, this.jsBase + ".hilo(%s)", data != null ? data.getJsBase() : null));
    }

    public OHLC ohlc(TableMapping data) {
        return new OHLC(String.format(Locale.US, this.jsBase + ".ohlc(%s)", data != null ? data.getJsBase() : null));
    }

    public Object yScale(Class scaleClass) {
        Object instance = null;
        try {
            instance = scaleClass.getDeclaredConstructor(String.class).newInstance(this.jsBase + ".yScale()");
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return instance;
    }
}

