package com.anychart.core.gantt.rendering;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.Base;

import java.util.Locale;

// class
/**
 * Custom drawing settings.<br/>
Two main methods in rendering settings are {api: anychart.core.gantt.rendering.Settings#drawer}drawer{api}
and {api:anychart.core.gantt.rendering.Settings#shapes}shapes{api}. The drawer method sets the drawing function.<br/>
The shapes method returns the map of shapes used for drawing. Also, shapes are used in the context of the drawing function (drawer()).<br/>
{api: anychart.core.gantt.rendering.Settings.ShapeConfig}ShapeConfig{api} is the configurations of shapes that are set
in the array using the shapes() method.
 */
public class Settings extends Base {

    protected Settings() {

    }

    public static Settings instantiate() {
        return new Settings("new anychart.core.gantt.rendering.settings()");
    }

    

    public Settings(String jsChart) {
        jsBase = "settings" + ++variableIndex;
        APIlib.getInstance().addJSLine(jsBase + " = " + jsChart + ";");
    }

    public String getJsBase() {
        return jsBase;
    }

    
    /**
     * Getter for custom drawing settings.
     */
    public void drawer() {
        APIlib.getInstance().addJSLine(jsBase + ".drawer();");
    }
    /**
     * Setter for custom drawing settings.
     */
    public com.anychart.core.gantt.rendering.Settings drawer(String drawerFunction) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, jsBase + ".drawer(%s);", wrapQuotes(drawerFunction)));

        return this;
    }
    /**
     * Removes all listeners from an object. You can also optionally remove listeners of some particular type.
     */
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, jsBase + ".removeAllListeners(%s);", wrapQuotes(type)));
    }
    /**
     * Getter for shapes of the custom drawing.
     */
    public void shapes() {
        APIlib.getInstance().addJSLine(jsBase + ".shapes();");
    }
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();

        js.append(jsBase).append(".listen('pointClick', function(e) {");

        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");

            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");

        ListenersInterface.getInstance().setOnClickListener(listener);

        APIlib.getInstance().addJSLine(js.toString());
    }
    /**
     * Removes an event listener which was added with listen() by the key returned by listen() or listenOnce().
     */
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, jsBase + ".unlistenByKey(%s);", wrapQuotes(key)));
    }

}