/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import android.text.TextUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class JsObject {
    protected StringBuilder js = new StringBuilder();
    protected static int variableIndex = 0;
    protected String jsBase;
    protected boolean isChain = false;
    protected static OnChange onChangeListener;
    protected static boolean isRendered;

    protected String generateJs() {
        return this.js.toString();
    }

    protected StringBuilder getJs() {
        return this.js;
    }

    protected JsObject() {
    }

    protected JsObject(String jsBase) {
        this.jsBase = jsBase;
    }

    protected void setOnChangeListener(OnChange listener) {
        onChangeListener = listener;
    }

    protected String generateJsGetters() {
        return "";
    }

    protected static String wrapQuotes(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (JsObject.isJSONValid(value) || JsObject.isFunction(value)) {
            return value;
        }
        StringBuilder result = new StringBuilder(value.length() + 2);
        result.append("'").append(value).append("'");
        return result.toString();
    }

    private static boolean isJSONValid(String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException ex1) {
            try {
                new JSONArray(json);
            }
            catch (JSONException ex2) {
                return false;
            }
        }
        return true;
    }

    private static boolean isFunction(String function) {
        return function.length() > 10 && function.trim().toLowerCase().substring(0, 8).equals("function");
    }

    private static boolean isContainBracketOrBrace(String value) {
        return value.charAt(0) == '[' || value.charAt(0) == '{';
    }

    protected static String arrayToStringWrapQuotes(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (TextUtils.isDigitsOnly((CharSequence)array[i]) || JsObject.isContainBracketOrBrace(array[i])) continue;
            array[i] = JsObject.wrapQuotes(array[i]);
        }
        return Arrays.toString(array);
    }

    protected static String arrayToString(JsObject[] jsObjects) {
        if (jsObjects == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (int i = 0; i < jsObjects.length; ++i) {
            result.append(jsObjects[i].generateJs());
            if (i == jsObjects.length - 1) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    protected static String arrayToString(JsObjectInterface[] jsObjects) {
        if (jsObjects == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (int i = 0; i < jsObjects.length; ++i) {
            result.append(jsObjects[i].generateJs());
            if (i == jsObjects.length - 1) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    protected static String arrayToString(Object[] jsObjects) {
        if (jsObjects == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (int i = 0; i < jsObjects.length; ++i) {
            try {
                Method method = jsObjects[i].getClass().getMethod("generateJs", new Class[0]);
                result.append((String)method.invoke(jsObjects[i], new Object[0]));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (i == jsObjects.length - 1) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    static {
        isRendered = false;
    }

    static interface OnChange {
        public void onChange(String var1);
    }

    static interface JsObjectInterface {
        public String generateJs();
    }
}

