package com.anychart.anychart;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

// class
/**
 * Image primitive.
<b>Do not invoke constructor directly.</b> Use {@link anychart.graphics.vector.Stage#image} or
{@link anychart.graphics.vector.Layer#image} to make stage or layer bound image.<br/>
See also:<br/>
{@link anychart.graphics.vector.Stage#image},<br/>
{@link anychart.graphics.vector.Layer#image}
 */
public class Image extends Element {

    public Image() {
        js.setLength(0);
        js.append("var image").append(++variableIndex).append(" = anychart.graphics.vector.image();");
        jsBase = "image" + variableIndex;
    }

    protected Image(String jsBase) {
        js.setLength(0);
        this.jsBase = jsBase;
    }

    protected Image(StringBuilder js, String jsBase, boolean isChain) {
        this.js = js;
        this.jsBase = jsBase;
        this.isChain = isChain;
    }

    protected String getJsBase() {
        return jsBase;
    }

    
    private ImageAlign align;
    private List<Image> setAlign = new ArrayList<>();

    /**
     * Setter for the align.
     */
    public Image setAlign(ImageAlign align) {
        if (jsBase == null) {
            this.align = align;
        } else {
            this.align = align;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            
            js.append(String.format(Locale.US, ".align(%s)", ((align != null) ? align.generateJs() : "null")));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".align(%s)", ((align != null) ? align.generateJs() : "null")));
                js.setLength(0);
            }
        }
        return this;
    }
    private String generateJSsetAlign() {
        if (!setAlign.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Image item : setAlign) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private Fitting fittingMode;
    private String fittingMode1;
    private List<Image> setFittingMode = new ArrayList<>();

    /**
     * Setter for the fitting mode.
     */
    public Image setFittingMode(Fitting fittingMode) {
        if (jsBase == null) {
            this.fittingMode = null;
            this.fittingMode1 = null;
            
            this.fittingMode = fittingMode;
        } else {
            this.fittingMode = fittingMode;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            
            js.append(String.format(Locale.US, ".fittingMode(%s)", ((fittingMode != null) ? fittingMode.generateJs() : "null")));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".fittingMode(%s)", ((fittingMode != null) ? fittingMode.generateJs() : "null")));
                js.setLength(0);
            }
        }
        return this;
    }
    private String generateJSsetFittingMode() {
        if (!setFittingMode.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Image item : setFittingMode) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private List<Image> setFittingMode1 = new ArrayList<>();

    /**
     * Setter for the fitting mode.
     */
    public Image setFittingMode(String fittingMode1) {
        if (jsBase == null) {
            this.fittingMode = null;
            this.fittingMode1 = null;
            
            this.fittingMode1 = fittingMode1;
        } else {
            this.fittingMode1 = fittingMode1;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            
            js.append(String.format(Locale.US, ".fittingMode(%s)", wrapQuotes(fittingMode1)));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".fittingMode(%s)", wrapQuotes(fittingMode1)));
                js.setLength(0);
            }
        }
        return this;
    }
    private String generateJSsetFittingMode1() {
        if (!setFittingMode1.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Image item : setFittingMode1) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private Double height;
    private List<Image> setHeight = new ArrayList<>();

    /**
     * Setter for the image height.
     */
    public Image setHeight(Double height) {
        if (jsBase == null) {
            this.height = height;
        } else {
            this.height = height;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            
            js.append(String.format(Locale.US, ".height(%f)", height));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".height(%f)", height));
                js.setLength(0);
            }
        }
        return this;
    }
    private String generateJSsetHeight() {
        if (!setHeight.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Image item : setHeight) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private String src;
    private List<Image> setSrc = new ArrayList<>();

    /**
     * Setter for the image source.<br/>
Set null value for non-display image.
     */
    public Image setSrc(String src) {
        if (jsBase == null) {
            this.src = src;
        } else {
            this.src = src;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            
            js.append(String.format(Locale.US, ".src(%s)", wrapQuotes(src)));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".src(%s)", wrapQuotes(src)));
                js.setLength(0);
            }
        }
        return this;
    }
    private String generateJSsetSrc() {
        if (!setSrc.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Image item : setSrc) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private Double width;
    private List<Image> setWidth = new ArrayList<>();

    /**
     * Setter for the image width.
     */
    public Image setWidth(Double width) {
        if (jsBase == null) {
            this.width = width;
        } else {
            this.width = width;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            
            js.append(String.format(Locale.US, ".width(%f)", width));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".width(%f)", width));
                js.setLength(0);
            }
        }
        return this;
    }
    private String generateJSsetWidth() {
        if (!setWidth.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Image item : setWidth) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private Double x;
    private List<Image> setX = new ArrayList<>();

    /**
     * Setter for X coordinate.
     */
    public Image setX(Double x) {
        if (jsBase == null) {
            this.x = x;
        } else {
            this.x = x;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            
            js.append(String.format(Locale.US, ".x(%f)", x));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".x(%f)", x));
                js.setLength(0);
            }
        }
        return this;
    }
    private String generateJSsetX() {
        if (!setX.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Image item : setX) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private Double y;
    private List<Image> setY = new ArrayList<>();

    /**
     * Setter for the Y coordinate.
     */
    public Image setY(Double y) {
        if (jsBase == null) {
            this.y = y;
        } else {
            this.y = y;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            
            js.append(String.format(Locale.US, ".y(%f)", y));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".y(%f)", y));
                js.setLength(0);
            }
        }
        return this;
    }
    private String generateJSsetY() {
        if (!setY.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Image item : setY) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }


    protected String generateJsGetters() {
        StringBuilder jsGetters = new StringBuilder();

        jsGetters.append(super.generateJsGetters());

    

        return jsGetters.toString();
    }

    @Override
    protected String generateJs() {
        if (isChain) {
            js.append(";");
            isChain = false;
        }

        js.append(generateJsGetters());

        js.append(generateJSsetAlign());
        js.append(generateJSsetFittingMode());
        js.append(generateJSsetFittingMode1());
        js.append(generateJSsetHeight());
        js.append(generateJSsetSrc());
        js.append(generateJSsetWidth());
        js.append(generateJSsetX());
        js.append(generateJSsetY());
        

        String result = js.toString();
        js.setLength(0);
        return result;
    }

}