/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import com.anychart.anychart.CoreBase;
import com.anychart.anychart.ShapeConfig;
import java.util.Arrays;
import java.util.Locale;

public class RenderingSettings
extends CoreBase {
    private Boolean needsWidth;
    private Boolean needsZero;
    private ShapeConfig[] shapes;
    private String[] yValues;

    public RenderingSettings() {
    }

    protected RenderingSettings(String jsBase) {
        this.jsBase = jsBase;
    }

    protected RenderingSettings(StringBuilder js, String jsBase, boolean isChain) {
        this.js = js;
        this.jsBase = jsBase;
        this.isChain = isChain;
    }

    public RenderingSettings setNeedsWidth(Boolean needsWidth) {
        if (this.jsBase == null) {
            this.needsWidth = needsWidth;
        } else {
            this.needsWidth = needsWidth;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".needsWidth(%b)", needsWidth));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".needsWidth(%b)", needsWidth));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public RenderingSettings setNeedsZero(Boolean needsZero) {
        if (this.jsBase == null) {
            this.needsZero = needsZero;
        } else {
            this.needsZero = needsZero;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".needsZero(%b)", needsZero));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".needsZero(%b)", needsZero));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public RenderingSettings setShapes(ShapeConfig[] shapes) {
        if (this.jsBase == null) {
            this.shapes = shapes;
        } else {
            this.shapes = shapes;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".shapes(%s)", RenderingSettings.arrayToString(shapes)));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".shapes(%s)", RenderingSettings.arrayToString(shapes)));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public RenderingSettings setYValues(String[] yValues) {
        if (this.jsBase == null) {
            this.yValues = yValues;
        } else {
            this.yValues = yValues;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".yValues(%s)", Arrays.toString(yValues)));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".yValues(%s)", Arrays.toString(yValues)));
                this.js.setLength(0);
            }
        }
        return this;
    }

    private String generateJSneedsWidth() {
        if (this.needsWidth != null) {
            return String.format(Locale.US, "needsWidth: %b,", this.needsWidth);
        }
        return "";
    }

    private String generateJSneedsZero() {
        if (this.needsZero != null) {
            return String.format(Locale.US, "needsZero: %b,", this.needsZero);
        }
        return "";
    }

    private String generateJSshapes() {
        if (this.shapes != null) {
            return String.format(Locale.US, "shapes: %s,", RenderingSettings.arrayToString(this.shapes));
        }
        return "";
    }

    private String generateJSyValues() {
        if (this.yValues != null) {
            return String.format(Locale.US, "yValues: %s,", Arrays.toString(this.yValues));
        }
        return "";
    }

    @Override
    protected String generateJsGetters() {
        StringBuilder jsGetters = new StringBuilder();
        jsGetters.append(super.generateJsGetters());
        return jsGetters.toString();
    }

    @Override
    protected String generateJs() {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        if (this.jsBase == null) {
            this.js.append("{");
            this.js.append(this.generateJSneedsWidth());
            this.js.append(this.generateJSneedsZero());
            this.js.append(this.generateJSshapes());
            this.js.append(this.generateJSyValues());
            this.js.append("}");
        }
        this.js.append(this.generateJsGetters());
        String result = this.js.toString();
        this.js.setLength(0);
        return result;
    }
}

