/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import com.anychart.anychart.Interactivity;
import java.util.Locale;

public class MapInteractivity
extends Interactivity {
    private Boolean drag;
    private Boolean keyboardZoomAndMove;
    private Boolean zoomOnDoubleClick;
    private Boolean zoomOnMouseWheel;

    public MapInteractivity() {
    }

    protected MapInteractivity(String jsBase) {
        this.jsBase = jsBase;
    }

    protected MapInteractivity(StringBuilder js, String jsBase, boolean isChain) {
        this.js = js;
        this.jsBase = jsBase;
        this.isChain = isChain;
    }

    public MapInteractivity drag(Boolean drag) {
        if (this.jsBase == null) {
            this.drag = drag;
        } else {
            this.drag = drag;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".drag(%b)", drag));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".drag(%b)", drag));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public Interactivity keyboardZoomAndMove(Boolean keyboardZoomAndMove) {
        if (this.jsBase == null) {
            this.keyboardZoomAndMove = keyboardZoomAndMove;
        } else {
            this.keyboardZoomAndMove = keyboardZoomAndMove;
            if (this.isChain) {
                this.js.append(";");
                this.isChain = false;
            }
            this.js.append(String.format(Locale.US, this.jsBase + ".keyboardZoomAndMove(%b);", keyboardZoomAndMove));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, this.jsBase + ".keyboardZoomAndMove(%b)", keyboardZoomAndMove));
                this.js.setLength(0);
            }
        }
        return new Interactivity(this.jsBase);
    }

    public Interactivity zoomOnDoubleClick(Boolean zoomOnDoubleClick) {
        if (this.jsBase == null) {
            this.zoomOnDoubleClick = zoomOnDoubleClick;
        } else {
            this.zoomOnDoubleClick = zoomOnDoubleClick;
            if (this.isChain) {
                this.js.append(";");
                this.isChain = false;
            }
            this.js.append(String.format(Locale.US, this.jsBase + ".zoomOnDoubleClick(%b);", zoomOnDoubleClick));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, this.jsBase + ".zoomOnDoubleClick(%b)", zoomOnDoubleClick));
                this.js.setLength(0);
            }
        }
        return new Interactivity(this.jsBase);
    }

    public Interactivity zoomOnMouseWheel(Boolean zoomOnMouseWheel) {
        if (this.jsBase == null) {
            this.zoomOnMouseWheel = zoomOnMouseWheel;
        } else {
            this.zoomOnMouseWheel = zoomOnMouseWheel;
            if (this.isChain) {
                this.js.append(";");
                this.isChain = false;
            }
            this.js.append(String.format(Locale.US, this.jsBase + ".zoomOnMouseWheel(%b);", zoomOnMouseWheel));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, this.jsBase + ".zoomOnMouseWheel(%b)", zoomOnMouseWheel));
                this.js.setLength(0);
            }
        }
        return new Interactivity(this.jsBase);
    }

    private String generateJSdrag() {
        if (this.drag != null) {
            return String.format(Locale.US, "drag: %b,", this.drag);
        }
        return "";
    }

    private String generateJSkeyboardZoomAndMove() {
        if (this.keyboardZoomAndMove != null) {
            return String.format(Locale.US, "keyboardZoomAndMove: %b,", this.keyboardZoomAndMove);
        }
        return "";
    }

    private String generateJSzoomOnDoubleClick() {
        if (this.zoomOnDoubleClick != null) {
            return String.format(Locale.US, "zoomOnDoubleClick: %b,", this.zoomOnDoubleClick);
        }
        return "";
    }

    private String generateJSzoomOnMouseWheel() {
        if (this.zoomOnMouseWheel != null) {
            return String.format(Locale.US, "zoomOnMouseWheel: %b,", this.zoomOnMouseWheel);
        }
        return "";
    }

    @Override
    protected String generateJsGetters() {
        StringBuilder jsGetters = new StringBuilder();
        jsGetters.append(super.generateJsGetters());
        return jsGetters.toString();
    }

    @Override
    protected String generateJs() {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        if (this.jsBase == null) {
            this.js.append("{");
            this.js.append(this.generateJSdrag());
            this.js.append(this.generateJSkeyboardZoomAndMove());
            this.js.append(this.generateJSzoomOnDoubleClick());
            this.js.append(this.generateJSzoomOnMouseWheel());
            this.js.append("}");
        }
        this.js.append(this.generateJsGetters());
        String result = this.js.toString();
        this.js.setLength(0);
        return result;
    }
}

