/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import com.anychart.anychart.CoreBase;
import java.util.Arrays;
import java.util.Locale;

public class Grouping
extends CoreBase {
    private Boolean enabled;
    private Boolean forced;
    private String[] levels;
    private Double maxVisiblePoints;
    private Double minPixPerPoint;

    public Grouping() {
    }

    protected Grouping(String jsBase) {
        this.jsBase = jsBase;
    }

    protected Grouping(StringBuilder js, String jsBase, boolean isChain) {
        this.js = js;
        this.jsBase = jsBase;
        this.isChain = isChain;
    }

    public Grouping setEnabled(Boolean enabled) {
        if (this.jsBase == null) {
            this.enabled = enabled;
        } else {
            this.enabled = enabled;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".enabled(%b)", enabled));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".enabled(%b)", enabled));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public Grouping setForced(Boolean forced) {
        if (this.jsBase == null) {
            this.forced = forced;
        } else {
            this.forced = forced;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".forced(%b)", forced));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".forced(%b)", forced));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public Grouping setLevels(String[] levels) {
        if (this.jsBase == null) {
            this.levels = levels;
        } else {
            this.levels = levels;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".levels(%s)", Arrays.toString(levels)));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".levels(%s)", Arrays.toString(levels)));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public Grouping setMaxVisiblePoints(Double maxVisiblePoints) {
        if (this.jsBase == null) {
            this.maxVisiblePoints = maxVisiblePoints;
        } else {
            this.maxVisiblePoints = maxVisiblePoints;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".maxVisiblePoints(%f)", maxVisiblePoints));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".maxVisiblePoints(%f)", maxVisiblePoints));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public Grouping setMinPixPerPoint(Double minPixPerPoint) {
        if (this.jsBase == null) {
            this.minPixPerPoint = minPixPerPoint;
        } else {
            this.minPixPerPoint = minPixPerPoint;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".minPixPerPoint(%f)", minPixPerPoint));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".minPixPerPoint(%f)", minPixPerPoint));
                this.js.setLength(0);
            }
        }
        return this;
    }

    private String generateJSenabled() {
        if (this.enabled != null) {
            return String.format(Locale.US, "enabled: %b,", this.enabled);
        }
        return "";
    }

    private String generateJSforced() {
        if (this.forced != null) {
            return String.format(Locale.US, "forced: %b,", this.forced);
        }
        return "";
    }

    private String generateJSlevels() {
        if (this.levels != null) {
            return String.format(Locale.US, "levels: %s,", Arrays.toString(this.levels));
        }
        return "";
    }

    private String generateJSmaxVisiblePoints() {
        if (this.maxVisiblePoints != null) {
            return String.format(Locale.US, "maxVisiblePoints: %f,", this.maxVisiblePoints);
        }
        return "";
    }

    private String generateJSminPixPerPoint() {
        if (this.minPixPerPoint != null) {
            return String.format(Locale.US, "minPixPerPoint: %f,", this.minPixPerPoint);
        }
        return "";
    }

    @Override
    protected String generateJsGetters() {
        StringBuilder jsGetters = new StringBuilder();
        jsGetters.append(super.generateJsGetters());
        return jsGetters.toString();
    }

    @Override
    protected String generateJs() {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        if (this.jsBase == null) {
            this.js.append("{");
            this.js.append(this.generateJSenabled());
            this.js.append(this.generateJSforced());
            this.js.append(this.generateJSlevels());
            this.js.append(this.generateJSmaxVisiblePoints());
            this.js.append(this.generateJSminPixPerPoint());
            this.js.append("}");
        }
        this.js.append(this.generateJsGetters());
        String result = this.js.toString();
        this.js.setLength(0);
        return result;
    }
}

