/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import com.anychart.anychart.CoreBase;
import java.util.Arrays;
import java.util.Locale;

public class GeoTicks
extends CoreBase {
    private Double count;
    private Double minimumCount;
    private Double maximumCount;
    private Double interval;
    private String[] ticks;

    public GeoTicks() {
    }

    protected GeoTicks(String jsBase) {
        this.jsBase = jsBase;
    }

    protected GeoTicks(StringBuilder js, String jsBase, boolean isChain) {
        this.js = js;
        this.jsBase = jsBase;
        this.isChain = isChain;
    }

    public GeoTicks setCount(Double count) {
        if (this.jsBase == null) {
            this.count = count;
        } else {
            this.count = count;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".count(%f)", count));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".count(%f)", count));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public GeoTicks setCount(Double minimumCount, Double maximumCount) {
        if (this.jsBase == null) {
            this.minimumCount = minimumCount;
            this.maximumCount = maximumCount;
        } else {
            this.minimumCount = minimumCount;
            this.maximumCount = maximumCount;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".count(%f, %f)", minimumCount, maximumCount));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".count(%f, %f)", minimumCount, maximumCount));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public GeoTicks setInterval(Double interval) {
        if (this.jsBase == null) {
            this.interval = interval;
        } else {
            this.interval = interval;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".interval(%f)", interval));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".interval(%f)", interval));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public GeoTicks set(String[] ticks) {
        if (this.jsBase == null) {
            this.ticks = ticks;
        } else {
            this.ticks = ticks;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".set(%s)", Arrays.toString(ticks)));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".set(%s)", Arrays.toString(ticks)));
                this.js.setLength(0);
            }
        }
        return this;
    }

    private String generateJScount() {
        if (this.count != null) {
            return String.format(Locale.US, "count: %f,", this.count);
        }
        return "";
    }

    private String generateJSminimumCount() {
        if (this.minimumCount != null) {
            return String.format(Locale.US, "minimumCount: %f,", this.minimumCount);
        }
        return "";
    }

    private String generateJSmaximumCount() {
        if (this.maximumCount != null) {
            return String.format(Locale.US, "maximumCount: %f,", this.maximumCount);
        }
        return "";
    }

    private String generateJSinterval() {
        if (this.interval != null) {
            return String.format(Locale.US, "interval: %f,", this.interval);
        }
        return "";
    }

    private String generateJSticks() {
        if (this.ticks != null) {
            return String.format(Locale.US, "ticks: %s,", Arrays.toString(this.ticks));
        }
        return "";
    }

    @Override
    protected String generateJsGetters() {
        StringBuilder jsGetters = new StringBuilder();
        jsGetters.append(super.generateJsGetters());
        return jsGetters.toString();
    }

    @Override
    protected String generateJs() {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        if (this.jsBase == null) {
            this.js.append("{");
            this.js.append(this.generateJScount());
            this.js.append(this.generateJSminimumCount());
            this.js.append(this.generateJSmaximumCount());
            this.js.append(this.generateJSinterval());
            this.js.append(this.generateJSticks());
            this.js.append("}");
        }
        this.js.append(this.generateJsGetters());
        String result = this.js.toString();
        this.js.setLength(0);
        return result;
    }
}

