/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import com.anychart.anychart.CoreBase;
import java.util.Locale;

public class Animation
extends CoreBase {
    private Double duration;
    private Boolean enabled;

    public Animation() {
    }

    protected Animation(String jsBase) {
        this.jsBase = jsBase;
    }

    protected Animation(StringBuilder js, String jsBase, boolean isChain) {
        this.js = js;
        this.jsBase = jsBase;
        this.isChain = isChain;
    }

    public Animation setDuration(Double duration) {
        if (this.jsBase == null) {
            this.duration = duration;
        } else {
            this.duration = duration;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".duration(%f)", duration));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".duration(%f)", duration));
                this.js.setLength(0);
            }
        }
        return this;
    }

    public Animation setEnabled(Boolean enabled) {
        if (this.jsBase == null) {
            this.enabled = enabled;
        } else {
            this.enabled = enabled;
            if (!this.isChain) {
                this.js.append(this.jsBase);
                this.isChain = true;
            }
            this.js.append(String.format(Locale.US, ".enabled(%b)", enabled));
            if (this.isRendered) {
                this.onChangeListener.onChange(String.format(Locale.US, ".enabled(%b)", enabled));
                this.js.setLength(0);
            }
        }
        return this;
    }

    private String generateJSduration() {
        if (this.duration != null) {
            return String.format(Locale.US, "duration: %f,", this.duration);
        }
        return "";
    }

    private String generateJSenabled() {
        if (this.enabled != null) {
            return String.format(Locale.US, "enabled: %b,", this.enabled);
        }
        return "";
    }

    @Override
    protected String generateJsGetters() {
        StringBuilder jsGetters = new StringBuilder();
        jsGetters.append(super.generateJsGetters());
        return jsGetters.toString();
    }

    @Override
    protected String generateJs() {
        if (this.isChain) {
            this.js.append(";");
            this.isChain = false;
        }
        if (this.jsBase == null) {
            this.js.append("{");
            this.js.append(this.generateJSduration());
            this.js.append(this.generateJSenabled());
            this.js.append("}");
        }
        this.js.append(this.generateJsGetters());
        String result = this.js.toString();
        this.js.setLength(0);
        return result;
    }
}

