/*
 * Decompiled with CFR 0.152.
 */
package io.github.wax911.library.logger.core;

import androidx.annotation.VisibleForTesting;
import io.github.wax911.library.logger.contract.ILogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\"\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\"\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\"\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\"\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\"\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0017"}, d2={"Lio/github/wax911/library/logger/core/AbstractLogger;", "Lio/github/wax911/library/logger/contract/ILogger;", "level", "Lio/github/wax911/library/logger/contract/ILogger$Level;", "<init>", "(Lio/github/wax911/library/logger/contract/ILogger$Level;)V", "getLevel", "()Lio/github/wax911/library/logger/contract/ILogger$Level;", "setLevel", "isLoggable", "", "printLog", "", "tag", "", "message", "throwable", "", "v", "d", "i", "w", "e", "library_release"})
public abstract class AbstractLogger
implements ILogger {
    @NotNull
    private ILogger.Level level;

    public AbstractLogger(@NotNull ILogger.Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.level = level;
    }

    @Override
    @NotNull
    public ILogger.Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(@NotNull ILogger.Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"<set-?>");
        this.level = level;
    }

    @VisibleForTesting(otherwise=4)
    public boolean isLoggable(@NotNull ILogger.Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.getLevel().compareTo((Enum)level) <= 0;
    }

    private final void printLog(ILogger.Level level, String tag, String message, Throwable throwable) {
        if (this.isLoggable(level)) {
            this.log(level, tag, message, throwable);
        }
    }

    static /* synthetic */ void printLog$default(AbstractLogger abstractLogger, ILogger.Level level, String string, String string2, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printLog");
        }
        if ((n & 8) != 0) {
            throwable = null;
        }
        abstractLogger.printLog(level, string, string2, throwable);
    }

    public final void v(@NotNull String tag, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.printLog(ILogger.Level.VERBOSE, tag, message, throwable);
    }

    public static /* synthetic */ void v$default(AbstractLogger abstractLogger, String string, String string2, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: v");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        abstractLogger.v(string, string2, throwable);
    }

    public final void d(@NotNull String tag, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.printLog(ILogger.Level.DEBUG, tag, message, throwable);
    }

    public static /* synthetic */ void d$default(AbstractLogger abstractLogger, String string, String string2, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: d");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        abstractLogger.d(string, string2, throwable);
    }

    public final void i(@NotNull String tag, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.printLog(ILogger.Level.INFO, tag, message, throwable);
    }

    public static /* synthetic */ void i$default(AbstractLogger abstractLogger, String string, String string2, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: i");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        abstractLogger.i(string, string2, throwable);
    }

    public final void w(@NotNull String tag, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.printLog(ILogger.Level.WARNING, tag, message, throwable);
    }

    public static /* synthetic */ void w$default(AbstractLogger abstractLogger, String string, String string2, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: w");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        abstractLogger.w(string, string2, throwable);
    }

    public final void e(@NotNull String tag, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.printLog(ILogger.Level.ERROR, tag, message, throwable);
    }

    public static /* synthetic */ void e$default(AbstractLogger abstractLogger, String string, String string2, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: e");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        abstractLogger.e(string, string2, throwable);
    }
}

