/*
 * Decompiled with CFR 0.152.
 */
package io.github.wax911.library.converter;

import android.content.Context;
import android.content.res.AssetManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.wax911.library.annotation.processor.GraphProcessor;
import io.github.wax911.library.annotation.processor.contract.AbstractGraphProcessor;
import io.github.wax911.library.annotation.processor.plugin.AssetManagerDiscoveryPlugin;
import io.github.wax911.library.converter.request.GraphRequestConverter;
import io.github.wax911.library.converter.response.GraphResponseConverter;
import io.github.wax911.library.logger.DefaultGraphLogger;
import io.github.wax911.library.logger.contract.ILogger;
import io.github.wax911.library.util.LogLevel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.Retrofit;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J9\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016JI\u0010\u0017\u001a\u000e\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0018\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lio/github/wax911/library/converter/GraphConverter;", "Lretrofit2/Converter$Factory;", "graphProcessor", "Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;", "gson", "Lcom/google/gson/Gson;", "<init>", "(Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;Lcom/google/gson/Gson;)V", "getGraphProcessor", "()Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;", "getGson", "()Lcom/google/gson/Gson;", "responseBodyConverter", "Lretrofit2/Converter;", "Lokhttp3/ResponseBody;", "type", "Ljava/lang/reflect/Type;", "annotations", "", "", "retrofit", "Lretrofit2/Retrofit;", "(Ljava/lang/reflect/Type;[Ljava/lang/annotation/Annotation;Lretrofit2/Retrofit;)Lretrofit2/Converter;", "requestBodyConverter", "Lokhttp3/RequestBody;", "parameterAnnotations", "methodAnnotations", "(Ljava/lang/reflect/Type;[Ljava/lang/annotation/Annotation;[Ljava/lang/annotation/Annotation;Lretrofit2/Retrofit;)Lretrofit2/Converter;", "setLogLevel", "", "logLevel", "Lio/github/wax911/library/util/LogLevel;", "setMinimumLogLevel", "level", "Lio/github/wax911/library/logger/contract/ILogger$Level;", "Companion", "library_release"})
public class GraphConverter
extends Converter.Factory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractGraphProcessor graphProcessor;
    @NotNull
    private final Gson gson;
    @NotNull
    public static final String MIME_TYPE = "application/graphql";

    public GraphConverter(@NotNull AbstractGraphProcessor graphProcessor, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)graphProcessor, (String)"graphProcessor");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.graphProcessor = graphProcessor;
        this.gson = gson;
    }

    @NotNull
    protected final AbstractGraphProcessor getGraphProcessor() {
        return this.graphProcessor;
    }

    @NotNull
    protected final Gson getGson() {
        return this.gson;
    }

    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(@NotNull Type type, @NotNull Annotation[] annotations, @NotNull Retrofit retrofit) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        return type instanceof ResponseBody ? super.responseBodyConverter(type, annotations, retrofit) : (Converter)new GraphResponseConverter(type, this.gson);
    }

    @Nullable
    public Converter<?, RequestBody> requestBodyConverter(@NotNull Type type, @NotNull Annotation[] parameterAnnotations, @NotNull Annotation[] methodAnnotations, @NotNull Retrofit retrofit) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)parameterAnnotations, (String)"parameterAnnotations");
        Intrinsics.checkNotNullParameter((Object)methodAnnotations, (String)"methodAnnotations");
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        return new GraphRequestConverter(methodAnnotations, this.graphProcessor, this.gson);
    }

    @Deprecated(message="Use setMinimumLogLevel instead or alternatively setup your on logger on GraphConverter.create", replaceWith=@ReplaceWith(expression="setMinimumLogLevel(ILogger.Level)", imports={"io.github.wax911.library.logger.contract.ILogger.Level"}), level=DeprecationLevel.ERROR)
    public final void setLogLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        LogLevel logLevel2 = logLevel;
        ILogger.Level level = Intrinsics.areEqual((Object)logLevel2, (Object)LogLevel.Companion.getDEBUG()) ? ILogger.Level.DEBUG : (Intrinsics.areEqual((Object)logLevel2, (Object)LogLevel.Companion.getERROR()) ? ILogger.Level.ERROR : (Intrinsics.areEqual((Object)logLevel2, (Object)LogLevel.Companion.getINFO()) ? ILogger.Level.INFO : (Intrinsics.areEqual((Object)logLevel2, (Object)LogLevel.Companion.getVERBOSE()) ? ILogger.Level.VERBOSE : (Intrinsics.areEqual((Object)logLevel2, (Object)LogLevel.Companion.getWARN()) ? ILogger.Level.WARNING : ILogger.Level.NONE))));
        this.setMinimumLogLevel(level);
    }

    public final void setMinimumLogLevel(@NotNull ILogger.Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.graphProcessor.getLogger$library_release().setLevel(level);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/github/wax911/library/converter/GraphConverter$Companion;", "", "<init>", "()V", "MIME_TYPE", "", "create", "Lio/github/wax911/library/converter/GraphConverter;", "context", "Landroid/content/Context;", "level", "Lio/github/wax911/library/logger/contract/ILogger$Level;", "gson", "Lcom/google/gson/Gson;", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @NotNull
        public final GraphConverter create(@NotNull Context context, @NotNull ILogger.Level level) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            AssetManager assetManager = context.getAssets();
            Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"getAssets(...)");
            AbstractGraphProcessor abstractGraphProcessor = new GraphProcessor(new AssetManagerDiscoveryPlugin(assetManager, null, null, 6, null), new DefaultGraphLogger(level), null, 4, null);
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().serializeNulls().setLenient().create();
            Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
            return new GraphConverter(abstractGraphProcessor, gson);
        }

        public static /* synthetic */ GraphConverter create$default(Companion companion, Context context, ILogger.Level level, int n, Object object) {
            if ((n & 2) != 0) {
                level = ILogger.Level.INFO;
            }
            return companion.create(context, level);
        }

        @JvmOverloads
        @NotNull
        public final GraphConverter create(@NotNull Context context, @NotNull Gson gson, @NotNull ILogger.Level level) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            AssetManager assetManager = context.getAssets();
            Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"getAssets(...)");
            return new GraphConverter(new GraphProcessor(new AssetManagerDiscoveryPlugin(assetManager, null, null, 6, null), new DefaultGraphLogger(level), null, 4, null), gson);
        }

        public static /* synthetic */ GraphConverter create$default(Companion companion, Context context, Gson gson, ILogger.Level level, int n, Object object) {
            if ((n & 4) != 0) {
                level = ILogger.Level.INFO;
            }
            return companion.create(context, gson, level);
        }

        @JvmOverloads
        @NotNull
        public final GraphConverter create(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return io.github.wax911.library.converter.GraphConverter$Companion.create$default(this, context, null, 2, null);
        }

        @JvmOverloads
        @NotNull
        public final GraphConverter create(@NotNull Context context, @NotNull Gson gson) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
            return io.github.wax911.library.converter.GraphConverter$Companion.create$default(this, context, gson, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

