/*
 * Decompiled with CFR 0.152.
 */
package io.github.wax911.library.persisted.query;

import io.github.wax911.library.annotation.processor.contract.AbstractGraphProcessor;
import io.github.wax911.library.logger.core.AbstractLogger;
import io.github.wax911.library.persisted.contract.IAutomaticPersistedQuery;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/github/wax911/library/persisted/query/AutomaticPersistedQueryCalculator;", "Lio/github/wax911/library/persisted/contract/IAutomaticPersistedQuery;", "processor", "Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;", "logger", "Lio/github/wax911/library/logger/core/AbstractLogger;", "<init>", "(Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;Lio/github/wax911/library/logger/core/AbstractLogger;)V", "apqHashes", "", "", "hashOfQuery", "query", "createAndStoreHash", "queryName", "fileKey", "getOrCreateAPQHash", "Companion", "library_release"})
public final class AutomaticPersistedQueryCalculator
implements IAutomaticPersistedQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractGraphProcessor processor;
    @NotNull
    private final AbstractLogger logger;
    @NotNull
    private final Map<String, String> apqHashes;
    private static final String TAG = AutomaticPersistedQueryCalculator.class.getSimpleName();
    @NotNull
    private static final String ALGORITHM = "SHA-256";

    public AutomaticPersistedQueryCalculator(@NotNull AbstractGraphProcessor processor, @NotNull AbstractLogger logger) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.processor = processor;
        this.logger = logger;
        this.apqHashes = new HashMap();
    }

    public /* synthetic */ AutomaticPersistedQueryCalculator(AbstractGraphProcessor abstractGraphProcessor, AbstractLogger abstractLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            abstractLogger = abstractGraphProcessor.getLogger$library_release();
        }
        this(abstractGraphProcessor, abstractLogger);
    }

    private final String hashOfQuery(String query) {
        MessageDigest md = MessageDigest.getInstance(ALGORITHM);
        String string = query;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        md.update(byArray);
        byte[] digest = md.digest();
        String string2 = "%064x";
        Object[] objectArray = new Object[]{new BigInteger(1, digest)};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private final String createAndStoreHash(String queryName, String fileKey) {
        String string;
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        AbstractLogger.d$default(this.logger, string2, "Creating APQ hash for " + queryName, null, 4, null);
        if (this.processor.getGraphFiles().containsKey(fileKey)) {
            void var3_3;
            String hashOfQuery = this.hashOfQuery((String)MapsKt.getValue(this.processor.getGraphFiles(), (Object)fileKey));
            String string3 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
            AbstractLogger.v$default(this.logger, string3, "Created hash for query " + fileKey + " -> " + hashOfQuery, null, 4, null);
            this.apqHashes.put(fileKey, hashOfQuery);
            string = var3_3;
        } else {
            String string4 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"TAG");
            this.logger.e(string4, "Current size of discovered graphql files -> " + this.processor.getGraphFiles().size(), new Throwable("The request query " + fileKey + " could not be found!"));
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getOrCreateAPQHash(@NotNull String queryName) {
        Intrinsics.checkNotNullParameter((Object)queryName, (String)"queryName");
        String fileKey = queryName + this.processor.getDefaultExtension$library_release();
        return this.apqHashes.containsKey(fileKey) ? this.apqHashes.get(fileKey) : this.createAndStoreHash(queryName, fileKey);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/github/wax911/library/persisted/query/AutomaticPersistedQueryCalculator$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "ALGORITHM", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

