/*
 * Decompiled with CFR 0.152.
 */
package io.github.wax911.library.converter.request;

import com.google.gson.Gson;
import io.github.wax911.library.annotation.processor.contract.AbstractGraphProcessor;
import io.github.wax911.library.model.request.QueryContainer;
import io.github.wax911.library.model.request.QueryContainerBuilder;
import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 \u00162\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0016B'\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lio/github/wax911/library/converter/request/GraphRequestConverter;", "Lretrofit2/Converter;", "Lio/github/wax911/library/model/request/QueryContainerBuilder;", "Lokhttp3/RequestBody;", "methodAnnotations", "", "", "graphProcessor", "Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;", "gson", "Lcom/google/gson/Gson;", "<init>", "([Ljava/lang/annotation/Annotation;Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;Lcom/google/gson/Gson;)V", "getMethodAnnotations", "()[Ljava/lang/annotation/Annotation;", "[Ljava/lang/annotation/Annotation;", "getGraphProcessor", "()Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;", "getGson", "()Lcom/google/gson/Gson;", "convert", "containerBuilder", "Companion", "library_release"})
public class GraphRequestConverter
implements Converter<QueryContainerBuilder, RequestBody> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Annotation[] methodAnnotations;
    @NotNull
    private final AbstractGraphProcessor graphProcessor;
    @NotNull
    private final Gson gson;
    @Nullable
    private static final MediaType MEDIA_TYPE = MediaType.Companion.parse("application/json");

    public GraphRequestConverter(@NotNull Annotation[] methodAnnotations, @NotNull AbstractGraphProcessor graphProcessor, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)methodAnnotations, (String)"methodAnnotations");
        Intrinsics.checkNotNullParameter((Object)graphProcessor, (String)"graphProcessor");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.methodAnnotations = methodAnnotations;
        this.graphProcessor = graphProcessor;
        this.gson = gson;
    }

    @NotNull
    protected final Annotation[] getMethodAnnotations() {
        return this.methodAnnotations;
    }

    @NotNull
    protected final AbstractGraphProcessor getGraphProcessor() {
        return this.graphProcessor;
    }

    @NotNull
    protected final Gson getGson() {
        return this.gson;
    }

    @NotNull
    public RequestBody convert(@NotNull QueryContainerBuilder containerBuilder) {
        Intrinsics.checkNotNullParameter((Object)containerBuilder, (String)"containerBuilder");
        String rawQuery = this.graphProcessor.getQuery(this.methodAnnotations);
        QueryContainer queryContainer = containerBuilder.setQuery(rawQuery).build();
        String queryJson = this.gson.toJson((Object)queryContainer);
        Intrinsics.checkNotNull((Object)queryJson);
        return RequestBody.Companion.create(queryJson, MEDIA_TYPE);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/wax911/library/converter/request/GraphRequestConverter$Companion;", "", "<init>", "()V", "MEDIA_TYPE", "Lokhttp3/MediaType;", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

