/*
 * Decompiled with CFR 0.152.
 */
package com.coder.ffmpeg.utils;

import android.annotation.SuppressLint;
import com.coder.ffmpeg.annotation.Direction;
import com.coder.ffmpeg.annotation.ImageFormat;
import com.coder.ffmpeg.annotation.Transpose;
import com.coder.ffmpeg.utils.CommandParams;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\bW\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\tJ)\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ)\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ=\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J9\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J1\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u0019J1\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u001aJ3\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\tJ)\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ9\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010!J=\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010 \u001a\u0004\u0018\u00010\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010#J9\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010!J9\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010!J)\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ9\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J)\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ9\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J)\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ)\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ3\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010/\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\tJ)\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u00101\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ)\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ5\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u00103\u001a\u0004\u0018\u00010\u00052\n\b\u0001\u00104\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\tJ1\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u00106\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u00107J9\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u00106\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001f\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010:J3\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010<\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\tJ;\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010>\u001a\u0004\u0018\u00010\u00052\b\u0010?\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010@\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010AJ3\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010>\u001a\u0004\u0018\u00010\u00052\b\u0010?\u001a\u0004\u0018\u00010\u00052\b\u0010@\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\tJ=\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010C\u001a\u0004\u0018\u00010\u00052\b\u0010D\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010E\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010FJC\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010H\u001a\u0004\u0018\u00010\u00052\b\u0010I\u001a\u0004\u0018\u00010\u00052\u0006\u0010J\u001a\u00020\u00102\u0006\u0010K\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010LJ)\u0010M\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ)\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ)\u0010O\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010P\u001a\u0004\u0018\u00010\u00052\b\u0010Q\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ1\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u00106\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u00107J9\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u00106\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J1\u0010S\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010T\u001a\u0004\u0018\u00010\u00052\u0006\u0010U\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u001aJ)\u0010V\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ3\u0010V\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010T\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\tJ)\u0010W\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ)\u0010X\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ9\u0010Y\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010!J1\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010[\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u00107JK\u0010\\\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010]\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u00104\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010^J3\u0010\\\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00052\b\u0010_\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u00104\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\tJ1\u0010`\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010a\u001a\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010bJ1\u0010c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010d\u001a\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010bJ)\u0010e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ)\u0010f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ)\u0010g\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ1\u0010h\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010[\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u00107J3\u0010i\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010j\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u00107J1\u0010k\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u00106\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u00107J9\u0010k\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u00106\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J)\u0010l\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ=\u0010m\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u00106\u001a\u00020\u00102\b\b\u0002\u00108\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006n"}, d2={"Lcom/coder/ffmpeg/utils/FFmpegUtils;", "", "()V", "addWaterMark", "", "", "srcFile", "waterMark", "targetFile", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "audio2Amr", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "audio2Fdkaac", "audio2Mp3lame", "audioFadeIn", "start", "", "duration", "(Ljava/lang/String;Ljava/lang/String;II)[Ljava/lang/String;", "audioFadeOut", "changeVolume", "audio", "reduce", "", "outPath", "(Ljava/lang/String;FLjava/lang/String;)[Ljava/lang/String;", "(Ljava/lang/String;ILjava/lang/String;)[Ljava/lang/String;", "concatAudio", "appendFile", "concatVideo", "inputFile", "cutAudio", "startTime", "(Ljava/lang/String;IILjava/lang/String;)[Ljava/lang/String;", "endTime", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "cutVideo", "cutVideo2", "decode2YUV", "decodeAudio", "sampleRate", "channel", "denoiseVideo", "encodeAudio", "extractAudio", "extractVideo", "frame2Image", "time", "hls2Video", "m3u8Index", "image2Video", "srcDir", "format", "imageScale", "width", "(Ljava/lang/String;Ljava/lang/String;I)[Ljava/lang/String;", "height", "makeMuteAudio", "(Ljava/lang/String;)[Ljava/lang/String;", "mixAudio", "mixFile", "mixAudioVideo", "videoFile", "audioFile", "muxFile", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)[Ljava/lang/String;", "multiVideo", "input1", "input2", "direction", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)[Ljava/lang/String;", "picInPicVideo", "inputFile1", "inputFile2", "x", "y", "(Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;)[Ljava/lang/String;", "reverseAudioVideo", "reverseVideo", "rtmp", "src", "url", "scale", "screenRecord", "size", "recordTime", "screenShot", "transformAudio", "transformVideo", "video2Gif", "video2HLS", "splitTime", "video2Image", "frameRate", "(Ljava/lang/String;IIILjava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "targetDir", "videoBright", "bright", "(Ljava/lang/String;Ljava/lang/String;F)[Ljava/lang/String;", "videoContrast", "contrast", "videoDouble", "videoDoubleDown", "videoDoubleUp", "videoHLS", "videoRotation", "transpose", "videoScale", "videoSpeed2", "yuv2H264", "ffmpeg_release"})
public final class FFmpegUtils {
    @NotNull
    public static final FFmpegUtils INSTANCE = new FFmpegUtils();

    private FFmpegUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String[] transformAudio(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append(targetFile).get();
    }

    @JvmStatic
    @SuppressLint(value={"DefaultLocale"})
    @NotNull
    public static final String[] cutAudio(@Nullable String srcFile, int startTime, int duration, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-vn").append("-c:a").append("copy").append("-ss").append(String.valueOf(startTime)).append("-t").append(String.valueOf(duration)).append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] cutAudio(@Nullable String srcFile, @Nullable String startTime, @Nullable String endTime, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-vn").append("-c:a").append("copy").append("-ss").append(String.valueOf(startTime)).append("-t").append(String.valueOf(endTime)).append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] concatAudio(@Nullable String srcFile, @Nullable String appendFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append("concat:" + srcFile + '|' + appendFile).append("-c:a").append("copy").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] mixAudio(@Nullable String srcFile, @Nullable String mixFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-i").append(mixFile).append("-filter_complex").append("amix=inputs=2:duration=shortest").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] changeVolume(@Nullable String audio, int reduce, @Nullable String outPath) {
        return new CommandParams().append("-i").append(audio).append("-af").append("volume=" + reduce + "dB").append(outPath).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] changeVolume(@Nullable String audio, float reduce, @Nullable String outPath) {
        return new CommandParams().append("-i").append(audio).append("-af").append("volume=" + reduce).append(outPath).get();
    }

    @JvmStatic
    @SuppressLint(value={"DefaultLocale"})
    @NotNull
    public static final String[] mixAudioVideo(@Nullable String videoFile, @Nullable String audioFile, int duration, @Nullable String muxFile) {
        return new CommandParams().append("-i").append(videoFile).append("-i").append(audioFile).append("-t").append(duration).append(muxFile).get();
    }

    @JvmStatic
    @SuppressLint(value={"DefaultLocale"})
    @NotNull
    public static final String[] mixAudioVideo(@Nullable String videoFile, @Nullable String audioFile, @Nullable String muxFile) {
        return new CommandParams().append("-i").append(videoFile).append("-i").append(audioFile).append("-c").append("copy").append(muxFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] extractAudio(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-c:a").append("copy").append("-vn").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] extractVideo(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-c:v").append("copy").append("-an").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] transformVideo(@Nullable String srcFile, @Nullable String targetFile) {
        String command = "ffmpeg -y -i %s -c:v copy -c:a copy %s";
        Object[] objectArray = new Object[]{srcFile, targetFile};
        String string = String.format(command, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
        command = string;
        String[] stringArray = new String[]{" "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)command, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return stringArray2;
    }

    @JvmStatic
    @SuppressLint(value={"DefaultLocale"})
    @NotNull
    public static final String[] cutVideo(@Nullable String srcFile, int startTime, int duration, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-ss").append(startTime).append("-t").append(duration).append("-c").append("copy").append(targetFile).get();
    }

    @JvmStatic
    @SuppressLint(value={"DefaultLocale"})
    @NotNull
    public static final String[] cutVideo2(@Nullable String srcFile, int startTime, int duration, @Nullable String targetFile) {
        return new CommandParams().append("-ss").append(startTime).append("-t").append(duration).append("-accurate_seek").append("-i").append(srcFile).append("-c").append("copy").append("-avoid_negative_ts").append("1").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] concatVideo(@Nullable String inputFile, @Nullable String targetFile) {
        return new CommandParams().append("-f").append("concat").append("-i").append(inputFile).append("-c").append("copy").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] screenShot(@Nullable String srcFile, @Nullable String size, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-f").append("image2").append("-t").append("0.001").append("-s").append(size).append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] screenShot(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-f").append("image2").append("-t").append("0.001").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] video2Image(@Nullable String inputFile, @Nullable String targetDir, @ImageFormat @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new CommandParams().append("-i").append(inputFile).append("-r").append("1").append("-f").append("image2").append(targetDir + "/%3d." + format).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] video2Image(@Nullable String inputFile, int startTime, int duration, int frameRate, @Nullable String targetFile, @ImageFormat @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new CommandParams().append("-i").append(inputFile).append("-ss").append(startTime).append("-t").append(duration).append("-r").append(frameRate).append(targetFile + "%3d." + format).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] addWaterMark(@Nullable String srcFile, @Nullable String waterMark, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-i").append(waterMark).append("-filter_complex").append("overlay=40:40").append("-c:v").append("libx264").append(targetFile).get();
    }

    @JvmStatic
    @SuppressLint(value={"DefaultLocale"})
    @NotNull
    public static final String[] video2Gif(@Nullable String srcFile, int startTime, int duration, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-ss").append(startTime).append("-t").append(duration).append("-f").append("gif").append(targetFile).get();
    }

    @JvmStatic
    @SuppressLint(value={"DefaultLocale"})
    @NotNull
    public static final String[] screenRecord(@Nullable String size, int recordTime, @Nullable String targetFile) {
        return new CommandParams().append("-c:v").append("mpeg4").append("-b").append("1000").append("-r").append("10").append("-g").append("300").append("-vd").append("x11:0,0").append("-s").append(size).append("-t").append(recordTime).append(targetFile).get();
    }

    @JvmStatic
    @SuppressLint(value={"DefaultLocale"})
    @NotNull
    public static final String[] image2Video(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-f").append("image2").append("-r").append("1").append("-i").append(srcFile + "img%d.jpg").append("c:v").append("mpeg4").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] image2Video(@Nullable String srcDir, @ImageFormat @Nullable String format, @Nullable String targetFile) {
        return new CommandParams().append("-f").append("image2").append("-r").append("1").append("-i").append(srcDir + "/%3d." + format).append("-c:v").append("mpeg4").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] decodeAudio(@Nullable String srcFile, @Nullable String targetFile, int sampleRate, int channel) {
        return new CommandParams().append("-i").append(srcFile).append("-c:a").append("pcm_s16le").append("-ar").append(sampleRate).append("-ac").append(channel).append("-f").append("s16le").append(targetFile).get();
    }

    @JvmStatic
    @SuppressLint(value={"DefaultLocale"})
    @NotNull
    public static final String[] encodeAudio(@Nullable String srcFile, @Nullable String targetFile, int sampleRate, int channel) {
        return new CommandParams().append("-f").append("s16le").append("-ar").append(sampleRate).append("-ac").append(channel).append("-c:a").append("pcm_s16le").append("-i").append(srcFile).append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] multiVideo(@Nullable String input1, @Nullable String input2, @Nullable String targetFile, @Direction int direction) {
        String tack = "hstack";
        if (direction == 2) {
            tack = "vstack";
        }
        return new CommandParams().append("-i").append(input1).append("-i").append(input2).append("-filter_complex").append(tack).append("-c:v").append("libx264").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] reverseVideo(@Nullable String inputFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(inputFile).append("-filter_complex").append("[0:v]reverse[v]").append("-map").append("[v]").append("-c:v").append("libx264").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] reverseAudioVideo(@Nullable String inputFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(inputFile).append("-filter_complex").append("[0:v]reverse[v];[0:a]reverse[a]").append("-map").append("[v]").append("-map").append("[a]").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] denoiseVideo(@Nullable String inputFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(inputFile).append("-nr").append("500").append("-c:v").append("libx264").append(targetFile).get();
    }

    @JvmStatic
    @SuppressLint(value={"DefaultLocale"})
    @NotNull
    public static final String[] picInPicVideo(@Nullable String inputFile1, @Nullable String inputFile2, int x, int y, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(inputFile1).append("-i").append(inputFile2).append("-filter_complex").append("overlay=" + x + ':' + y).append("-c:v").append("libx264").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] videoDoubleDown(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-vf").append("scale=iw/2:-1").append("-c:v").append("libx264").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] videoDouble(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-vf").append("scale=iw*2:-1").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] videoDoubleUp(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-vf").append("scale=iw*2:-1").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] videoScale(@Nullable String srcFile, @Nullable String targetFile, int width, int height) {
        return new CommandParams().append("-i").append(srcFile).append("-vf").append("scale=" + width + ':' + height).append("-c:v").append("libx264").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] videoScale(@Nullable String srcFile, @Nullable String targetFile, int width) {
        return new CommandParams().append("-i").append(srcFile).append("-vf").append("scale=" + width + ":-1").append("-c:v").append("libx264").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] imageScale(@Nullable String srcFile, @Nullable String targetFile, int width, int height) {
        return FFmpegUtils.scale(srcFile, targetFile, width, height);
    }

    @JvmStatic
    @NotNull
    public static final String[] imageScale(@Nullable String srcFile, @Nullable String targetFile, int width) {
        return FFmpegUtils.scale(srcFile, targetFile, width);
    }

    @JvmStatic
    @NotNull
    public static final String[] scale(@Nullable String srcFile, @Nullable String targetFile, int width, int height) {
        return new CommandParams().append("-i").append(srcFile).append("-vf").append("scale=" + width + ':' + height).append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] scale(@Nullable String srcFile, @Nullable String targetFile, int width) {
        return new CommandParams().append("-i").append(srcFile).append("-vf").append("scale=" + width + ":-1").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] videoSpeed2(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-filter_complex").append("[0:v]setpts=0.5*PTS[v];[0:a]atempo=2.0[a]").append("-map").append("[v]").append("-map").append("[a]").append("-c:v").append("libx264").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] decode2YUV(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-an").append("-c:v").append("rawvideo").append("-pixel_format").append("yuv420p").append(targetFile).get();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] yuv2H264(@Nullable String srcFile, @Nullable String targetFile, int width, int height) {
        return new CommandParams().append("-f").append("rawvideo").append("-pix_fmt").append("yuv420p").append("-s").append("" + width + 'x' + height).append("-r").append("30").append("-i").append(srcFile).append("-c:v").append("libx264").append("-f").append("rawvideo").append(targetFile).get();
    }

    public static /* synthetic */ String[] yuv2H264$default(String string, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 720;
        }
        if ((n3 & 8) != 0) {
            n2 = 1280;
        }
        return FFmpegUtils.yuv2H264(string, string2, n, n2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] audioFadeIn(@Nullable String srcFile, @Nullable String targetFile, int start, int duration) {
        return new CommandParams().append("-i").append(srcFile).append("-filter_complex").append("afade=t=in:ss=" + start + ":d=" + duration).append(targetFile).get();
    }

    public static /* synthetic */ String[] audioFadeIn$default(String string, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 5;
        }
        return FFmpegUtils.audioFadeIn(string, string2, n, n2);
    }

    @JvmStatic
    @NotNull
    public static final String[] audioFadeOut(@Nullable String srcFile, @Nullable String targetFile, int start, int duration) {
        return new CommandParams().append("-i").append(srcFile).append("-filter_complex").append("afade=t=out:st=" + start + ":d=" + duration).append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] videoBright(@Nullable String srcFile, @Nullable String targetFile, float bright) {
        return new CommandParams().append("-i").append(srcFile).append("-c:v").append("libx264").append("-b:v").append("800k").append("-c:a").append("libfdk_aac").append("-vf").append("eq=brightness=" + bright).append("-f").append("mp4").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] videoContrast(@Nullable String srcFile, @Nullable String targetFile, float contrast) {
        return new CommandParams().append("-i").append(srcFile).append("-c:v").append("libx264").append("-b:v").append("800k").append("-c:a").append("libfdk_aac").append("-vf").append("eq=contrast=" + contrast).append("-f").append("mp4").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] videoRotation(@Nullable String srcFile, @Nullable String targetFile, @Transpose int transpose) {
        return new CommandParams().append("-i").append(srcFile).append("-vf").append("transpose=" + transpose).append("-b:v").append("600k").append("-c:v").append("libx264").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] frame2Image(@Nullable String srcFile, @Nullable String targetFile, @Nullable String time) {
        return new CommandParams().append("-i").append(srcFile).append("-ss").append(time).append("-vframes").append("1").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] audio2Fdkaac(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-c:a").append("libfdk_aac").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] audio2Mp3lame(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-c:a").append("libmp3lame").append(targetFile).get();
    }

    @Deprecated(message="")
    @JvmStatic
    @NotNull
    public static final String[] videoHLS(@Nullable String srcFile, @Nullable String targetFile, int splitTime) {
        return new CommandParams().append("-i").append(srcFile).append("-c").append("copy").append("-bsf:v h264_mp4toannexb").append("-hls_time").append(splitTime).append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] video2HLS(@Nullable String srcFile, @Nullable String targetFile, int splitTime) {
        return new CommandParams().append("-i").append(srcFile).append("-c").append("copy").append("-bsf:v").append("h264_mp4toannexb").append("-hls_time").append(splitTime).append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] hls2Video(@Nullable String m3u8Index, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(m3u8Index).append("-c").append("copy").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] audio2Amr(@Nullable String srcFile, @Nullable String targetFile) {
        return new CommandParams().append("-i").append(srcFile).append("-c:a").append("libopencore_amrnb").append("-ar").append("8000").append("-ac").append("1").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] makeMuteAudio(@Nullable String targetFile) {
        return new CommandParams().append("-f").append("lavfi").append("-t").append("10").append("-i").append("anullsrc").append(targetFile).get();
    }

    @JvmStatic
    @NotNull
    public static final String[] rtmp(@Nullable String src, @Nullable String url) {
        return new CommandParams().append("-re").append("-i").append(src).append("-f").append("flv").append(url).get();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] yuv2H264(@Nullable String srcFile, @Nullable String targetFile, int width) {
        return FFmpegUtils.yuv2H264$default(srcFile, targetFile, width, 0, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] yuv2H264(@Nullable String srcFile, @Nullable String targetFile) {
        return FFmpegUtils.yuv2H264$default(srcFile, targetFile, 0, 0, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] audioFadeIn(@Nullable String srcFile, @Nullable String targetFile, int start) {
        return FFmpegUtils.audioFadeIn$default(srcFile, targetFile, start, 0, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] audioFadeIn(@Nullable String srcFile, @Nullable String targetFile) {
        return FFmpegUtils.audioFadeIn$default(srcFile, targetFile, 0, 0, 12, null);
    }
}

