/*
 * Decompiled with CFR 0.152.
 */
package com.coder.ffmpeg.jni;

import android.content.Context;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/coder/ffmpeg/jni/FFmpegConfig;", "", "()V", "Companion", "ffmpeg_release"})
public final class FFmpegConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);

    static {
        System.loadLibrary("ffmpeg-org");
        System.loadLibrary("ffmpeg-command");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086 J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\tJ*\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0011J0\u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0011J\u0019\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0082 \u00a8\u0006\u0018"}, d2={"Lcom/coder/ffmpeg/jni/FFmpegConfig$Companion;", "", "()V", "setDebug", "", "debug", "", "setFontConfigFile", "configFile", "", "setFontConfigPath", "configPath", "setFontDir", "context", "Landroid/content/Context;", "fontDir", "fontNameMapping", "", "setFontDirList", "fontDirList", "", "setNativeEnv", "name", "value", "ffmpeg_release"})
    public static final class Companion {
        private Companion() {
        }

        private final native void setNativeEnv(String var1, String var2);

        public final native void setDebug(boolean var1);

        public final void setFontConfigPath(@NotNull String configPath) {
            Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
            this.setNativeEnv("FONTCONFIG_PATH", configPath);
        }

        public final void setFontConfigFile(@NotNull String configFile) {
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            this.setNativeEnv("FONTCONFIG_FILE", configFile);
        }

        public final void setFontDir(@NotNull Context context, @NotNull String fontDir, @NotNull Map<String, String> fontNameMapping) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fontDir, (String)"fontDir");
            Intrinsics.checkNotNullParameter(fontNameMapping, (String)"fontNameMapping");
            List<String> list = Collections.singletonList(fontDir);
            Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(fontDir)");
            this.setFontDirList(context, list, fontNameMapping);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setFontDirList(@NotNull Context context, @NotNull List<String> fontDirList, @NotNull Map<String, String> fontNameMapping) {
            File fontConfigFile;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(fontDirList, (String)"fontDirList");
            Intrinsics.checkNotNullParameter(fontNameMapping, (String)"fontNameMapping");
            int validFontNameMappingCount = 0;
            File cacheDir = context.getCacheDir();
            File fontConfigDir = new File(cacheDir, "fontconfig");
            if (!fontConfigDir.exists()) {
                fontConfigDir.mkdirs();
            }
            if ((fontConfigFile = new File(fontConfigDir, "fonts.conf")).exists() && fontConfigFile.isFile()) {
                fontConfigFile.delete();
            }
            fontConfigFile.createNewFile();
            StringBuilder fontNameMappingBlock = new StringBuilder();
            if (!fontNameMapping.isEmpty()) {
                for (Map.Entry<String, String> entry : fontNameMapping.entrySet()) {
                    String fontName = entry.getKey();
                    String mappedFontName = entry.getValue();
                    if (!(((CharSequence)((Object)StringsKt.trim((CharSequence)fontName)).toString()).length() > 0) || !(((CharSequence)((Object)StringsKt.trim((CharSequence)mappedFontName)).toString()).length() > 0)) continue;
                    fontNameMappingBlock.append("    <match target=\"pattern\">\n");
                    fontNameMappingBlock.append("        <test qual=\"any\" name=\"family\">\n");
                    String string = "            <string>%s</string>\n";
                    Object[] objectArray = new Object[]{fontName};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    fontNameMappingBlock.append(string2);
                    fontNameMappingBlock.append("        </test>\n");
                    fontNameMappingBlock.append("        <edit name=\"family\" mode=\"assign\" binding=\"same\">\n");
                    string = "            <string>%s</string>\n";
                    objectArray = new Object[]{mappedFontName};
                    String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                    fontNameMappingBlock.append(string3);
                    fontNameMappingBlock.append("        </edit>\n");
                    fontNameMappingBlock.append("    </match>\n");
                    ++validFontNameMappingCount;
                }
            }
            StringBuilder fontConfigBuilder = new StringBuilder();
            fontConfigBuilder.append("<?xml version=\"1.0\"?>\n");
            fontConfigBuilder.append("<!DOCTYPE fontconfig SYSTEM \"fonts.dtd\">\n");
            fontConfigBuilder.append("<fontconfig>\n");
            fontConfigBuilder.append("    <dir prefix=\"cwd\">.</dir>\n");
            for (String fontDirectoryPath : fontDirList) {
                fontConfigBuilder.append("    <dir>");
                fontConfigBuilder.append(fontDirectoryPath);
                fontConfigBuilder.append("</dir>\n");
            }
            fontConfigBuilder.append((CharSequence)fontNameMappingBlock);
            fontConfigBuilder.append("</fontconfig>\n");
            AtomicReference<FileOutputStream> atomicReference = new AtomicReference<FileOutputStream>();
            try {
                FileOutputStream outputStream = new FileOutputStream(fontConfigFile);
                atomicReference.set(outputStream);
                String string = fontConfigBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fontConfigBuilder.toString()");
                String string4 = string;
                byte[] byArray = string4.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                outputStream.write(byArray);
                outputStream.flush();
                String string5 = fontConfigDir.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"fontConfigDir.absolutePath");
                this.setFontConfigPath(string5);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                ((FileOutputStream)atomicReference.get()).close();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

