/*
 * Decompiled with CFR 0.152.
 */
package com.amity.seu.magicfilter.base.gpuimage;

import android.opengl.GLES20;
import com.amity.seu.magicfilter.base.gpuimage.GPUImageFilter;
import com.amity.seu.magicfilter.utils.MagicFilterType;
import net.ossrs.yasea.R;

public class GPUImageHueFilter
extends GPUImageFilter {
    private float mHue;
    private int mHueLocation;

    public GPUImageHueFilter() {
        this(0.0f);
    }

    public GPUImageHueFilter(float hue) {
        super(MagicFilterType.HUE, R.raw.hue);
        this.mHue = hue;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mHueLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"hueAdjust");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setHue(this.mHue);
    }

    public void setHue(float hue) {
        this.mHue = hue;
        float hueAdjust = this.mHue % 360.0f * (float)Math.PI / 180.0f;
        this.setFloat(this.mHueLocation, hueAdjust);
    }
}

