/*
 * Decompiled with CFR 0.152.
 */
package com.amity.seu.magicfilter.base;

import android.content.Context;
import android.opengl.GLES20;
import com.amity.seu.magicfilter.base.gpuimage.GPUImageFilter;
import java.nio.FloatBuffer;
import java.util.List;

public class MagicBaseGroupFilter
extends GPUImageFilter {
    private static int[] frameBuffers = null;
    private static int[] frameBufferTextures = null;
    private int frameWidth = -1;
    private int frameHeight = -1;
    protected List<GPUImageFilter> filters;

    public MagicBaseGroupFilter(List<GPUImageFilter> filters) {
        this.filters = filters;
    }

    @Override
    public void onDestroy() {
        for (GPUImageFilter filter : this.filters) {
            filter.destroy();
        }
        this.destroyFramebuffers();
    }

    @Override
    public void init(Context context) {
        for (GPUImageFilter filter : this.filters) {
            filter.init(context);
        }
    }

    @Override
    public void onInputSizeChanged(int width, int height) {
        int i;
        super.onInputSizeChanged(width, height);
        int size = this.filters.size();
        for (i = 0; i < size; ++i) {
            this.filters.get(i).onInputSizeChanged(width, height);
        }
        if (frameBuffers != null && (this.frameWidth != width || this.frameHeight != height || frameBuffers.length != size - 1)) {
            this.destroyFramebuffers();
            this.frameWidth = width;
            this.frameHeight = height;
        }
        if (frameBuffers == null) {
            frameBuffers = new int[size - 1];
            frameBufferTextures = new int[size - 1];
            for (i = 0; i < size - 1; ++i) {
                GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)i);
                GLES20.glGenTextures((int)1, (int[])frameBufferTextures, (int)i);
                GLES20.glBindTexture((int)3553, (int)frameBufferTextures[i]);
                GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
                GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
                GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
                GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
                GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
                GLES20.glBindFramebuffer((int)36160, (int)frameBuffers[i]);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)frameBufferTextures[i], (int)0);
                GLES20.glBindTexture((int)3553, (int)0);
                GLES20.glBindFramebuffer((int)36160, (int)0);
            }
        }
    }

    @Override
    public int onDrawFrame(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        if (frameBuffers == null || frameBufferTextures == null) {
            return -1;
        }
        int size = this.filters.size();
        int previousTexture = textureId;
        for (int i = 0; i < size; ++i) {
            boolean isNotLast;
            GPUImageFilter filter = this.filters.get(i);
            boolean bl = isNotLast = i < size - 1;
            if (isNotLast) {
                GLES20.glViewport((int)0, (int)0, (int)this.mInputWidth, (int)this.mInputHeight);
                GLES20.glBindFramebuffer((int)36160, (int)frameBuffers[i]);
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                filter.onDrawFrame(previousTexture, this.mGLCubeBuffer, this.mGLTextureBuffer);
                GLES20.glBindFramebuffer((int)36160, (int)0);
                previousTexture = frameBufferTextures[i];
                continue;
            }
            GLES20.glViewport((int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight);
            filter.onDrawFrame(previousTexture, cubeBuffer, textureBuffer);
        }
        return 1;
    }

    @Override
    public int onDrawFrame(int textureId) {
        if (frameBuffers == null || frameBufferTextures == null) {
            return -1;
        }
        int size = this.filters.size();
        int previousTexture = textureId;
        for (int i = 0; i < size; ++i) {
            boolean isNotLast;
            GPUImageFilter filter = this.filters.get(i);
            boolean bl = isNotLast = i < size - 1;
            if (isNotLast) {
                GLES20.glBindFramebuffer((int)36160, (int)frameBuffers[i]);
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                filter.onDrawFrame(previousTexture, this.mGLCubeBuffer, this.mGLTextureBuffer);
                GLES20.glBindFramebuffer((int)36160, (int)0);
                previousTexture = frameBufferTextures[i];
                continue;
            }
            filter.onDrawFrame(previousTexture, this.mGLCubeBuffer, this.mGLTextureBuffer);
        }
        return 1;
    }

    private void destroyFramebuffers() {
        if (frameBufferTextures != null) {
            GLES20.glDeleteTextures((int)frameBufferTextures.length, (int[])frameBufferTextures, (int)0);
            frameBufferTextures = null;
        }
        if (frameBuffers != null) {
            GLES20.glDeleteFramebuffers((int)frameBuffers.length, (int[])frameBuffers, (int)0);
            frameBuffers = null;
        }
    }

    public int getSize() {
        return this.filters.size();
    }
}

