/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.boxes;

import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.UUID;

public abstract class AbstractTrackEncryptionBox
extends AbstractFullBox {
    int defaultAlgorithmId;
    int defaultIvSize;
    byte[] default_KID;

    protected AbstractTrackEncryptionBox(String type) {
        super(type);
    }

    public int getDefaultAlgorithmId() {
        return this.defaultAlgorithmId;
    }

    public void setDefaultAlgorithmId(int defaultAlgorithmId) {
        this.defaultAlgorithmId = defaultAlgorithmId;
    }

    public int getDefaultIvSize() {
        return this.defaultIvSize;
    }

    public void setDefaultIvSize(int defaultIvSize) {
        this.defaultIvSize = defaultIvSize;
    }

    public String getDefault_KID() {
        ByteBuffer b = ByteBuffer.wrap(this.default_KID);
        b.order(ByteOrder.BIG_ENDIAN);
        return new UUID(b.getLong(), b.getLong()).toString();
    }

    public void setDefault_KID(byte[] default_KID) {
        this.default_KID = default_KID;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.defaultAlgorithmId = IsoTypeReader.readUInt24(content);
        this.defaultIvSize = IsoTypeReader.readUInt8(content);
        this.default_KID = new byte[16];
        content.get(this.default_KID);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt24(byteBuffer, this.defaultAlgorithmId);
        IsoTypeWriter.writeUInt8(byteBuffer, this.defaultIvSize);
        byteBuffer.put(this.default_KID);
    }

    @Override
    protected long getContentSize() {
        return 24L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTrackEncryptionBox that = (AbstractTrackEncryptionBox)o;
        if (this.defaultAlgorithmId != that.defaultAlgorithmId) {
            return false;
        }
        if (this.defaultIvSize != that.defaultIvSize) {
            return false;
        }
        return Arrays.equals(this.default_KID, that.default_KID);
    }

    public int hashCode() {
        int result = this.defaultAlgorithmId;
        result = 31 * result + this.defaultIvSize;
        result = 31 * result + (this.default_KID != null ? Arrays.hashCode(this.default_KID) : 0);
        return result;
    }
}

