/*
 * Decompiled with CFR 0.152.
 */
package com.amity.coremedia.iso.boxes;

import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.coremedia.iso.boxes.AbstractMediaHeaderBox;
import java.nio.ByteBuffer;

public class VideoMediaHeaderBox
extends AbstractMediaHeaderBox {
    private int graphicsmode = 0;
    private int[] opcolor = new int[]{0, 0, 0};
    public static final String TYPE = "vmhd";

    public VideoMediaHeaderBox() {
        super(TYPE);
        this.setFlags(1);
    }

    public int getGraphicsmode() {
        return this.graphicsmode;
    }

    public int[] getOpcolor() {
        return this.opcolor;
    }

    @Override
    protected long getContentSize() {
        return 12L;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.graphicsmode = IsoTypeReader.readUInt16(content);
        this.opcolor = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.opcolor[i] = IsoTypeReader.readUInt16(content);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt16(byteBuffer, this.graphicsmode);
        for (int anOpcolor : this.opcolor) {
            IsoTypeWriter.writeUInt16(byteBuffer, anOpcolor);
        }
    }

    public String toString() {
        return "VideoMediaHeaderBox[graphicsmode=" + this.getGraphicsmode() + ";opcolor0=" + this.getOpcolor()[0] + ";opcolor1=" + this.getOpcolor()[1] + ";opcolor2=" + this.getOpcolor()[2] + "]";
    }

    public void setOpcolor(int[] opcolor) {
        this.opcolor = opcolor;
    }

    public void setGraphicsmode(int graphicsmode) {
        this.graphicsmode = graphicsmode;
    }
}

