/*
 * Decompiled with CFR 0.152.
 */
package com.amity.coremedia.iso.boxes;

import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.googlecode.mp4parser.AbstractFullBox;
import com.amity.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositionTimeToSample
extends AbstractFullBox {
    public static final String TYPE = "ctts";
    List<Entry> entries = Collections.emptyList();

    public CompositionTimeToSample() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 8 + 8 * this.entries.size();
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        int numberOfEntries = CastUtils.l2i(IsoTypeReader.readUInt32(content));
        this.entries = new ArrayList<Entry>(numberOfEntries);
        for (int i = 0; i < numberOfEntries; ++i) {
            Entry e = new Entry(CastUtils.l2i(IsoTypeReader.readUInt32(content)), content.getInt());
            this.entries.add(e);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getCount());
            byteBuffer.putInt(entry.getOffset());
        }
    }

    public static int[] blowupCompositionTimes(List<Entry> entries) {
        long numOfSamples = 0L;
        for (Entry entry : entries) {
            numOfSamples += (long)entry.getCount();
        }
        assert (numOfSamples <= Integer.MAX_VALUE);
        int[] decodingTime = new int[(int)numOfSamples];
        int current = 0;
        for (Entry entry : entries) {
            for (int i = 0; i < entry.getCount(); ++i) {
                decodingTime[current++] = entry.getOffset();
            }
        }
        return decodingTime;
    }

    public static class Entry {
        int count;
        int offset;

        public Entry(int count, int offset) {
            this.count = count;
            this.offset = offset;
        }

        public int getCount() {
            return this.count;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public String toString() {
            return "Entry{count=" + this.count + ", offset=" + this.offset + '}';
        }
    }
}

