package com.amity.socialcloud.sdk.video

import android.content.res.Configuration
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution

class AmityStreamBroadcasterConfiguration private constructor(var orientation: Int, var resolution: AmityBroadcastResolution) {


    class Builder {

        private var orientation: Int = Configuration.ORIENTATION_PORTRAIT
        private var resolution: AmityBroadcastResolution = AmityBroadcastResolution.HD_720P

        fun setOrientation(orientation: Int): Builder {
            return apply { this.orientation = orientation }
        }

        fun setResolution(resolution: AmityBroadcastResolution): Builder {
            return apply { this.resolution = resolution }
        }

        fun build(): AmityStreamBroadcasterConfiguration {
            return AmityStreamBroadcasterConfiguration(orientation, resolution)
        }
    }


    companion object {
        val DEFAULT = AmityStreamBroadcasterConfiguration(Configuration.ORIENTATION_PORTRAIT, AmityBroadcastResolution.HD_720P)
    }
}