/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.authoring.tracks;

import com.amity.coremedia.iso.boxes.Box;
import com.amity.coremedia.iso.boxes.CompositionTimeToSample;
import com.amity.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.amity.coremedia.iso.boxes.SampleDescriptionBox;
import com.amity.coremedia.iso.boxes.SubSampleInformationBox;
import com.amity.coremedia.iso.boxes.TimeToSampleBox;
import com.amity.googlecode.mp4parser.authoring.Track;
import com.amity.googlecode.mp4parser.authoring.TrackMetaData;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SilenceTrackImpl
implements Track {
    Track source;
    List<ByteBuffer> samples = new LinkedList<ByteBuffer>();
    TimeToSampleBox.Entry entry;

    public SilenceTrackImpl(Track ofType, long ms) {
        this.source = ofType;
        if ("mp4a".equals(ofType.getSampleDescriptionBox().getSampleEntry().getType())) {
            long numFrames = this.getTrackMetaData().getTimescale() * ms / 1000L / 1024L;
            long standZeit = this.getTrackMetaData().getTimescale() * ms / numFrames / 1000L;
            this.entry = new TimeToSampleBox.Entry(numFrames, standZeit);
            while (numFrames-- > 0L) {
                this.samples.add((ByteBuffer)ByteBuffer.wrap(new byte[]{33, 16, 4, 96, -116, 28}).rewind());
            }
        } else {
            throw new RuntimeException("Tracks of type " + ofType.getClass().getSimpleName() + " are not supported");
        }
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.source.getSampleDescriptionBox();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return Collections.singletonList(this.entry);
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.source.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    @Override
    public boolean isInMovie() {
        return this.source.isInMovie();
    }

    @Override
    public boolean isInPreview() {
        return this.source.isInPreview();
    }

    @Override
    public boolean isInPoster() {
        return this.source.isInPoster();
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.samples;
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.source.getMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }
}

