/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.authoring;

import com.amity.googlecode.mp4parser.authoring.Track;
import java.util.LinkedList;
import java.util.List;

public class Movie {
    List<Track> tracks = new LinkedList<Track>();

    public List<Track> getTracks() {
        return this.tracks;
    }

    public void setTracks(List<Track> tracks) {
        this.tracks = tracks;
    }

    public void addTrack(Track nuTrack) {
        if (this.getTrackByTrackId(nuTrack.getTrackMetaData().getTrackId()) != null) {
            nuTrack.getTrackMetaData().setTrackId(this.getNextTrackId());
        }
        this.tracks.add(nuTrack);
    }

    public String toString() {
        String s = "Movie{ ";
        for (Track track : this.tracks) {
            s = s + "track_" + track.getTrackMetaData().getTrackId() + " (" + track.getHandler() + ") ";
        }
        s = s + '}';
        return s;
    }

    public long getNextTrackId() {
        long nextTrackId = 0L;
        for (Track track : this.tracks) {
            nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        return ++nextTrackId;
    }

    public Track getTrackByTrackId(long trackId) {
        for (Track track : this.tracks) {
            if (track.getTrackMetaData().getTrackId() != trackId) continue;
            return track;
        }
        return null;
    }

    public long getTimescale() {
        long timescale = this.getTracks().iterator().next().getTrackMetaData().getTimescale();
        for (Track track : this.getTracks()) {
            timescale = Movie.gcd(track.getTrackMetaData().getTimescale(), timescale);
        }
        return timescale;
    }

    public static long gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return Movie.gcd(b, a % b);
    }
}

