/*
 * Decompiled with CFR 0.152.
 */
package net.ossrs.yasea;

import android.os.Handler;
import android.os.Message;
import java.lang.ref.WeakReference;

public class SrsEncodeHandler
extends Handler {
    private static final int MSG_ENCODE_NETWORK_WEAK = 0;
    private static final int MSG_ENCODE_NETWORK_RESUME = 1;
    private static final int MSG_ENCODE_ILLEGAL_ARGUMENT_EXCEPTION = 2;
    private WeakReference<SrsEncodeListener> mWeakListener;

    public SrsEncodeHandler(SrsEncodeListener listener) {
        this.mWeakListener = new WeakReference<SrsEncodeListener>(listener);
    }

    public void notifyNetworkWeak() {
        this.sendEmptyMessage(0);
    }

    public void notifyNetworkResume() {
        this.sendEmptyMessage(1);
    }

    public void notifyEncodeIllegalArgumentException(IllegalArgumentException e) {
        this.obtainMessage(2, e).sendToTarget();
    }

    public void handleMessage(Message msg) {
        SrsEncodeListener listener = (SrsEncodeListener)this.mWeakListener.get();
        if (listener == null) {
            return;
        }
        switch (msg.what) {
            case 0: {
                listener.onNetworkWeak();
                break;
            }
            case 1: {
                listener.onNetworkResume();
                break;
            }
            case 2: {
                listener.onEncodeIllegalArgumentException((IllegalArgumentException)msg.obj);
            }
            default: {
                throw new RuntimeException("unknown msg " + msg.what);
            }
        }
    }

    public static interface SrsEncodeListener {
        public void onNetworkWeak();

        public void onNetworkResume();

        public void onEncodeIllegalArgumentException(IllegalArgumentException var1);
    }
}

