/*
 * Decompiled with CFR 0.152.
 */
package com.amity.github.faucamp.simplertmp.packets;

import com.amity.github.faucamp.simplertmp.Crypto;
import com.amity.github.faucamp.simplertmp.Util;
import com.amity.socialcloud.sdk.log.AmityLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public final class Handshake {
    private static final String TAG = "Handshake";
    private byte[] s1;
    private static final int PROTOCOL_VERSION = 3;
    private static final int HANDSHAKE_SIZE = 1536;
    private static final int SHA256_DIGEST_SIZE = 32;
    private static final int DIGEST_OFFSET_INDICATOR_POS = 772;
    private static final byte[] GENUINE_FP_KEY = new byte[]{71, 101, 110, 117, 105, 110, 101, 32, 65, 100, 111, 98, 101, 32, 70, 108, 97, 115, 104, 32, 80, 108, 97, 121, 101, 114, 32, 48, 48, 49, -16, -18, -62, 74, -128, 104, -66, -24, 46, 0, -48, -47, 2, -98, 126, 87, 110, -20, 93, 45, 41, -128, 111, -85, -109, -72, -26, 54, -49, -21, 49, -82};

    public final void writeC0(OutputStream out) throws IOException {
        AmityLog.INSTANCE.tag(TAG).d("writeC0", new Object[0]);
        out.write(3);
    }

    public final void readS0(InputStream in) throws IOException {
        AmityLog.INSTANCE.tag(TAG).d("readS0", new Object[0]);
        byte s0 = (byte)in.read();
        if (s0 != 3) {
            if (s0 == -1) {
                throw new IOException("InputStream closed");
            }
            throw new IOException("Invalid RTMP protocol version; expected 3, got " + s0);
        }
    }

    public final void writeC1(OutputStream out) throws IOException {
        AmityLog.INSTANCE.tag(TAG).d("writeC1", new Object[0]);
        AmityLog.INSTANCE.tag(TAG).d("writeC1(): Calculating digest offset", new Object[0]);
        Random random = new Random();
        int digestOffset = random.nextInt(720);
        int absoluteDigestOffset = digestOffset % 728 + 772 + 4;
        AmityLog.INSTANCE.tag(TAG).d("writeC1(): (real value of) digestOffset: " + digestOffset, new Object[0]);
        AmityLog.INSTANCE.tag(TAG).d("writeC1(): recalculated digestOffset: " + absoluteDigestOffset, new Object[0]);
        int remaining = digestOffset;
        byte[] digestOffsetBytes = new byte[4];
        for (int i = 3; i >= 0; --i) {
            if (remaining > 255) {
                digestOffsetBytes[i] = -1;
                remaining -= 255;
                continue;
            }
            digestOffsetBytes[i] = (byte)remaining;
            remaining -= remaining;
        }
        AmityLog.INSTANCE.tag(TAG).d("writeC1(): digestOffsetBytes: " + Util.toHexString(digestOffsetBytes), new Object[0]);
        byte[] partBeforeDigest = new byte[absoluteDigestOffset];
        AmityLog.INSTANCE.tag(TAG).d("partBeforeDigest(): size: " + partBeforeDigest.length, new Object[0]);
        random.nextBytes(partBeforeDigest);
        AmityLog.INSTANCE.tag(TAG).d("writeC1(): Writing timestamp and Flash Player version", new Object[0]);
        byte[] timeStamp = Util.unsignedInt32ToByteArray((int)(System.currentTimeMillis() / 1000L));
        System.arraycopy(timeStamp, 0, partBeforeDigest, 0, 4);
        System.arraycopy(new byte[]{-128, 0, 7, 2}, 0, partBeforeDigest, 4, 4);
        byte[] partAfterDigest = new byte[1536 - absoluteDigestOffset - 32];
        AmityLog.INSTANCE.tag(TAG).d("partAfterDigest(): size: " + partAfterDigest.length, new Object[0]);
        random.nextBytes(partAfterDigest);
        AmityLog.INSTANCE.tag(TAG).d("copying digest offset bytes in partBeforeDigest", new Object[0]);
        System.arraycopy(digestOffsetBytes, 0, partBeforeDigest, 772, 4);
        AmityLog.INSTANCE.tag(TAG).d("writeC1(): Calculating digest", new Object[0]);
        byte[] tempBuffer = new byte[1504];
        System.arraycopy(partBeforeDigest, 0, tempBuffer, 0, partBeforeDigest.length);
        System.arraycopy(partAfterDigest, 0, tempBuffer, partBeforeDigest.length, partAfterDigest.length);
        Crypto crypto = new Crypto();
        byte[] digest = crypto.calculateHmacSHA256(tempBuffer, GENUINE_FP_KEY, 30);
        AmityLog.INSTANCE.tag(TAG).d("writeC1(): writing C1 packet", new Object[0]);
        out.write(partBeforeDigest);
        out.write(digest);
        out.write(partAfterDigest);
    }

    public final void readS1(InputStream in) throws IOException {
        AmityLog.INSTANCE.tag(TAG).d("readS1", new Object[0]);
        this.s1 = new byte[1536];
        int totalBytesRead = 0;
        do {
            int read;
            if ((read = in.read(this.s1, totalBytesRead, 1536 - totalBytesRead)) == -1) continue;
            totalBytesRead += read;
        } while (totalBytesRead < 1536);
        if (totalBytesRead != 1536) {
            throw new IOException("Unexpected EOF while reading S1, expected 1536 bytes, but only read " + totalBytesRead + " bytes");
        }
        AmityLog.INSTANCE.tag(TAG).d("readS1(): S1 total bytes read OK", new Object[0]);
    }

    public final void writeC2(OutputStream out) throws IOException {
        AmityLog.INSTANCE.tag(TAG).d("writeC2", new Object[0]);
        if (this.s1 == null) {
            throw new IllegalStateException("C2 cannot be written without S1 being read first");
        }
        out.write(this.s1);
    }

    public final void readS2(InputStream in) throws IOException {
        int read;
        AmityLog.INSTANCE.tag(TAG).d("readS2", new Object[0]);
        byte[] sr_serverTime = new byte[4];
        byte[] s2_serverVersion = new byte[4];
        byte[] s2_rest = new byte[1528];
        int totalBytesRead = 0;
        do {
            if ((read = in.read(sr_serverTime, totalBytesRead, 4 - totalBytesRead)) != -1) continue;
            throw new IOException("Unexpected EOF while reading S2 bytes 0-3");
        } while ((totalBytesRead += read) < 4);
        totalBytesRead = 0;
        do {
            if ((read = in.read(s2_serverVersion, totalBytesRead, 4 - totalBytesRead)) != -1) continue;
            throw new IOException("Unexpected EOF while reading S2 bytes 4-7");
        } while ((totalBytesRead += read) < 4);
        int remainingBytes = 1528;
        totalBytesRead = 0;
        do {
            if ((read = in.read(s2_rest, totalBytesRead, 1528 - totalBytesRead)) == -1) continue;
            totalBytesRead += read;
        } while (totalBytesRead < 1528 && read != -1);
        if (totalBytesRead != 1528) {
            throw new IOException("Unexpected EOF while reading remainder of S2, expected 1528 bytes, but only read " + totalBytesRead + " bytes");
        }
        AmityLog.INSTANCE.tag(TAG).d("readS2(): S2 total bytes read OK", new Object[0]);
    }
}

