/*
 * Decompiled with CFR 0.152.
 */
package com.amity.github.faucamp.simplertmp.amf;

import com.amity.github.faucamp.simplertmp.Util;
import com.amity.github.faucamp.simplertmp.amf.AmfData;
import com.amity.github.faucamp.simplertmp.amf.AmfType;
import com.amity.socialcloud.sdk.log.AmityLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class AmfString
implements AmfData {
    private static final String TAG = "AmfString";
    private String value;
    private boolean key;
    private int size = -1;

    public AmfString() {
    }

    public AmfString(String value, boolean isKey) {
        this.value = value;
        this.key = isKey;
    }

    public AmfString(String value) {
        this(value, false);
    }

    public AmfString(boolean isKey) {
        this.key = isKey;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        byte[] byteValue = this.value.getBytes("ASCII");
        if (!this.key) {
            out.write(AmfType.STRING.getValue());
        }
        Util.writeUnsignedInt16(out, byteValue.length);
        out.write(byteValue);
    }

    @Override
    public void readFrom(InputStream in) throws IOException {
        int length = Util.readUnsignedInt16(in);
        this.size = 3 + length;
        byte[] byteValue = new byte[length];
        Util.readBytesUntilFull(in, byteValue);
        this.value = new String(byteValue, "ASCII");
    }

    public static String readStringFrom(InputStream in, boolean isKey) throws IOException {
        if (!isKey) {
            in.read();
        }
        int length = Util.readUnsignedInt16(in);
        byte[] byteValue = new byte[length];
        Util.readBytesUntilFull(in, byteValue);
        return new String(byteValue, "ASCII");
    }

    public static void writeStringTo(OutputStream out, String string, boolean isKey) throws IOException {
        byte[] byteValue = string.getBytes("ASCII");
        if (!isKey) {
            out.write(AmfType.STRING.getValue());
        }
        Util.writeUnsignedInt16(out, byteValue.length);
        out.write(byteValue);
    }

    @Override
    public int getSize() {
        if (this.size == -1) {
            try {
                this.size = (this.isKey() ? 0 : 1) + 2 + this.value.getBytes("ASCII").length;
            }
            catch (UnsupportedEncodingException ex) {
                AmityLog.INSTANCE.tag(TAG).e("AmfString.getSize(): caught exception", new Object[]{ex});
                throw new RuntimeException(ex);
            }
        }
        return this.size;
    }

    public static int sizeOf(String string, boolean isKey) {
        try {
            int size = (isKey ? 0 : 1) + 2 + string.getBytes("ASCII").length;
            return size;
        }
        catch (UnsupportedEncodingException ex) {
            AmityLog.INSTANCE.tag(TAG).e("AmfString.SizeOf(): caught exception", new Object[]{ex});
            throw new RuntimeException(ex);
        }
    }
}

