package com.amity.socialcloud.sdk.video

import com.amity.socialcloud.sdk.video.model.AmityStreamBroadcasterState
import io.reactivex.rxjava3.core.Flowable

interface StreamBroadcaster {
	fun startPreview()
	
	fun stopPreview()
	
	fun startPublishNewStream(title: String, description: String)
	
	fun startPublish(streamId: String)
	
	fun stopPublish()

	fun stopPublishWithNoInternet()
	
	fun switchCamera()
	
	fun updateConfiguration(configuration: AmityStreamBroadcasterConfiguration)
	
	fun pausePublish()
	
	fun resumePublish()
	
	fun startAudio()
	
	fun stopAudio()
	
	fun getStateFlowable(): Flowable<AmityStreamBroadcasterState>
}